/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class AzimuthalEquidistantOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    protected double Ra = 0.0;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        this.Ra = this.a * (1.0 - this.es / 6.0 - 17.0 * (this.es * this.es) / 360.0 - 67.0 * this.es * this.es * this.es / 3024.0);
        return true;
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double Easting = 0.0;
        double Northing = 0.0;
        double dlam = lambda - this.lambda0;
        if (dlam > Math.PI) {
            dlam -= Math.PI * 2;
        }
        if (dlam < -Math.PI) {
            dlam += Math.PI * 2;
        }
        if (Math.abs(Math.abs(this.phi0) - 1.5707963267948966) < 1.0E-10) {
            if (this.phi0 >= 0.0) {
                double Ra_PI_OVER_2_Lat = this.Ra * (1.5707963267948966 - phi);
                Easting = Ra_PI_OVER_2_Lat * Math.sin(dlam) + this.FE;
                Northing = -1.0 * (Ra_PI_OVER_2_Lat * Math.cos(dlam)) + this.FN;
            } else {
                double Ra_PI_OVER_2_Lat = this.Ra * (1.5707963267948966 + phi);
                Easting = Ra_PI_OVER_2_Lat * Math.sin(dlam) + this.FE;
                Northing = Ra_PI_OVER_2_Lat * Math.cos(dlam) + this.FN;
            }
        } else if (Math.abs(this.phi0) <= 1.0E-10) {
            double cos_c = Math.cos(phi) * Math.cos(dlam);
            if (Math.abs(Math.abs(cos_c) - 1.0) < 1.0E-14) {
                if (cos_c >= 0.0) {
                    Easting = this.FE;
                    Northing = this.FN;
                }
            } else {
                double c = Math.acos(cos_c);
                double k_prime = c / Math.sin(c);
                double Ra_kprime = this.Ra * k_prime;
                Easting = Ra_kprime * Math.cos(phi) * Math.sin(dlam) + this.FE;
                Northing = Ra_kprime * Math.sin(phi) + this.FN;
            }
        } else {
            double cos_c = Math.sin(this.phi0) * Math.sin(phi) + Math.cos(this.phi0) * Math.cos(phi) * Math.cos(dlam);
            if (Math.abs(Math.abs(cos_c) - 1.0) < 1.0E-14) {
                if (cos_c >= 0.0) {
                    Easting = this.FE;
                    Northing = this.FN;
                }
            } else {
                double c = Math.cos(cos_c);
                double k_prime = c / Math.sin(c);
                double Ra_kprime = this.Ra * k_prime;
                Easting = Ra_kprime * Math.cos(phi) * Math.sin(dlam) + this.FE;
                Northing = Ra_kprime * (Math.cos(this.phi0) * Math.sin(phi) - Math.sin(this.phi0) * Math.cos(phi) * Math.cos(dlam)) + this.FN;
            }
        }
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double lambda;
        double phi;
        double dx = Easting - this.FE;
        double dy = Northing - this.FN;
        double rho = Math.sqrt(dx * dx + dy * dy);
        if (Math.abs(rho) <= 1.0E-10) {
            phi = this.phi0;
            lambda = this.lambda0;
        } else {
            double c = rho / this.Ra;
            double sin_c = Math.sin(c);
            double cos_c = Math.cos(c);
            double dy_sinc = dy * sin_c;
            phi = Math.asin(cos_c * Math.sin(this.phi0) + dy_sinc * Math.cos(this.phi0) / rho);
            lambda = Math.abs(Math.abs(this.phi0) - 1.5707963267948966) < 1.0E-10 ? (this.phi0 >= 0.0 ? this.lambda0 + Math.atan2(dx, -dy) : this.lambda0 + Math.atan2(dx, dy)) : this.lambda0 + Math.atan2(dx * sin_c, rho * Math.cos(this.phi0) * cos_c - dy_sinc * Math.sin(this.phi0));
        }
        if (phi > 1.5707963267948966) {
            phi = 1.5707963267948966;
        } else if (phi < -1.5707963267948966) {
            phi = -1.5707963267948966;
        }
        if (lambda > Math.PI) {
            lambda -= Math.PI * 2;
        }
        if (lambda < -Math.PI) {
            lambda += Math.PI * 2;
        }
        if (lambda > Math.PI) {
            lambda = Math.PI;
        } else if (lambda < -Math.PI) {
            lambda = -Math.PI;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

