/*
 * Decompiled with CFR 0.152.
 */
package org.alov.projections;

import org.alov.map.FloatPoint;
import org.alov.projections.Operation;

public class AlbersEqualAreaConicOperation
extends Operation {
    protected double lambda0 = 0.0;
    protected double phi0 = 0.0;
    protected double FE = 0.0;
    protected double FN = 0.0;
    private double phi1 = this.toRadians(40.0);
    private double phi2 = this.toRadians(50.0);
    protected double C = 0.0;
    protected double rho0 = 0.0;
    protected double n = 0.0;

    public boolean prepare() {
        String value = this.properties.getProperty("8802");
        if (null != value) {
            this.lambda0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8801"))) {
            this.phi0 = this.toRadians(Double.valueOf(value));
        }
        if (null != (value = this.properties.getProperty("8806"))) {
            this.FE = Double.valueOf(value);
        }
        if (null != (value = this.properties.getProperty("8807"))) {
            this.FN = Double.valueOf(value);
        }
        if (this.a <= 0.0) {
            return false;
        }
        value = this.properties.getProperty("8823");
        String value2 = this.properties.getProperty("8824");
        if (value != null && value2 != null) {
            this.phi1 = this.toRadians(Double.valueOf(value));
            this.phi2 = this.toRadians(Double.valueOf(value2));
            if (this.phi1 < -1.5707963267948966 || this.phi1 > 1.5707963267948966) {
                return false;
            }
            if (this.phi2 < -1.5707963267948966 || this.phi2 > 1.5707963267948966) {
                return false;
            }
            if (this.phi1 == 0.0 && this.phi2 == 0.0) {
                return false;
            }
            if (this.phi1 == -this.phi2) {
                return false;
            }
        } else {
            return false;
        }
        this.calc_C_n_rho0();
        return true;
    }

    private double calc_m(double clat, double oneminussqressin) {
        return clat / Math.sqrt(oneminussqressin);
    }

    private double calc_q(double slat, double oneminussqressin, double essin) {
        return (1.0 - this.es) * (slat / oneminussqressin - 1.0 / (2.0 * this.e) * Math.log((1.0 - essin) / (1.0 + essin)));
    }

    private void calc_C_n_rho0() {
        double sin_lat = Math.sin(this.phi0);
        double es_sin = this.e * sin_lat;
        double one_MINUS_SQRes_sin = 1.0 - es_sin * es_sin;
        double q0 = this.calc_q(sin_lat, one_MINUS_SQRes_sin, es_sin);
        double sin_lat_1 = Math.sin(this.phi1);
        double cos_lat = Math.cos(this.phi1);
        es_sin = this.e * sin_lat_1;
        one_MINUS_SQRes_sin = 1.0 - es_sin * es_sin;
        double m1 = this.calc_m(cos_lat, one_MINUS_SQRes_sin);
        double q1 = this.calc_q(sin_lat_1, one_MINUS_SQRes_sin, es_sin);
        double SQRm1 = m1 * m1;
        if (Math.abs(this.phi1 - this.phi2) > 1.0E-10) {
            sin_lat = Math.sin(this.phi2);
            cos_lat = Math.cos(this.phi2);
            es_sin = this.e * sin_lat;
            one_MINUS_SQRes_sin = 1.0 - es_sin * es_sin;
            double m2 = this.calc_m(cos_lat, one_MINUS_SQRes_sin);
            double q2 = this.calc_q(sin_lat, one_MINUS_SQRes_sin, es_sin);
            this.n = (SQRm1 - m2 * m2) / (q2 - q1);
        } else {
            this.n = sin_lat_1;
        }
        this.C = SQRm1 + this.n * q1;
        double nq0 = this.n * q0;
        this.rho0 = this.C < nq0 ? 0.0 : this.a / this.n * Math.sqrt(this.C - nq0);
    }

    public FloatPoint transform(double x, double y) {
        double phi = this.toRadians(y);
        double lambda = this.toRadians(x);
        double dlam = lambda - this.lambda0;
        if (dlam > Math.PI) {
            dlam -= Math.PI * 2;
        }
        if (dlam < -Math.PI) {
            dlam += Math.PI * 2;
        }
        double sin_lat = Math.sin(phi);
        double cos_lat = Math.cos(phi);
        double es_sin = this.e * sin_lat;
        double one_MINUS_SQRes_sin = 1.0 - es_sin * es_sin;
        double q = this.calc_q(sin_lat, one_MINUS_SQRes_sin, es_sin);
        double nq = this.n * q;
        double rho = this.C < nq ? 0.0 : this.a / this.n * Math.sqrt(this.C - nq);
        double theta = this.n * dlam;
        double Easting = rho * Math.sin(theta) + this.FE;
        double Northing = this.rho0 - rho * Math.cos(theta) + this.FN;
        return new FloatPoint(Easting, Northing);
    }

    public FloatPoint inverseTransform(double Easting, double Northing) {
        double phi;
        double Delta_PHI = 1.0;
        double theta = 0.0;
        double tolerance = 4.85E-8;
        double dy = Northing - this.FN;
        double dx = Easting - this.FE;
        double rho0_MINUS_dy = this.rho0 - dy;
        double rho = Math.sqrt(dx * dx + rho0_MINUS_dy * rho0_MINUS_dy);
        if (this.n < 0.0) {
            rho *= -1.0;
            dy *= -1.0;
            dx *= -1.0;
            rho0_MINUS_dy *= -1.0;
        }
        if (rho != 0.0) {
            theta = Math.atan2(dx, rho0_MINUS_dy);
        }
        double rho_n = rho * this.n;
        double q = (this.C - rho_n * rho_n / (this.a * this.a)) / this.n;
        double qconst = 1.0 - (1.0 - this.es) / (2.0 * this.e) * Math.log((1.0 - this.es) / (1.0 + this.es));
        if (Math.abs(Math.abs(qconst) - Math.abs(q)) > 1.0E-6) {
            double q_OVER_2 = q / 2.0;
            if (q_OVER_2 > 1.0) {
                phi = 1.5707963267948966;
            } else if (q_OVER_2 < -1.0) {
                phi = -1.5707963267948966;
            } else {
                double PHI = Math.asin(q_OVER_2);
                if (this.es < 1.0E-10) {
                    phi = PHI;
                } else {
                    while (Math.abs(Delta_PHI) > tolerance) {
                        double sin_phi = Math.sin(PHI);
                        double es_sin = sin_phi * this.e;
                        double one_MINUS_SQRes_sin = 1.0 - es_sin * es_sin;
                        Delta_PHI = one_MINUS_SQRes_sin * one_MINUS_SQRes_sin / (2.0 * Math.cos(PHI)) * (q / (1.0 - this.es) - sin_phi / one_MINUS_SQRes_sin + Math.log((1.0 - es_sin) / (1.0 + es_sin)) / (2.0 * this.e));
                        PHI += Delta_PHI;
                    }
                    phi = PHI;
                }
                if (phi > 1.5707963267948966) {
                    phi = 1.5707963267948966;
                } else if (phi < -1.5707963267948966) {
                    phi = -1.5707963267948966;
                }
            }
        } else {
            phi = q >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double lambda = this.lambda0 + theta / this.n;
        if (lambda > Math.PI) {
            lambda -= Math.PI * 2;
        }
        if (lambda < -Math.PI) {
            lambda += Math.PI * 2;
        }
        if (lambda > Math.PI) {
            lambda = Math.PI;
        } else if (lambda < -Math.PI) {
            lambda = -Math.PI;
        }
        return new FloatPoint(this.toDegrees(lambda), this.toDegrees(phi));
    }
}

