/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import org.alov.data.Gml;
import org.alov.map.FloatRectangle;
import org.alov.ogcfilter.FilterConst;
import org.alov.ogcfilter.FilterException;
import org.alov.ogcfilter.OgcOperation;
import org.alov.ogcfilter.WfsFieldList;
import org.alov.util.XmlElement;

public class SpatialOperation
extends OgcOperation
implements FilterConst {
    private static final String AND_STR = " AND ";
    private static final String OR_STR = " OR ";
    private static final String GTE_STR = ">=";
    private static final String LTE_STR = "<=";
    public String propertyName = null;
    public FloatRectangle bbox = null;

    public SpatialOperation(int type, WfsFieldList list) {
        this.type = type;
        this.name = OgcOperation.getOperationName(type);
        this.fieldList = list;
    }

    public SpatialOperation(XmlElement root, String name, int type) throws FilterException {
        this.name = name;
        this.type = type;
        switch (type) {
            case 301: 
            case 303: 
            case 306: 
            case 307: 
            case 310: {
                if (root.getChildren().size() != 2) {
                    throw new FilterException("Invalid Binary spatial operation format: missing elements");
                }
                XmlElement xmlProp = root.getFirstElementByName("PropertyName");
                if (xmlProp == null) {
                    throw new FilterException("Invalid Binary spatial operation format: missing propertyName");
                }
                this.propertyName = xmlProp.value;
                xmlProp = root.getFirstElementByName("Box");
                if (xmlProp != null) {
                    try {
                        this.bbox = Gml.getGMLBox(xmlProp);
                        break;
                    }
                    catch (Exception e) {
                        throw new FilterException(e.getMessage());
                    }
                }
                throw new FilterException("Invalid Binary spatial operation format: missing Box");
            }
            default: {
                throw new FilterException("Unsupported spatial operation: " + name);
            }
        }
    }

    private StringBuffer withinSQL() {
        StringBuffer result = new StringBuffer();
        if (this.fieldList.obj_type == 1) {
            result.append(this.fieldList.sF_X).append(GTE_STR).append(this.bbox.x);
            result.append(AND_STR);
            result.append(this.fieldList.sF_Y).append(GTE_STR).append(this.bbox.y);
            result.append(AND_STR);
            result.append(this.fieldList.sF_X).append(LTE_STR).append(this.bbox.x2);
            result.append(AND_STR);
            result.append(this.fieldList.sF_Y).append(LTE_STR).append(this.bbox.y2);
        } else {
            result.append(this.fieldList.sF_Xmin).append(GTE_STR).append(this.bbox.x);
            result.append(AND_STR);
            result.append(this.fieldList.sF_Ymin).append(GTE_STR).append(this.bbox.y);
            result.append(AND_STR);
            result.append(this.fieldList.sF_Xmax).append(LTE_STR).append(this.bbox.x2);
            result.append(AND_STR);
            result.append(this.fieldList.sF_Ymax).append(LTE_STR).append(this.bbox.y2);
        }
        return result;
    }

    private StringBuffer containsSQL() throws FilterException {
        StringBuffer result = new StringBuffer();
        if (this.fieldList.obj_type == 1) {
            throw new FilterException("A point can't contain box");
        }
        result.append(this.bbox.x).append(GTE_STR).append(this.fieldList.sF_Xmin);
        result.append(AND_STR);
        result.append(this.bbox.y).append(GTE_STR).append(this.fieldList.sF_Ymin);
        result.append(AND_STR);
        result.append(this.bbox.x2).append(LTE_STR).append(this.fieldList.sF_Xmax);
        result.append(AND_STR);
        result.append(this.bbox.y2).append(LTE_STR).append(this.fieldList.sF_Ymax);
        return result;
    }

    private StringBuffer disjointSQL() {
        StringBuffer result = new StringBuffer();
        if (this.fieldList.obj_type == 1) {
            result.append(this.fieldList.sF_X).append('<').append(this.bbox.x);
            result.append(OR_STR);
            result.append(this.fieldList.sF_Y).append('<').append(this.bbox.y);
            result.append(OR_STR);
            result.append(this.fieldList.sF_X).append('>').append(this.bbox.x2);
            result.append(OR_STR);
            result.append(this.fieldList.sF_Y).append('>').append(this.bbox.y2);
        } else {
            result.append(this.fieldList.sF_Xmin).append('>').append(this.bbox.x2);
            result.append(OR_STR);
            result.append(this.fieldList.sF_Ymin).append('>').append(this.bbox.y2);
            result.append(OR_STR);
            result.append(this.fieldList.sF_Xmax).append('<').append(this.bbox.x);
            result.append(OR_STR);
            result.append(this.fieldList.sF_Ymax).append('<').append(this.bbox.y);
        }
        return result;
    }

    public StringBuffer constructSQL() throws FilterException {
        StringBuffer result;
        block7: {
            block6: {
                result = new StringBuffer();
                result.append("(");
                this.propertyName = this.propertyName.trim();
                if (!this.propertyName.equalsIgnoreCase(this.fieldList.sF_Geo)) break block6;
                switch (this.type) {
                    case 303: {
                        result.append(this.withinSQL());
                        break block7;
                    }
                    case 307: {
                        result.append(this.containsSQL());
                        break block7;
                    }
                    case 306: 
                    case 310: {
                        result.append("NOT(").append(this.disjointSQL()).append(")");
                        break block7;
                    }
                    case 301: {
                        result.append(this.disjointSQL());
                        break block7;
                    }
                    default: {
                        throw new FilterException("Unsupported spatial operation: " + this.name);
                    }
                }
            }
            throw new FilterException("Spatial operation cannot be applied to non-spatial field:" + this.propertyName + ":" + this.fieldList.sF_Geo);
        }
        result.append(")");
        return result;
    }

    public static XmlElement getGmlBox(FloatRectangle rect) {
        XmlElement root = new XmlElement("Box");
        XmlElement coords = new XmlElement("coordinates");
        coords.value = Double.toString(rect.x) + "," + Double.toString(rect.y) + " " + Double.toString(rect.x2) + "," + Double.toString(rect.y2);
        root.addChild(coords);
        return root;
    }

    public XmlElement getXml() {
        XmlElement root = null;
        if (this.type == 310) {
            root = new XmlElement(this.name);
            root.addChildElement("PropertyName", this.propertyName);
            root.addChild(SpatialOperation.getGmlBox(this.bbox));
        }
        return root;
    }
}

