/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import org.alov.ogcfilter.FilterConst;
import org.alov.ogcfilter.FilterException;
import org.alov.ogcfilter.WfsFieldList;
import org.alov.util.Strings;
import org.alov.util.XmlElement;

public abstract class OgcOperation
implements FilterConst {
    public WfsFieldList fieldList;
    public String name = null;
    public int type = -1;

    public void setFieldList(WfsFieldList list) {
        this.fieldList = list;
    }

    public void setType() {
        this.type = OgcOperation.getOperationType(this.name);
    }

    public static boolean isOperation(String name) {
        boolean result = false;
        if (Strings.arrayContains(name, FilterConst.LOGICAL_OPS) > -1 || Strings.arrayContains(name, FilterConst.COMPARISON_OPS) > -1 || Strings.arrayContains(name, FilterConst.SPATIAL_OPS) > -1) {
            result = true;
        }
        return result;
    }

    public boolean isSpatial() {
        return Strings.arrayContains(this.name, FilterConst.SPATIAL_OPS) > -1;
    }

    public boolean isLogical() {
        return Strings.arrayContains(this.name, FilterConst.LOGICAL_OPS) > -1;
    }

    public boolean isComparison() {
        return Strings.arrayContains(this.name, FilterConst.COMPARISON_OPS) > -1;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("Operation ").append(this.name).append("\n");
        res.append("  type: ").append(this.type);
        return res.toString();
    }

    public abstract StringBuffer constructSQL() throws FilterException;

    public abstract XmlElement getXml();

    public static String getOperationName(int type) {
        String result = "";
        if (type >= 100 && type <= 199) {
            result = FilterConst.LOGICAL_OPS[type - 100];
        } else if (type >= 300 && type <= 399) {
            result = FilterConst.SPATIAL_OPS[type - 300];
        } else if (type >= 200 && type <= 299) {
            result = FilterConst.COMPARISON_OPS[type - 200];
        }
        return result;
    }

    public static int getOperationType(String name) {
        int result = -1;
        int index = Strings.arrayContains(name, FilterConst.LOGICAL_OPS);
        if (index > -1) {
            result = 100 + index;
        } else {
            index = Strings.arrayContains(name, FilterConst.SPATIAL_OPS);
            if (index > -1) {
                result = 300 + index;
            } else {
                index = Strings.arrayContains(name, FilterConst.COMPARISON_OPS);
                if (index > -1) {
                    result = 200 + index;
                }
            }
        }
        return result;
    }
}

