/*
 * Decompiled with CFR 0.152.
 */
package org.alov.ogcfilter;

import java.util.List;
import java.util.Vector;
import org.alov.ogcfilter.ComparisonOperation;
import org.alov.ogcfilter.FilterConst;
import org.alov.ogcfilter.FilterException;
import org.alov.ogcfilter.LogicalOperation;
import org.alov.ogcfilter.OgcOperation;
import org.alov.ogcfilter.SpatialOperation;
import org.alov.ogcfilter.WfsFieldList;
import org.alov.util.Strings;
import org.alov.util.XmlElement;

public class Filter
implements FilterConst {
    public List featureIDs = new Vector();
    public OgcOperation operation = null;

    public void setFieldList(WfsFieldList list) {
        if (this.operation != null) {
            this.operation.setFieldList(list);
        }
    }

    public Filter() {
    }

    public boolean isEmpty() {
        return this.operation == null && this.featureIDs.isEmpty();
    }

    public Filter(XmlElement root) throws FilterException {
        Vector operations;
        Vector features = root.getElementsByTagName("FeatureId");
        if (features != null && features.size() > 0) {
            for (int i = 0; i < features.size(); ++i) {
                XmlElement elFID = (XmlElement)features.elementAt(i);
                String fid = elFID.getAttributeValue("fid");
                if (Strings.isNullOrBlank(fid)) continue;
                this.featureIDs.add(fid);
            }
        }
        if ((operations = root.getChildren()) != null && operations.size() > 0) {
            if (features != null && features.size() > 0) {
                operations.removeAll(features);
            }
            if (operations.size() > 1) {
                throw new FilterException("Filter supports one operation only");
            }
            for (int i = 0; i < operations.size(); ++i) {
                this.operation = Filter.createOperation((XmlElement)operations.elementAt(i));
            }
        }
    }

    public XmlElement getXml() {
        XmlElement root = new XmlElement("Filter");
        for (int i = 0; i < this.featureIDs.size(); ++i) {
            XmlElement elFeature = new XmlElement("FeatureId");
            elFeature.addAttribute("fid", (String)this.featureIDs.get(i));
            root.addChild(elFeature);
        }
        if (this.operation != null) {
            root.addChild(this.operation.getXml());
        }
        return root;
    }

    public static OgcOperation createOperation(XmlElement root) throws FilterException {
        OgcOperation operation;
        String name = root.getNodeName();
        int type = OgcOperation.getOperationType(name);
        if (type >= 100 && type <= 199) {
            operation = new LogicalOperation(root, name, type);
        } else if (type >= 200 && type <= 299) {
            operation = new ComparisonOperation(root, name, type);
        } else if (type >= 300 && type <= 399) {
            operation = new SpatialOperation(root, name, type);
        } else {
            throw new FilterException("The operation with name " + name + " does not exist or is not supported. " + "Please refer to developers");
        }
        return operation;
    }
}

