/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.IOException;
import java.io.InputStream;
import org.alov.map.Carte;
import org.alov.util.Const;
import org.alov.util.Strings;

public class StreamCounter
extends InputStream
implements Const {
    private InputStream input;
    private long received = 0L;
    private long receivedTot = 0L;
    private long nextStep = 0L;
    private int stepThreshold;
    private long completeSize = 0L;
    private String layerName = "";
    private String completeSizeFormatted = null;
    private Carte map = null;
    public String url = null;
    static final String _MB = " MB";
    static final String _KB = " KB";

    StreamCounter(InputStream is, int step, Carte map) {
        if (is == null) {
            throw new NullPointerException();
        }
        this.input = is;
        this.stepThreshold = step;
        this.map = map;
    }

    long getReceived() {
        return this.receivedTot;
    }

    void setCounter(long completeSize, String layerName) {
        this.received = 0L;
        this.completeSize = completeSize;
        this.layerName = layerName;
        this.completeSizeFormatted = completeSize > 0x100000L ? Strings.doubleToStr((float)completeSize / 1048576.0f, 10) + _MB : (completeSize > 20480L ? Strings.doubleToStr((float)completeSize / 1024.0f, 10) + _KB : (completeSize > 1024L ? completeSize / 1024L + _KB : String.valueOf(completeSize)));
    }

    void checkStep(int incr) {
        if (incr > 0) {
            this.received += (long)incr;
            this.receivedTot += (long)incr;
            if (this.map != null) {
                if (this.completeSize > 0L) {
                    long k = this.received * 100L / this.completeSize;
                    if (k - this.nextStep >= 1L) {
                        String s = k + "% of " + this.completeSizeFormatted + this.layerName;
                        this.map.broadcastMessage(4, s);
                    }
                    this.nextStep = k;
                } else {
                    if (this.received - this.nextStep >= (long)this.stepThreshold) {
                        this.map.broadcastMessage(11, this.received + this.layerName);
                    }
                    this.nextStep = this.received;
                }
            }
        }
    }

    public int read() throws IOException {
        int n = this.input.read();
        this.checkStep(1);
        return n;
    }

    public int read(byte[] b) throws IOException {
        int n = this.input.read(b);
        this.checkStep(n);
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.input.read(b, off, len);
        this.checkStep(n);
        return n;
    }

    public long skip(long len) throws IOException {
        long n = this.input.skip(len);
        this.checkStep(new Long(n).intValue());
        return n;
    }

    public int available() throws IOException {
        return this.input.available();
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void mark(int limit) {
        this.input.mark(limit);
    }

    public void reset() throws IOException {
        this.input.reset();
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }
}

