/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import org.alov.map.SLD_Const;
import org.alov.map.SLD_Fill;
import org.alov.map.SLD_Stroke;
import org.alov.map.Symbol;
import org.alov.util.AlovMapException;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class SLD_Mark
implements SLD_Const {
    static final String M_SQUARE = "square";
    static final String M_CIRCLE = "circle";
    static final String M_TRIANGLE = "triangle";
    static final String M_CROSS = "cross";
    String name = null;
    SLD_Fill fill = null;
    SLD_Stroke stroke = null;

    SLD_Mark(XmlElement root) throws AlovMapException {
        this.name = XmlUtils.getElString("WellKnownName", root, null);
        XmlElement el = root.getFirstElementByName("Fill");
        if (el != null) {
            this.fill = new SLD_Fill(el);
        }
        if ((el = root.getFirstElementByName("Stroke")) != null) {
            this.stroke = new SLD_Stroke(el);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean assignMark(Symbol sym) {
        if (this.name != null) {
            if (this.name.equalsIgnoreCase(M_SQUARE)) {
                sym.style = 1;
            } else if (this.name.equalsIgnoreCase(M_CIRCLE)) {
                sym.style = 0;
            } else if (this.name.equalsIgnoreCase(M_TRIANGLE)) {
                sym.style = 2;
            } else {
                if (!this.name.equalsIgnoreCase(M_CROSS)) return false;
                sym.style = 3;
            }
        } else if (this.fill == null && this.stroke == null) {
            sym.fill = true;
            sym.fillColor = Color.gray;
            sym.outline = true;
            sym.outlineColor = Color.black;
        }
        if (this.fill != null) {
            sym.fill = true;
            sym.fillColor = this.fill.getFillColor();
        }
        if (this.stroke == null) return true;
        sym.outline = true;
        sym.outlineColor = this.stroke.getStrokeColor();
        return true;
    }
}

