/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.util.Vector;
import org.alov.map.Layer;
import org.alov.map.Project;
import org.alov.map.SLD_Const;
import org.alov.map.SLD_FTC;
import org.alov.map.SLD_FTS;
import org.alov.map.SLD_NamedStyle;
import org.alov.map.SLD_Rule;
import org.alov.map.SLD_UserStyle;
import org.alov.ogcfilter.Filter;
import org.alov.ogcfilter.LogicalOperation;
import org.alov.util.AlovMapException;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

class SLD_Layer
implements SLD_Const {
    String name = null;
    Vector featureConstraints = new Vector();
    Vector styles = new Vector();

    SLD_Layer(XmlElement root) throws AlovMapException {
        int i;
        this.name = XmlUtils.getElString("Name", root, null);
        if (Strings.isNullOrBlank(this.name)) {
            throw new AlovMapException(312, "Missing name in NamedLayer");
        }
        XmlElement el = root.getFirstElementByName("LayerFeatureConstraints");
        if (el != null) {
            this.addLayerFeatureConstraints(el);
        }
        Vector v = root.getElementsByTagName("NamedStyle");
        for (i = 0; i < v.size(); ++i) {
            el = (XmlElement)v.elementAt(i);
            this.styles.addElement(new SLD_NamedStyle(el));
        }
        v = root.getElementsByTagName("UserStyle");
        for (i = 0; i < v.size(); ++i) {
            el = (XmlElement)v.elementAt(i);
            this.styles.addElement(new SLD_UserStyle(el));
        }
    }

    void addLayerFeatureConstraints(XmlElement root) throws AlovMapException {
        try {
            Vector v = root.getElementsByTagName("FeatureTypeConstraint");
            for (int i = 0; i < v.size(); ++i) {
                XmlElement el = (XmlElement)v.elementAt(i);
                this.featureConstraints.addElement(new SLD_FTC(el));
            }
        }
        catch (Exception e) {
            throw new AlovMapException(312, e.getMessage());
        }
    }

    SLD_UserStyle getDefStyle() {
        for (int i = 0; i < this.styles.size(); ++i) {
            SLD_UserStyle style = (SLD_UserStyle)this.styles.elementAt(i);
            if (!style.IsDefault) continue;
            return style;
        }
        return null;
    }

    SLD_UserStyle getStyle(String nme) {
        for (int i = 0; i < this.styles.size(); ++i) {
            SLD_UserStyle style = (SLD_UserStyle)this.styles.elementAt(i);
            if (!style.Name.equalsIgnoreCase(nme)) continue;
            return style;
        }
        return this.getDefStyle();
    }

    public Layer transform(Project prj, String sname) throws AlovMapException {
        Layer layer = prj.getLayerByName(this.name);
        SLD_UserStyle style = this.getStyle(sname);
        if (style == null) {
            throw new AlovMapException(312, "Style with name \"" + sname + "\" is not defined");
        }
        if (style.featTypeStyle.size() < 1) {
            throw new AlovMapException(312, "Style \"" + sname + "\" is not described");
        }
        SLD_FTS fts = (SLD_FTS)style.featTypeStyle.elementAt(0);
        layer.renderers = new Vector();
        int c = fts.rules.size();
        Filter filter = new Filter();
        for (int i = 0; i < c; ++i) {
            SLD_Rule rule = (SLD_Rule)fts.rules.elementAt(i);
            if (rule.isElseFilterPresent) {
                rule.elseFilter = filter;
            }
            layer.renderers.addAll(rule.transform(layer));
            if (rule.isElseFilterPresent || rule.filter == null || rule.filter.operation == null) continue;
            if (filter.operation != null) {
                LogicalOperation op = new LogicalOperation(101);
                op.operations.addElement(filter.operation);
                op.operations.addElement(rule.filter.operation);
                filter.operation = op;
                continue;
            }
            filter.operation = rule.filter.operation;
        }
        layer.notPrepared = true;
        return layer;
    }
}

