/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterExpression;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Renderer;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.Strings;

public class RendererLabel
extends Renderer {
    public int[] labelFieldIndex = null;
    public int symbolFieldIndex = 0;
    public int houseFromLeftFieldIndex = 0;
    public int houseToLeftFieldIndex = 0;
    public int houseFromRightFieldIndex = 0;
    public int houseToRightFieldIndex = 0;
    public String labelFieldName = null;
    public String symbolFieldName = null;
    public String houseNumberFieldNames = null;
    public String rotationFieldName = null;
    public String sizeFieldName = null;
    protected int rotationFieldIndex = -1;
    protected int sizeFieldIndex = -1;
    public boolean drawDefault = false;
    public boolean notOverlap = true;
    private static final byte DRAW_IN_CENTROID = 0;
    private static final byte DRAW_ALONG_LINE = 1;
    private static final byte DRAW_ROTATE = 2;
    private static final byte DRAW_IN_FRAME = 3;
    private static final byte DRAW_IN_BULB = 4;
    static final double UNION_EPS = 1.0E-5;
    private static final byte STREETS_DRAW_ALL = 0;
    private static final byte STREETS_DRAW_FIRST = 1;
    private static final byte STREETS_DRAW_UNITED = 2;
    public int streetDrawingMode = 0;
    private Vector recordsToPaint = null;
    private Vector recsAndStreets = null;
    private boolean unitedPainting = false;
    private Vector drawedStreets = null;
    static final double std_offset_from_line = 20.0;
    static final double std_offset_from_ends = 20.0;

    public RendererLabel(Layer layer) {
        super(layer);
    }

    private String getLabelString(Record rec) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.labelFieldIndex.length; ++i) {
            sb.append(this.layer.getFieldString(rec, this.labelFieldIndex[i])).append(" ");
        }
        return sb.toString().trim();
    }

    public void paintRecord(Record rec, boolean selected, DisplayContext dc) {
        int sizeField;
        if (selected) {
            return;
        }
        Graphics g = dc.getDrawToGraphics();
        int shpCount = rec.getShapeCount();
        String sLabelText = this.getDrawStreetName(this.getLabelString(rec));
        if (g == null || shpCount == 0 || Strings.isNullOrBlank(sLabelText)) {
            return;
        }
        if (!this.unitedPainting && this.streetDrawingMode == 2) {
            this.recordsToPaint.addElement(rec);
            return;
        }
        int houseFromLeft = 0;
        int houseToLeft = 0;
        int houseFromRight = 0;
        int houseToRight = 0;
        if (this.houseNumberFieldNames != null) {
            houseFromLeft = (int)this.layer.getFieldDouble(rec, this.houseFromLeftFieldIndex);
            houseToLeft = (int)this.layer.getFieldDouble(rec, this.houseToLeftFieldIndex);
            houseFromRight = (int)this.layer.getFieldDouble(rec, this.houseFromRightFieldIndex);
            houseToRight = (int)this.layer.getFieldDouble(rec, this.houseToRightFieldIndex);
        }
        Symbol sym = null;
        Symbol[] syms = this.symbols;
        boolean index = false;
        int count = syms.length;
        if (this.symbolFieldIndex < 0) {
            for (int i = 0; i < count; ++i) {
                Symbol s = syms[i];
                if (s.value == null || !s.value.equals("") && !((FilterExpression)s.value).checkRecord(rec)) continue;
                sym = s;
                break;
            }
        } else {
            Object o = this.layer.getFieldValue(rec, this.symbolFieldIndex);
            for (int i = 0; i < count; ++i) {
                Symbol s = syms[i];
                int res = MapUtils.compare(o, s.value);
                if (res != this.equal) continue;
                if (sym == null || MapUtils.compare(s.value, sym.value) == this.equal) {
                    sym = s;
                }
                if (this.equal == 0) break;
            }
            if (this.equal < 0 && sym == null) {
                sym = syms[count - 1];
            }
        }
        if (sym == null || !sym.visible || Strings.isNullOrBlank(sym.fontName)) {
            return;
        }
        Projection projection = dc.getProjection();
        int n = sizeField = sym.sizeFieldIndex >= 0 ? sym.sizeFieldIndex : this.sizeFieldIndex;
        if (sizeField >= 0 || sym.useZoom || sym.font == null) {
            int symSize = sym.size;
            if (sizeField >= 0) {
                Object o = this.layer.getFieldValue(rec, sizeField);
                symSize = (int)((float)Strings.objToInt(o, symSize) * sym.factor);
            } else if (sym.useZoom) {
                double scale = (double)(sym.maxSize - sym.minSize) / (Math.log(projection.minzoom) - Math.log(projection.maxzoom));
                symSize = (int)Math.abs(Math.round((Math.log(projection.zoom) - Math.log(projection.maxzoom)) * scale));
                if (symSize < sym.minSize) {
                    symSize = sym.minSize;
                }
            }
            sym.font = MapUtils.createAndVerifyFont(sym.fontName, sym.fontStyle, symSize, sLabelText);
            if (sym.useZoom || symSize > 20 || symSize < 8) {
                int ss = sym.size > 20 || sym.size < 8 ? 12 : sym.size;
                sym.sampleFont = MapUtils.createAndVerifyFont(sym.fontName, sym.fontStyle, ss, sLabelText);
            } else {
                sym.sampleFont = sym.font;
            }
            if (sym.font == null) {
                System.out.println(">>Can't set font " + sym.fontName);
                sym.fontName = null;
                return;
            }
        }
        g.setFont(sym.font);
        FloatPoint centre = rec.getRecordExtent().getCentre();
        int x = (int)((centre.x + projection.shift.x) * projection.zoom);
        int y = (int)((-centre.y + projection.shift.y) * projection.zoom);
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth(sLabelText);
        int h = fm.getHeight();
        int x0 = x;
        int y0 = y;
        if (sym.position != 1) {
            switch (sym.position) {
                case 0: {
                    x -= w / 2;
                    y += h / 2;
                    break;
                }
                case 1: {
                    y -= 2;
                    break;
                }
                case 2: {
                    y += h / 2;
                    break;
                }
                case 3: {
                    y = y + 2 + h;
                    break;
                }
                case 4: {
                    x -= w / 2;
                    y = y + 2 + h;
                    break;
                }
                case 5: {
                    x -= w;
                    y = y + 2 + h;
                    break;
                }
                case 6: {
                    x -= w;
                    y += h / 2;
                    break;
                }
                case 7: {
                    x -= w;
                    y -= 2;
                    break;
                }
                case 8: {
                    x -= w / 2;
                    y -= 2;
                }
            }
        }
        x += sym.xOffset;
        y += sym.yOffset;
        Shape shp = rec.getShape(0);
        int rotationField = sym.rotationFieldIndex >= 0 ? sym.rotationFieldIndex : this.rotationFieldIndex;
        double angle = 0.0;
        if (rotationField >= 0) {
            Object o = this.layer.getFieldValue(rec, rotationField);
            angle = -(MapUtils.toDoubleDef(o, angle) / 180.0 * 3.1415927410125732);
        } else {
            angle = sym.rotation;
        }
        boolean rotate = angle != 0.0;
        Object oldTransform = null;
        if (sym.align > 2) {
            g.setColor(sym.outlineColor);
            if (rotate) {
                oldTransform = Utils2D.getTransform(g);
                Utils2D.rotateGraphics(g, x, y, angle);
            }
            if (sym.align == 4) {
                int[] xCoords2 = new int[7];
                int[] yCoords2 = new int[7];
                xCoords2[0] = x;
                yCoords2[0] = y;
                xCoords2[1] = xCoords2[0];
                yCoords2[1] = yCoords2[0] - 10;
                xCoords2[2] = xCoords2[0] - 5;
                yCoords2[2] = yCoords2[1];
                xCoords2[3] = xCoords2[0] - 5;
                yCoords2[3] = yCoords2[1] - h - 2;
                xCoords2[4] = xCoords2[3] + w + 3;
                yCoords2[4] = yCoords2[3];
                xCoords2[5] = xCoords2[4];
                yCoords2[5] = yCoords2[1];
                xCoords2[6] = xCoords2[0] + 5;
                yCoords2[6] = yCoords2[1];
                xCoords2[0] = x0;
                yCoords2[0] = y0;
                g.fillPolygon(xCoords2, yCoords2, 7);
                g.setColor(sym.fillColor);
                g.drawPolygon(xCoords2, yCoords2, 7);
                g.drawString(sLabelText, xCoords2[3] + 2, yCoords2[1] - 2);
            } else {
                int[] xCoords2 = new int[4];
                int[] yCoords2 = new int[4];
                xCoords2[0] = x;
                yCoords2[0] = y;
                xCoords2[1] = x;
                yCoords2[1] = y - h - 2;
                xCoords2[2] = x + w + 3;
                yCoords2[2] = yCoords2[1];
                xCoords2[3] = xCoords2[2];
                yCoords2[3] = yCoords2[0];
                g.fillPolygon(xCoords2, yCoords2, 4);
                g.setColor(sym.fillColor);
                g.drawPolygon(xCoords2, yCoords2, 4);
                g.drawString(sLabelText, xCoords2[1] + 2, yCoords2[0] - 2);
            }
            if (rotate) {
                Utils2D.setTransform(g, oldTransform);
            }
        } else if (this.layer.isObjectType(2) && sym.align > 0) {
            Dimension ext = dc.getSize();
            if (Utils2D.have2d() && sym.align == 2) {
                if (MapUtils.isNotEmpty(this.recsAndStreets)) {
                    int ind = this.recsAndStreets.indexOf(rec);
                    sym.position = 0;
                    Utils2D.textAlongLine(g, (Shape)this.recsAndStreets.elementAt(ind + 1), sLabelText, projection, sym, ext);
                } else {
                    Utils2D.textAlongLine(g, shp, sLabelText, projection, sym, ext, this.streetDrawingMode == 0);
                }
                if (this.houseNumberFieldNames != null) {
                    FloatPoint p = null;
                    int[] houses = new int[]{houseFromLeft, houseToLeft, houseFromRight, houseToRight};
                    for (int i = 0; i < houses.length; ++i) {
                        int mh;
                        double a_endsoffset;
                        double a_lineoffset;
                        int num = houses[i];
                        if (num <= 0 || (p = RendererLabel.findHouseXY(this.layer, rec, num, houseFromLeft, houseToLeft, houseFromRight, houseToRight, a_lineoffset = 10.0 / projection.zoom, a_endsoffset = 10.0 / projection.zoom)) == null) continue;
                        String sNumber = "" + num;
                        int mx = (int)((p.x + projection.shift.x) * projection.zoom);
                        int my = (int)((-p.y + projection.shift.y) * projection.zoom);
                        int mw = fm.stringWidth(sNumber);
                        if (!this.needDraw(dc, mx -= mw / 2, my, mw, mh = fm.getHeight())) continue;
                        g.setColor(sym.fillColor);
                        g.drawString(sNumber, mx, my);
                    }
                }
            } else {
                RendererLabel.textAlongLine(g, shp, sLabelText, projection, sym, ext);
            }
        } else if (this.needDraw(dc, x, y, w, h)) {
            if (rotate) {
                oldTransform = Utils2D.getTransform(g);
                Utils2D.rotateGraphics(g, x, y, angle);
            }
            if (sym.outline) {
                g.setColor(sym.outlineColor);
                g.drawString(sLabelText, x + 1, y + 1);
            }
            g.setColor(sym.fillColor);
            g.drawString(sLabelText, x, y);
            if (rotate) {
                Utils2D.setTransform(g, oldTransform);
            }
        }
    }

    private boolean needDraw(DisplayContext dc, int x, int y, int w, int h) {
        boolean bNeedDraw = true;
        Rectangle r = new Rectangle(x, y, w, h);
        if (this.notOverlap) {
            int cnt = dc.getUsedSpaces().size();
            for (int j = 0; j < cnt; ++j) {
                Rectangle r2 = (Rectangle)dc.getUsedSpaces().elementAt(j);
                if (!r2.intersects(r)) continue;
                bNeedDraw = false;
                break;
            }
        }
        if (bNeedDraw && this.notOverlap) {
            dc.getUsedSpaces().addElement(r);
        }
        return bNeedDraw;
    }

    protected void prepare() throws Exception {
        FieldDef def = this.layer.getFieldDef_(this.layer.getFieldIndex(this.symbolFieldName));
        this.symbolFieldIndex = def != null ? def.index : -1;
        this.prepareSymbols(def);
        if (this.symbolFieldName != null && this.symbolFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.symbolFieldName);
        }
        this.rotationFieldIndex = this.layer.getFieldIndex(this.rotationFieldName);
        this.sizeFieldIndex = this.layer.getFieldIndex(this.sizeFieldName);
        if (this.rotationFieldName != null && this.rotationFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.rotationFieldName);
        }
        if (this.sizeFieldName != null && this.sizeFieldIndex < 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.sizeFieldName);
        }
        if (this.symbols == null || this.symbols.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + "No Symbols");
        }
        if (!Strings.isNullOrBlank(this.labelFieldName)) {
            StringTokenizer st = new StringTokenizer(this.labelFieldName, " ,;");
            this.labelFieldIndex = new int[st.countTokens()];
            int k = 0;
            while (st.hasMoreTokens()) {
                String sFieldName = st.nextToken();
                int iFieldIndex = this.layer.getFieldIndex(sFieldName);
                if (iFieldIndex < 0) {
                    throw new Exception("  Renderer: " + this.name + "  " + sFieldName);
                }
                this.labelFieldIndex[k] = iFieldIndex;
                ++k;
            }
        }
        if (this.labelFieldIndex == null || this.labelFieldIndex.length == 0) {
            throw new Exception("  Renderer: " + this.name + "  " + this.labelFieldName);
        }
        int count = this.symbols.length;
        int kk1 = this.equal > 0 ? 1 : 0;
        int kk2 = this.equal < 0 ? 1 : 0;
        for (int i = 0; i < count; ++i) {
            String s = this.symbols[i].label;
            if (s != null) continue;
            if (this.symbolFieldIndex >= 0) {
                if (this.equal == 0) {
                    s = "" + this.symbols[i].value;
                } else if (count >= 2) {
                    s = i == 0 ? "... " + this.symbols[i + kk1].value : (i < count - 1 ? this.symbols[i].value + " ... " + this.symbols[i + 1].value : this.symbols[i - kk2].value + " ...");
                }
            } else {
                s = "Sample";
            }
            this.symbols[i].label = s;
        }
        if (this.houseNumberFieldNames != null) {
            StringTokenizer tok = new StringTokenizer(this.houseNumberFieldNames, " ,;");
            String houseFromLeftField = tok.hasMoreTokens() ? tok.nextToken() : "";
            String houseToLeftField = tok.hasMoreTokens() ? tok.nextToken() : "";
            String houseFromRightField = tok.hasMoreTokens() ? tok.nextToken() : "";
            String houseToRightField = tok.hasMoreTokens() ? tok.nextToken() : "";
            this.houseFromLeftFieldIndex = this.layer.getFieldIndex(houseFromLeftField);
            this.houseToLeftFieldIndex = this.layer.getFieldIndex(houseToLeftField);
            this.houseFromRightFieldIndex = this.layer.getFieldIndex(houseFromRightField);
            this.houseToRightFieldIndex = this.layer.getFieldIndex(houseToRightField);
            if (this.houseFromLeftFieldIndex < 0 || this.houseToLeftFieldIndex < 0 || this.houseFromRightFieldIndex < 0 || this.houseToRightFieldIndex < 0) {
                throw new Exception("  Renderer: " + this.name + "  " + this.houseNumberFieldNames);
            }
        }
        this.isPrepared = true;
    }

    int getLevel() {
        return 100 * (this.layer.drawOrder + 1) + 60;
    }

    static void textAlongLine(Graphics g, Shape shp, String text, Projection prj, Symbol sym, Dimension extent) {
        int startLetter;
        int deltaLetter;
        int charSize;
        if (text == null || shp == null || shp.xCoords == null) {
            return;
        }
        double[] xCoords = shp.xCoords;
        int ptCount = xCoords.length;
        if (ptCount < 2) {
            return;
        }
        int textLength = text.length();
        if (textLength <= 0) {
            return;
        }
        char[] ch = new char[textLength];
        int[] lx = new int[textLength];
        int[] ly = new int[textLength];
        int lindex = 0;
        int maxX = extent.width;
        int maxY = extent.height;
        double[] yCoords = shp.yCoords;
        int[] xs = new int[ptCount];
        int[] ys = new int[ptCount];
        for (int i = 0; i < ptCount; ++i) {
            int x = (int)((xCoords[i] + prj.shift.x) * prj.zoom);
            int y = (int)((-yCoords[i] + prj.shift.y) * prj.zoom);
            xs[i] = x;
            ys[i] = y;
        }
        FontMetrics fm = g.getFontMetrics();
        int charHeight = fm.getAscent() + fm.getLeading();
        char[] chars = new char[textLength];
        int[] charWidths = new int[textLength];
        int maxCharWidth = 0;
        for (int i = 0; i < textLength; ++i) {
            int cw;
            chars[i] = text.charAt(i);
            charWidths[i] = cw = fm.charWidth(chars[i]);
            if (maxCharWidth >= cw) continue;
            maxCharWidth = cw;
        }
        int n = charSize = charHeight > maxCharWidth ? charHeight : maxCharWidth;
        if (charSize <= 0) {
            return;
        }
        if (xs[0] > xs[1]) {
            deltaLetter = -1;
            startLetter = textLength - 1;
        } else {
            deltaLetter = 1;
            startLetter = 0;
        }
        int curLetter = startLetter;
        Color c1 = sym.outline ? sym.outlineColor : null;
        Color c2 = sym.fillColor;
        boolean output = false;
        float segCharCount = 0.0f;
        float segmentRemainder = 0.0f;
        for (int i = 0; i < ptCount - 1; ++i) {
            float dy1;
            float dx1;
            int x0 = xs[i];
            int y0 = ys[i];
            float dx = xs[i + 1] - x0;
            float dy = ys[i + 1] - y0;
            float nx = Math.abs(dx) / (float)charSize;
            float ny = Math.abs(dy) / (float)charSize;
            segCharCount = segmentRemainder;
            if (nx > ny) {
                dx1 = dx / nx;
                dy1 = dy / nx;
                segCharCount += nx;
            } else {
                dx1 = dx / ny;
                dy1 = dy / ny;
                segCharCount += ny;
            }
            int nSegCharCount = (int)segCharCount;
            float prevRemainder = segmentRemainder;
            segmentRemainder = segCharCount - (float)nSegCharCount;
            for (int j = 0; j < nSegCharCount; ++j) {
                float x = (float)x0 + dx1 * ((float)j + 0.5f - prevRemainder);
                float y = (float)y0 + dy1 * ((float)j + 0.5f - prevRemainder);
                if (x > 0.0f && x < (float)maxX && y > 0.0f && y < (float)maxY) {
                    int k;
                    if (!output) {
                        curLetter = startLetter;
                        lindex = 0;
                        output = true;
                    }
                    lx[lindex] = (int)(x - (float)(charWidths[curLetter] / 2));
                    ly[lindex] = (int)((double)y + (double)charHeight * 0.3);
                    ch[lindex] = chars[curLetter];
                    if ((curLetter += deltaLetter) >= textLength) {
                        curLetter = 0;
                    } else if (curLetter < 0) {
                        curLetter = textLength - 1;
                    }
                    if (++lindex < textLength && j != nSegCharCount) continue;
                    if (c1 != null) {
                        g.setColor(c1);
                        for (k = 0; k < lindex; ++k) {
                            g.drawChars(ch, k, 1, lx[k] + 1, ly[k] + 1);
                        }
                    }
                    g.setColor(c2);
                    for (k = 0; k < lindex; ++k) {
                        g.drawChars(ch, k, 1, lx[k], ly[k]);
                    }
                    return;
                }
                output = false;
            }
        }
    }

    private boolean pointsNear(double[] xc1, double[] yc1, double[] xc2, double[] yc2, int num1, int num2) {
        boolean b = Math.abs(xc1[num1] - xc2[num2]) < 1.0E-5 && Math.abs(yc1[num1] - yc2[num2]) < 1.0E-5;
        return b;
    }

    private Shape tryUnitShapes(Shape s1, Shape s2) {
        Shape res;
        block4: {
            int i;
            int c2;
            int c1;
            double[] yc2;
            double[] xc2;
            double[] yc1;
            double[] xc1;
            block5: {
                int i2;
                res = null;
                if (s1 == null || s2 == null) break block4;
                xc1 = s1.xCoords;
                yc1 = s1.yCoords;
                xc2 = s2.xCoords;
                yc2 = s2.yCoords;
                c1 = xc1.length;
                c2 = xc2.length;
                if (!this.pointsNear(xc1, yc1, xc2, yc2, c1 - 1, 0)) break block5;
                res = new Shape();
                res.xCoords = new double[c1 + c2];
                res.yCoords = new double[c1 + c2];
                for (i2 = 0; i2 < c1; ++i2) {
                    res.xCoords[i2] = xc1[i2];
                    res.yCoords[i2] = yc1[i2];
                }
                for (i2 = 0; i2 < c2; ++i2) {
                    res.xCoords[c1 + i2] = xc2[i2];
                    res.yCoords[c1 + i2] = yc2[i2];
                }
                break block4;
            }
            if (!this.pointsNear(xc1, yc1, xc2, yc2, 0, c2 - 1)) break block4;
            res = new Shape();
            res.xCoords = new double[c1 + c2];
            res.yCoords = new double[c1 + c2];
            for (i = 0; i < c2; ++i) {
                res.xCoords[i] = xc2[i];
                res.yCoords[i] = yc2[i];
            }
            for (i = 0; i < c1; ++i) {
                res.xCoords[c2 + i] = xc1[i];
                res.yCoords[c2 + i] = yc1[i];
            }
        }
        return res;
    }

    private static boolean valuesOddOrEven(int v1, int v2) {
        return v1 % 2 == v2 % 2;
    }

    private static FloatPoint findHouseXY(Layer layer, Record rec, int houseNumber, int fromleft, int toleft, int fromright, int toright, double add_offset_from_line, double add_offset_from_ends) {
        double offset_from_line = 20.0 + add_offset_from_line;
        double offset_from_ends = 20.0 + add_offset_from_ends;
        boolean left = false;
        boolean right = false;
        int from = 0;
        int to = 0;
        int numHouses = 0;
        int curHouse = 0;
        if (rec.getShapeCount() == 1) {
            FloatRectangle r;
            Shape shp = rec.getShape(0);
            if (shp.xCoords.length > 1 && (r = new FloatRectangle(shp.xCoords[0], shp.yCoords[0], shp.xCoords[shp.xCoords.length - 1], shp.yCoords[shp.xCoords.length - 1])) != null) {
                boolean backward;
                double alpha = Math.atan((r.y2 - r.y) / (r.x2 - r.x));
                double sin_alpha = Math.sin(alpha);
                double cos_alpha = Math.cos(alpha);
                boolean bl = backward = r.x > r.x2;
                if (backward) {
                    offset_from_ends *= -1.0;
                }
                double offsetx = offset_from_ends * cos_alpha;
                double offsety = offset_from_ends * sin_alpha;
                r.setBounds(r.x + offsetx, r.y + offsety, r.x2 - offsetx, r.y2 - offsety);
                if (fromleft != 0 && RendererLabel.valuesOddOrEven(fromleft, houseNumber) && houseNumber >= fromleft && houseNumber <= toleft) {
                    from = fromleft;
                    to = toleft;
                    left = true;
                } else if (fromright != 0 && RendererLabel.valuesOddOrEven(fromright, houseNumber) && houseNumber >= fromright && houseNumber <= toright) {
                    from = fromright;
                    to = toright;
                    right = true;
                }
                if (left || right) {
                    numHouses = (to - from) / 2 + 1;
                    curHouse = (houseNumber - from) / 2 + 1;
                    FloatPoint p = numHouses > 1 ? new FloatPoint(r.x + (r.x2 - r.x) / (double)(numHouses - 1) * (double)(curHouse - 1), r.y + (r.y2 - r.y) / (double)(numHouses - 1) * (double)(curHouse - 1)) : r.getCentre();
                    if (backward) {
                        offset_from_line *= -1.0;
                    }
                    offsetx = offset_from_line * sin_alpha;
                    offsety = offset_from_line * cos_alpha;
                    if (left) {
                        p.x += offsetx;
                        p.y -= offsety;
                    }
                    if (right) {
                        p.x -= offsetx;
                        p.y += offsety;
                    }
                    return p;
                }
            }
        }
        return null;
    }

    private void prepareStreet(int index, Record rec, Shape shp, String sLabelText) {
        for (int j = 0; shp != null && j < index; ++j) {
            Shape shp2 = (Shape)this.recsAndStreets.elementAt(j * 3 + 1);
            String sLabelText2 = (String)this.recsAndStreets.elementAt(j * 3 + 2);
            if (sLabelText.compareTo(sLabelText2) != 0 || (shp2 = this.tryUnitShapes(shp, shp2)) == null) continue;
            shp = null;
            this.recsAndStreets.setElementAt(shp2, index * 3 + 1);
            this.recsAndStreets.setElementAt(shp, j * 3 + 1);
            this.prepareStreet(index, rec, shp2, sLabelText2);
        }
    }

    private void prepareRecsAndStreets(Vector recs) {
        if (this.recsAndStreets == null) {
            this.recsAndStreets = new Vector();
        }
        this.recsAndStreets.removeAllElements();
        for (int i = 0; i < recs.size(); ++i) {
            Record rec = (Record)recs.elementAt(i);
            Shape shp = rec.getShape(0);
            String sLabelText = this.getLabelString(rec);
            this.recsAndStreets.addElement(rec);
            this.recsAndStreets.addElement(shp);
            this.recsAndStreets.addElement(sLabelText);
            this.prepareStreet(i, rec, shp, sLabelText);
        }
    }

    protected String getDrawStreetName(String value) {
        if (this.drawedStreets != null) {
            String s = value + '\u0000';
            int count = this.drawedStreets.size();
            for (int i = 0; i < count; ++i) {
                if (!s.startsWith((String)this.drawedStreets.elementAt(i))) continue;
                return "";
            }
            this.drawedStreets.addElement(s);
        }
        return value;
    }

    public void beforePaint(boolean selected, DisplayContext dc) {
        if (this.streetDrawingMode == 1) {
            if (this.drawedStreets == null) {
                this.drawedStreets = new Vector();
            }
        } else {
            this.drawedStreets = null;
        }
        if (this.streetDrawingMode == 2) {
            if (this.recordsToPaint == null) {
                this.recordsToPaint = new Vector();
            }
            if (this.recsAndStreets == null) {
                this.recsAndStreets = new Vector();
            }
        } else {
            this.recordsToPaint = null;
            this.recsAndStreets = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPaint(boolean selected, DisplayContext dc) {
        if (this.streetDrawingMode == 1) {
            this.drawedStreets.removeAllElements();
        }
        if (this.streetDrawingMode == 2) {
            this.unitedPainting = true;
            try {
                this.prepareRecsAndStreets(this.recordsToPaint);
                int count = this.recordsToPaint.size();
                for (int i = 0; i < count; ++i) {
                    this.paintRecord((Record)this.recordsToPaint.elementAt(i), selected, dc);
                }
            }
            finally {
                this.unitedPainting = false;
                this.recordsToPaint.removeAllElements();
                this.recsAndStreets.removeAllElements();
            }
        }
    }
}

