/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.Serializable;
import java.util.Vector;
import org.alov.map.DisplayContext;
import org.alov.map.FieldDef;
import org.alov.map.FilterTime;
import org.alov.map.FloatPoint;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Projection;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.util.Strings;

public abstract class Renderer
implements Serializable {
    public static final int RT_DEFAULT = 0;
    public static final int RT_GRADUATED_COLOR = 1;
    public static final int RT_LABEL = 4;
    public static final int RT_CHART = 5;
    protected Layer layer = null;
    public Vector themes = new Vector();
    public boolean withinZoom = false;
    public float zmin;
    public float zmax;
    public int equal = 0;
    public String name;
    public String label;
    public boolean legendVisible = true;
    public boolean enabled = true;
    public boolean allowToggle = false;
    protected Symbol[] symbols = null;
    protected boolean isPrepared = false;
    public Vector symbolsUnprepared = null;
    boolean useDefault = false;
    public int sampleHeight = 0;
    public int rendLabelHeight = 0;
    public boolean drawMarker = false;
    static final int RL_LOWEST = 10;
    static final int RL_IMAGE = 20;
    static final int RL_POLYGON = 20;
    static final int RL_LINE = 30;
    static final int RL_POINT = 40;
    static final int RL_FEATURE = 50;
    static final int RL_LABEL = 60;
    public int radioGroupLevel = 0;

    public Renderer(Layer layer) {
        this.layer = layer;
    }

    public boolean isRendererVisible(DisplayContext dc) {
        if (dc == null) {
            dc = this.layer.parentMap;
        }
        return this.isPrepared && this.isVisible(dc);
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isVisible(DisplayContext dc) {
        String sTheme;
        if (dc == null) {
            dc = this.layer.parentMap;
        }
        if (dc == null) {
            return false;
        }
        if (this.withinZoom) {
            int isRes;
            double d = dc.getDistance(dc.getLastExtent());
            int n = this.zmin > 0.0f && (double)this.zmin > d ? -1 : (isRes = this.zmax > 0.0f && d > (double)this.zmax ? 1 : 0);
            if (isRes != 0) {
                return false;
            }
        }
        if ((sTheme = this.layer.style) == null) {
            sTheme = dc.getThematicMap();
        }
        String ss = this.layer.radioGroup == null ? "NO" : "" + this.layer.radioGroup.isLayerLevel(this.layer, this.radioGroupLevel);
        return !(this.themes.size() != 0 && sTheme != null && this.themes.indexOf(sTheme) < 0 || this.layer.radioGroup != null && this.radioGroupLevel != 0 && !this.layer.radioGroup.isLayerLevel(this.layer, this.radioGroupLevel));
    }

    public abstract void paintRecord(Record var1, boolean var2, DisplayContext var3);

    protected void prepare() throws Exception {
        this.isPrepared = true;
    }

    public int getSymbolCount() {
        return this.symbols == null ? 0 : this.symbols.length;
    }

    public Symbol getSymbol(int ind) {
        return this.symbols != null && ind >= 0 && ind < this.symbols.length ? this.symbols[ind] : null;
    }

    protected void prepareSymbols(FieldDef def) throws Exception {
        Symbol sym;
        int i;
        if (this.symbolsUnprepared == null) {
            return;
        }
        int count = this.symbolsUnprepared.size();
        int k = 0;
        for (i = 0; i < count; ++i) {
            sym = (Symbol)this.symbolsUnprepared.elementAt(i);
            sym.prepare(this.layer);
            if (def == null && sym.valueStr == null) {
                if ((sym.offsetMin != 0.0 || sym.offsetMax != 0.0) && this.layer instanceof LayerVector) {
                    sym.value = new FilterTime((LayerVector)this.layer);
                    ++k;
                    continue;
                }
                sym.value = "";
                ++k;
                break;
            }
            int scheme = -1;
            if (def != null) {
                scheme = def.type;
            }
            try {
                sym.setValue(sym.valueStr, scheme, this.layer);
                ++k;
            }
            catch (Exception e) {
                System.out.println(">>. " + e.getMessage());
                sym.value = null;
            }
            sym.valueStr = null;
        }
        this.symbols = new Symbol[k];
        k = 0;
        for (i = 0; i < count; ++i) {
            sym = (Symbol)this.symbolsUnprepared.elementAt(i);
            if (sym.value == null) continue;
            sym.loadSymbolImages(this.layer);
            this.symbols[k] = sym;
            ++k;
        }
        this.symbolsUnprepared.removeAllElements();
        this.symbolsUnprepared = null;
    }

    int getLevel() {
        int lo = 100 * (this.layer.drawOrder + 1);
        if (this.layer instanceof LayerVector) {
            int objectType = this.drawMarker ? 1 : this.layer.dataStorage.getObjectType();
            switch (objectType) {
                case 1: {
                    return lo + 40;
                }
                case 2: {
                    return lo + 30;
                }
            }
            return lo + 20;
        }
        return lo + 10;
    }

    private float lg(double x) {
        return (x += 1.0) != 0.0 ? (float)Math.log(x) : -15000.0f;
    }

    protected void defaultPaintRecord(Record rec, Symbol sym, DisplayContext dc) {
        Object o;
        int shapeCount = rec.getShapeCount();
        int ot = this.layer.dataStorage.getObjectType();
        Projection prj = dc.getProjection();
        if (sym.sizeFieldIndex >= 0) {
            o = this.layer.getFieldValue(rec, sym.sizeFieldIndex);
            sym.size = (int)((float)Strings.objToInt(o, sym.size) * sym.factor);
        } else if (sym.useZoom) {
            double scale = (double)(sym.maxSize - sym.minSize) / (Math.log(prj.minzoom) - Math.log(prj.maxzoom));
            sym.size = (int)Math.abs(Math.round((Math.log(prj.zoom) - Math.log(prj.maxzoom)) * scale));
            if (sym.size < sym.minSize) {
                sym.size = sym.minSize;
            }
        }
        if (sym.rotationFieldIndex >= 0) {
            o = this.layer.getFieldValue(rec, sym.rotationFieldIndex);
            sym.rotation = (float)(MapUtils.toDoubleDef(o, sym.rotation) / 180.0 * Math.PI);
        }
        if (sym.drawMarker) {
            FloatPoint centre = rec.getRecordExtent().getCentre();
            Shape.drawPoint(dc.getDrawToGraphics(), sym, (int)((centre.x + prj.shift.x) * prj.zoom), (int)((-centre.y + prj.shift.y) * prj.zoom));
            return;
        }
        for (int i = 0; i < shapeCount; ++i) {
            Shape.paintShape(rec.getShape(i), dc.getDrawToGraphics(), prj, sym, ot);
        }
    }

    public void beforePaint(boolean selected, DisplayContext dc) {
    }

    public void afterPaint(boolean selected, DisplayContext dc) {
    }

    public Layer getLayer() {
        return this.layer;
    }
}

