/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.alov.data.DataProviderFile;
import org.alov.data.DataProviderImg;
import org.alov.map.Carte;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Load2D;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.Proxy;
import org.alov.map.ProxyRequest;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.Log;
import org.alov.util.Strings;

public class ProxyLocal
implements Const,
LayerSetup,
Proxy {
    Carte map = null;
    private static final String DUMMY = "dummy";
    boolean zoomToOneResult = false;
    int sessionUser = 0;
    int sessionMagic = 0;
    String projectURL = null;
    String projectId = null;
    private Object loadLock = new Object();

    public Layer hasPasswords() {
        return null;
    }

    public void setupProxy(Carte map) {
        this.projectId = map.getParameter("pid", null);
        this.zoomToOneResult = map.getParameter("zoomtooneresult", "no").equalsIgnoreCase("yes");
        if (this.projectId != null) {
            if (!this.projectId.toLowerCase().startsWith("http://") && (Strings.checkSuffix(this.projectId, ".xml") || Strings.checkSuffix(this.projectId, ".tms") || Strings.checkSuffix(this.projectId, ".raw"))) {
                this.setProjectURLLocal();
            } else {
                this.setProjectURLServer();
            }
        }
        this.map = map;
    }

    void setProjectURLLocal() {
        this.projectURL = MapUtils.getRealPath(this.projectId);
        MapUtils.projectBase = Strings.extractDir(this.projectURL);
    }

    void setProjectURLServer() {
    }

    void loadProjectServer(InputStream is) throws Exception {
        throw new AlovMapException(111, "ProxyLocal does not support client-server interaction");
    }

    int searchQuery(GeoReqParams params) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject() {
        boolean b = false;
        Object object = this.loadLock;
        synchronized (object) {
            if (this.map.isProjectLoaded()) {
                return;
            }
            this.map.broadcastMessage(10, null);
            Project prj = null;
            try {
                this.sessionUser = 0;
                this.sessionMagic = 0;
                this.map.broadcastMessage(1, this.projectURL);
                if (Strings.isNullOrBlank(this.projectURL)) {
                    throw new AlovMapException(112, "Mapspace is not defined");
                }
                StreamCounter is = null;
                if (Strings.checkSuffix(this.projectURL, ".raw") && (prj = this.loadSerializedProject(this.projectURL)) != null) {
                    this.map.setProject(prj);
                    return;
                }
                prj = new Project();
                this.map.setProject(prj);
                this.addStatusInfo(0, null, "Load Mapspace: " + this.projectURL);
                try {
                    is = MapUtils.openURL(this.projectURL);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!Strings.checkSuffix(this.projectURL, ".xml") && !Strings.checkSuffix(this.projectURL, ".tms")) {
                    this.loadProjectServer(is);
                } else if (is == null) {
                    throw new AlovMapException(308, "Mapspace file not found or inaccessible");
                }
                prj.language = MapUtils.language;
                prj.load(is, this);
            }
            catch (AlovMapException e) {
                int eCode = e.getCode();
                this.addStatusInfo(eCode, null, e.getMessage());
                this.map.broadcastMessage(eCode == 215 || eCode == 202 ? -7 : -8, "");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addStatusInfo(0, null, e.getMessage());
                this.map.broadcastMessage(-8, this.projectURL);
            }
            finally {
                this.map.broadcastMessage(11, null);
            }
        }
    }

    public Project loadSerializedProject(String url) {
        Project prj = null;
        try {
            StreamCounter is = MapUtils.openURL(this.projectURL);
            prj = Project.loadFromRawFile(is);
            ((InputStream)is).close();
            int layerCount = prj.layers.size();
            for (int i = 0; i < layerCount; ++i) {
                Layer layer = (Layer)prj.layers.elementAt(i);
                layer.afterDeserialization();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            prj = null;
        }
        return prj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(ProxyRequest req) throws Exception {
        int layerCount;
        Project project;
        if (!this.map.isProjectLoaded()) {
            return;
        }
        this.map.broadcastMessage(10, null);
        try {
            switch (req.type) {
                case 1: 
                case 34: {
                    this.doGeoRequest(req);
                    if (this.map.isFirstRequest) {
                        this.map.isFirstRequest = false;
                        this.map.zoomToDomain(this.map.getProject().startExtentName);
                        this.map.updateMap();
                    } else if (req.type == 34) {
                        Layer lyr = this.map.getProject().getLayerById(req.layerId);
                        if (lyr.zoomToExtentAfterCustomLoad) {
                            this.map.zoomToLayer(lyr);
                        }
                    }
                    this.map.broadcastMessage(16, this.map.getName());
                    break;
                }
                case 2: {
                    this.doExtentRequest(req);
                    break;
                }
                case 33: {
                    this.doCustomRequest(req);
                    break;
                }
                default: {
                    this.doAttribRequest(req);
                    this.map.broadcastMessage(17, req.layerId);
                }
            }
            project = this.map.getProject();
            layerCount = project.getLayerCount();
        }
        catch (Throwable throwable) {
            Project project2 = this.map.getProject();
            int layerCount2 = project2.getLayerCount();
            for (int i = 0; i < layerCount2; ++i) {
                Layer lyr = project2.getLayerByIndex(i);
                if (!lyr.metadata.networkActivity) continue;
                lyr.metadata.networkActivity = false;
                this.map.broadcastMessage(11, "");
            }
            this.map.broadcastMessage(11, null);
            throw throwable;
        }
        for (int i = 0; i < layerCount; ++i) {
            Layer lyr = project.getLayerByIndex(i);
            if (!lyr.metadata.networkActivity) continue;
            lyr.metadata.networkActivity = false;
            this.map.broadcastMessage(11, "");
        }
        this.map.broadcastMessage(11, null);
    }

    private void doExtentRequest(ProxyRequest req) throws Exception {
        this.doGeoRequest(req);
        Layer lyr = this.map.getProject().getLayerById(req.layerId);
        Record rec = ((LayerVector)lyr).findById(req.query);
        if (rec != null) {
            this.map.selectObject(lyr, rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDirect(GeoReqParams params, Layer lyr) {
        if (lyr.provider == null) {
            return;
        }
        this.map.broadcastMessage(2, lyr.getName());
        try {
            lyr.metadata.networkActivity = true;
            this.map.broadcastMessage(10, "");
            System.gc();
            lyr.provider.loadComplete();
            if (this.map.getProject().geoProjection != null) {
                Load2D.makeProjection(lyr, this.map.getProject().geoProjection);
            }
            System.gc();
            params.project.setSameLayers(lyr, this);
            params.project.sortRenderersByLevels();
            if (lyr instanceof LayerVector) {
                this.addStatusInfo(0, lyr, "Download " + lyr.dataStorage.size() + " records");
            } else if (lyr instanceof LayerRaster) {
                this.addStatusInfo(0, lyr, "Download image");
            }
            FloatRectangle ext = lyr.getLayerExtent();
            if (ext != null) {
                this.map.addExtent(ext);
                FloatRectangle ext2 = this.map.getLastExtent();
                if (ext2 != null && ext2.intersects(ext)) {
                    this.map.updateMap();
                }
            }
            if (lyr.metadata.isNotLoaded) {
                this.addStatusInfo(0, lyr, "WARNING#307");
            }
            if (lyr instanceof LayerZoomify && lyr.isLoadComplete()) {
                ((LayerZoomify)lyr).loadZoomifyImages(params.rect);
            }
        }
        catch (AlovMapException e) {
            lyr.metadata.loadFailed = true;
            this.map.broadcastMessage(-8, lyr.getName());
            this.addStatusInfo(e.getCode(), lyr, e.getMessage());
        }
        finally {
            lyr.metadata.networkActivity = false;
            this.map.broadcastMessage(11, "");
        }
    }

    int processGeoRequest(GeoReqParams params) throws Exception {
        params.layerCount = params.project.getLayerCount();
        StringBuffer passwordParameters = new StringBuffer();
        for (int i = 0; i < params.layerCount; ++i) {
            boolean dontNeedToResolvePassword;
            Layer lyr = params.req.layerId != null ? params.project.getLayerById(params.req.layerId) : params.project.getLayerByIndex(i);
            String password = lyr.metadata.getVal(303);
            boolean isLoadComplete = lyr.isLoadComplete();
            boolean isSomethingVisible = lyr.isSomethingVisible(null);
            boolean bl = dontNeedToResolvePassword = (lyr.isPassResolved() || Strings.isNullOrBlank(password)) && !isSomethingVisible;
            if (this.map.loadedExtent != null && (isLoadComplete || lyr.metadata.loadFailed || dontNeedToResolvePassword || lyr.isGeocoding)) {
                if (params.req.layerId == null) continue;
                break;
            }
            if (!lyr.isDataOnServer) {
                this.loadDirect(params, lyr);
            } else {
                lyr.metadata.loadFailed = true;
                this.map.broadcastMessage(-8, lyr.getName());
                this.addStatusInfo(111, lyr, "This version supports only file based datasets");
            }
            if (params.req.layerId != null) break;
        }
        return 0;
    }

    void doGeoRequest(ProxyRequest req) throws Exception {
        GeoReqParams params = new GeoReqParams(req);
        params.rect = req.extent;
        boolean needRequestToServer = false;
        if (req.type != 1) {
            needRequestToServer = this.searchQuery(params) > -1;
        } else {
            boolean bl = needRequestToServer = this.processGeoRequest(params) > -1;
        }
        if (needRequestToServer) {
            this.processGeoResponse(params);
        }
    }

    void processGeoResponse(GeoReqParams params) throws Exception {
    }

    private void doCustomRequest(ProxyRequest req) throws Exception {
        this.map.broadcastMessage(Integer.parseInt(req.query), null);
    }

    private void doAttribRequest(ProxyRequest req) throws Exception {
        String link;
        if (req.layerId == null) {
            return;
        }
        Project project = this.map.getProject();
        Layer layer = project.getLayerById(req.layerId);
        if (layer == null || !layer.canSearch) {
            return;
        }
        String sUrl = null;
        RecordsArray records = null;
        if (req.type == 32 || req.type == 35) {
            link = layer.linkSearch != null ? layer.linkSearch : project.linkSearch;
        } else {
            records = layer.getSelection();
            if (layer instanceof LayerVector && (req.type == 30 || MapUtils.isNotEmptyRecs(records) && records.size() > 1)) {
                LayerVector lyr = (LayerVector)layer;
                String string = link = lyr.linkInfo != null ? lyr.linkInfo : project.linkInfo;
                if (link != null) {
                    StringBuffer sQuery = new StringBuffer();
                    int selectionSize = records.size();
                    if (selectionSize > 255) {
                        selectionSize = 255;
                    }
                    for (int i = 0; i < selectionSize; ++i) {
                        Record rec = records.getRecord(i, 1);
                        sQuery.append(lyr.getId(rec)).append(',');
                    }
                    req.query = sQuery.toString().substring(0, sQuery.length() - 1);
                }
            } else {
                link = layer.linkMain != null ? layer.linkMain : project.linkMain;
            }
        }
        sUrl = layer.getWebLink(link, records, req.query, req.extent, "id=" + this.sessionUser + "&m=" + this.sessionMagic);
        if (sUrl != null) {
            this.map.showURL(sUrl);
        } else if (layer instanceof LayerVector) {
            if (this.map.supressAttributeFrame) {
                return;
            }
            LayerVector lyr2 = (LayerVector)layer;
            if (req.type == 32 || req.type == 35) {
                if (!layer.isLoadComplete() && layer.isDataOnServer && layer.serverType != 23) {
                    this.doGeoRequest(req);
                }
                if (MapUtils.isNotEmptyRecs(records = req.type == 32 ? lyr2.findBySearchField(req.query) : lyr2.findByExpression(req.query))) {
                    this.map.broadcastMessage(115, String.valueOf(records.size()));
                } else {
                    this.map.broadcastMessage(114, "");
                }
            }
            if (records != null && records.size() == 1 && this.zoomToOneResult && req.type == 32) {
                this.map.selectObjects(lyr2, records);
            } else {
                this.map.host.showAttributes(lyr2, records);
            }
        }
    }

    public Layer createLayer(Properties connectionData) throws AlovMapException {
        Layer lyr;
        if (connectionData == null) {
            throw new AlovMapException(105, "");
        }
        String dsType = connectionData.getProperty("type");
        String dsId = connectionData.getProperty("id");
        String dsURL = connectionData.getProperty("url");
        boolean isCompactStorage = this.map.getProject().isCompactStorage;
        if ("group".equalsIgnoreCase(dsType)) {
            lyr = new LayerGroup();
            lyr.setLoadComplete(true);
            lyr.datasetId = "";
            lyr.notPrepared = false;
            lyr.canSearch = false;
            lyr.setLoadComplete(true);
        } else if (DUMMY.equalsIgnoreCase(dsType)) {
            lyr = new LayerVector();
            lyr.setLoadComplete(true);
            lyr.datasetId = "";
            lyr.notPrepared = false;
        } else {
            if (dsURL == null && dsId == null) {
                throw new AlovMapException(105, "");
            }
            if (dsType == null) {
                dsType = dsURL == null || Strings.checkSuffix(dsURL, ".shp") || Strings.checkSuffix(dsURL, ".mif") || Strings.checkSuffix(dsURL, ".zip") || Strings.checkSuffix(dsURL, ".dbf") || Strings.checkSuffix(dsURL, ".gml") || Strings.checkSuffix(dsURL, ".csv") || Strings.checkSuffix(dsURL, ".txt") || Strings.checkSuffix(dsURL, ".tmm") ? "" : "image";
                ((Hashtable)connectionData).put("type", dsType);
            }
            if (dsType.equalsIgnoreCase("image")) {
                lyr = new LayerRaster();
            } else if (dsType.equalsIgnoreCase("image_zoomify")) {
                lyr = new LayerZoomify();
                Renderer renderer = lyr.createDefaultRenderer();
                renderer.enabled = true;
                lyr.renderers.addElement(renderer);
                if (dsURL != null) {
                    ((Hashtable)connectionData).put("url", dsURL);
                }
            } else {
                lyr = new LayerVector(isCompactStorage);
            }
            String dsMode = connectionData.getProperty("direct");
            lyr.isDataOnServer = dsMode == null || !dsMode.equalsIgnoreCase("yes");
            lyr.connectionData = connectionData;
            if (dsId != null) {
                if ("dynamic".equalsIgnoreCase(dsType)) {
                    lyr.isFullLoad = true;
                    lyr.setLoadComplete(true);
                }
                lyr.isDataOnServer = true;
                if (lyr instanceof LayerZoomify) {
                    lyr.provider = new DataProviderFile(lyr);
                }
            } else {
                lyr.provider = dsType.equalsIgnoreCase("image") ? new DataProviderImg(lyr) : new DataProviderFile(lyr);
            }
            if (!lyr.isDataOnServer) {
                ((Hashtable)connectionData).put("url", dsURL);
            }
            lyr.datasetId = dsId == null ? dsURL : dsId;
            lyr.isGeocoding = lyr.datasetId.startsWith("geocode");
        }
        return lyr;
    }

    public void addStatusInfo(int messageCode, Layer lyr, String obj) {
        Log.addMessage(messageCode, this.map.getName(), lyr, obj);
    }

    class GeoReqParams {
        FloatRectangle rect;
        FloatRectangle newRect = null;
        String getMode = "";
        String lyrList = "";
        StringBuffer getReq = new StringBuffer();
        boolean hasImage = false;
        InputStream input = null;
        StreamCounter counter;
        int errorCode;
        URL url;
        Project project;
        int layerCount;
        int k;
        ProxyRequest req;

        GeoReqParams(ProxyRequest r) {
            this.project = ProxyLocal.this.map.getProject();
            this.layerCount = this.project.getLayerCount();
            this.k = 0;
            this.req = r;
        }
    }
}

