/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Domain;
import org.alov.map.FieldDef;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.LayerSetup;
import org.alov.map.LayerVector;
import org.alov.map.LayerZoomify;
import org.alov.map.Load2D;
import org.alov.map.Loader;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.RadioGroup;
import org.alov.map.Renderer;
import org.alov.map.RendererChart;
import org.alov.map.RendererDef;
import org.alov.map.RendererDot;
import org.alov.map.RendererGrad;
import org.alov.map.RendererLabel;
import org.alov.map.Shape;
import org.alov.map.Symbol;
import org.alov.map.Utils2D;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.ExDate;
import org.alov.util.Strings;
import org.alov.util.XmlConst;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class LoaderTM3
implements Const,
XmlConst {
    static final String _TPR_PROJECT = "Mapspace";
    static final String _TPR_PRJNAME = "Name";
    static final String _TPR_ANIMATION_DELAY = "AnimationDelay";
    static final String _TPR_MINZOOM = "LimitZoomInKm";
    static final String _TPR_CLR_MAPBACK = "ClrMapBackground";
    static final String _COORDSYS_LATLONG = "latitude/long";
    static final String _COORDSYS_PROJECTED = "projected";
    static final String _TPR_COORDSYS = "CoordSys";
    static final String _TPR_ZOOMBEYOUND = "AllowZoomOutsideDomain";
    static final String _TPR_DOMAIN = "Domain";
    static final String _TPR_DOMAINNAME = "Name";
    static final String _TPR_DOMAINMINX = "MinX";
    static final String _TPR_DOMAINMAXX = "MaxX";
    static final String _TPR_DOMAINMINY = "MinY";
    static final String _TPR_DOMAINMAXY = "MaxY";
    static final String _TPR_AutoLayerAdd = "AutoLayerAdd";
    static final String _TPR_ACCEPT_ALL = "AcceptAll";
    static final String _TPR_SEARCH_ALWAYS = "SearchAlways";
    static final String _TPR_WEB_LINK = "ObjectsLinkMask";
    static final String _TPR_WEB_INFO = "InfoLinkMask";
    static final String _TPR_WEB_SRCH = "SearchLinkMask";
    static final String _TPR_WEB_ROLLOVER = "RolloverLinkMask";
    static final String _TPR_TIMEENABLED = "TimeEnabled";
    static final String _TPR_DOMAINSTARTT = "StartT";
    static final String _TPR_DOMAINENDT = "EndT";
    static final String _TPR_DATASET = "Dataset";
    static final String _TPR_PATH = "LocalFilePath";
    static final String _TPR_TYPE = "Type";
    static final String _TPR_ECAI_ID = "ECAI_ID";
    static final String _TPR_RADIOGROUP = "RadioGroup";
    static final String _TPR_RADIOGROUP_NAME = "Name";
    static final String _TPR_RADIOGROUP_LEVELS = "Levels";
    static final String _TPR_RADIOGROUPLEVEL = "RadioGroupLevel";
    static final String _TPR_CONTROL_VISIBILITY = "ControlsVisibilityOf";
    static final String _TPR_LAYER = "Layer";
    static final String _TPR_KEYMAP = "ForKeyMap";
    static final String _TPR_LayerTitle = "Title";
    static final String _TPR_ZoomMinDegrees = "ZoomMinDegrees";
    static final String _TPR_ZoomMaxDegrees = "ZoomMaxDegrees";
    static final String _TPR_ZoomMinKm = "ZoomMinKm";
    static final String _TPR_ZoomMaxKm = "ZoomMaxKm";
    static final String _TPR_WithinZoom = "ApplyZoomRange";
    static final String _TPR_WithinDate = "ApplyDateRange";
    static final String _TPR_DateMin = "DateMin";
    static final String _TPR_DateMax = "DateMax";
    static final String _TPR_TimeVarying = "FilterByTime";
    static final String _TPR_PRELOADDATASET = "PreloadEntireDataset";
    static final String _TPR_PRELOADMETADATA = "PreloadMetadata";
    static final String _TPR_FORCESERVERDELIVERY = "ForceServerDelivery";
    static final String _TPR_LayerVisible = "InitiallyVisible";
    static final String _TPR_LayerAlwaysVisible = "DisableVisibilityCheckbox";
    static final String _TPR_ItemVisible = "ShowLayerInLegend";
    static final String _TPR_ItemExpanded = "ExpandLegendAtStart";
    static final String _TPR_HIDELEGENDOUTOFRANGE = "HideLegendOutOfRange";
    static final String _TPR_HIDELEGENDOUTOFEXTENT = "HideLegendOutOfExtent";
    static final String _TPR_ACTIVEONSTARTUP = "ActiveOnStartUp";
    static final String _TPR_CANSEARCH = "SearchEnabled";
    static final String _TPR_DRAWORDER = "DrawOrder";
    static final String _TPR_UseDefault = "UseDefault";
    static final String _TPR_SymDefault = "FlagDefault";
    static final String sLegendLabel4Image = "LegendLabel4Image";
    static final String _TPR_LAYER_FILTER = "LayerFilter";
    static final String _TPR_SHOW_IN_THEMATIC_MAP = "ShowInThematicMaps";
    static final String _TPR_RENDERER = "Renderer";
    static final String _TPR_RendType = "TypeCode";
    static final int ltGraduatedColor = 1;
    static final int ltUniqueValues = 2;
    static final int ltDots = 3;
    static final int ltLabel = 4;
    static final int ltChart = 5;
    static final int ltTimeBenchMark = 7;
    static final int ltImageCatalogue = 8;
    static final int ltDefault = 9;
    static final String sRendHeader = "HeaderInLegend";
    static final String sEnabled = "Enabled";
    static final String sBarHeight = "BarHeight";
    static final String sBarWidth = "BarWidth";
    static final String sChartType = "ChartType";
    static final String sMaxPieSize = "MaxPieSize";
    static final String sMinPieSize = "MinPieSize";
    static final String sShowOutline = "ShowOutline";
    static final String sSizeField = "SizeField";
    static final String sNormalizationField = "NormalisationField";
    static final String sNullValueOmitChart = "NullValueOmitChart";
    static final String sHeightField = "HeightField";
    static final String _TPR_FIELD = "FIELD";
    static final String sRenderField = "RenderField";
    static final String sChartField = "ChartField";
    static final String sFieldName = "FieldName";
    static final String sDisplayColor = "DisplayColor";
    static final String sDrawBackground = "DrawBackground";
    static final String sSymbolField = "SymbolField";
    static final String sRotationField = "RotationField";
    public static final String _TPR_SYMBOL = "Symbol";
    static final String _TPR_SELSYMBOL = "SymbolWhenSelected";
    static final String _TPR_IsSelectionSymbol = "IsSelectionSymbol";
    static final String sSymType = "MapObjectTypeCode";
    static final String sSymValue = "NumericValue";
    static final String sSymValueStr = "StringValue";
    static final String sSymSize = "Size";
    static final String sSymAnimated = "Animated";
    static final String sSymColor = "ForeColor";
    static final String sSymOutline = "UseOutline";
    static final String sOutlineColor = "OutlineColor";
    static final String sSymStyle = "StyleCode";
    static final String sSymCustomStyleFile = "CustomMarker";
    static final String sSymFont = "Font";
    static final String sFontStyle = "FontStyle";
    static final String _VerAlign = "VerticalAlign";
    static final String _HorAlign = "HorizontalAlign";
    static final String _IncreaseSizeWithZoom = "IncreaseSizeWithZoom";
    static final String sRemark = "LegendEntryLabel";
    static final String sLegShow = "ShowInLegend";
    static LayerSetup layerSetup;

    private LoaderTM3() {
    }

    static void parseProject(Project prj, XmlElement root, LayerSetup lyrSetup) throws Exception {
        int count2;
        int k;
        String param;
        XmlElement el;
        int count;
        Vector nodes;
        layerSetup = lyrSetup;
        if (root == null || !root.getNodeName().equalsIgnoreCase(_TPR_PROJECT)) {
            layerSetup.addStatusInfo(101, null, null);
            throw new AlovMapException(101, null);
        }
        boolean isDynAdd = XmlUtils.getBoolean("dynamic", root, false);
        if (!isDynAdd) {
            int i;
            prj.name = XmlUtils.getElString("Name", root, null);
            if (prj.name == null) {
                throw new AlovMapException("Project name not specified");
            }
            prj.zmin = XmlUtils.getElFloat(_TPR_MINZOOM, root, -1.0f);
            prj.zmax = -1.0;
            prj.mapBackground = XmlUtils.getElColor(_TPR_CLR_MAPBACK, root, Color.white);
            prj.linkMain = XmlUtils.getElString(_TPR_WEB_LINK, root, null);
            prj.linkSearch = XmlUtils.getElString(_TPR_WEB_SRCH, root, null);
            prj.linkInfo = XmlUtils.getElString(_TPR_WEB_INFO, root, null);
            prj.animationDelay = XmlUtils.getElBoolean(sSymAnimated, root, true) ? XmlUtils.getElInt(_TPR_ANIMATION_DELAY, root, 500) : -1;
            String Coord_sys = XmlUtils.getElString(_TPR_COORDSYS, root, _COORDSYS_LATLONG).toLowerCase();
            prj.MapUnits = Coord_sys.startsWith(_COORDSYS_LATLONG) ? 0 : 1;
            prj.ZoomUnits = 2;
            prj.moveBeyondProject = XmlUtils.getElBoolean(_TPR_ZOOMBEYOUND, root, false);
            prj.isCompactStorage = XmlUtils.getElBoolean("compact", root, true);
            prj.isTimeEnabled = XmlUtils.getElBoolean(_TPR_TIMEENABLED, root, false);
            nodes = root.getElementsByTagName(_TPR_DOMAIN);
            count = nodes.size();
            String maxExtentName = "full";
            for (i = 0; i < count; ++i) {
                String nom;
                el = (XmlElement)nodes.elementAt(i);
                FloatRectangle ext = new FloatRectangle(XmlUtils.getElFloat(_TPR_DOMAINMINX, el, 0.0f), XmlUtils.getElFloat(_TPR_DOMAINMINY, el, 0.0f), XmlUtils.getElFloat(_TPR_DOMAINMAXX, el, 0.0f), XmlUtils.getElFloat(_TPR_DOMAINMAXY, el, 0.0f));
                if (ext.x == 0.0 && ext.y == 0.0 && ext.x2 == 0.0 && ext.y2 == 0.0) {
                    ext = null;
                }
                if ((nom = XmlUtils.getElString("Name", el, null)) == null) {
                    throw new AlovMapException("Domain name not specified");
                }
                if (ext != null && ext.x < ext.x2 && ext.y < ext.y2) {
                    Domain domain = new Domain();
                    domain.ext = ext;
                    domain.minDate = ExDate.parseString(XmlUtils.getElString(_TPR_DOMAINSTARTT, el, "0"));
                    domain.maxDate = ExDate.parseString(XmlUtils.getElString(_TPR_DOMAINENDT, el, "2006"));
                    if (i == 0) {
                        prj.startDate = domain.minDate;
                        prj.endDate = domain.maxDate;
                    }
                    prj.domains.put(nom, domain);
                    prj.domainsNames = prj.domainsNames + nom + "\n\r";
                    if (i == 0) {
                        prj.maxExtent = ext;
                        maxExtentName = nom;
                        continue;
                    }
                    if (i != 1) continue;
                    prj.startExtentName = nom;
                    continue;
                }
                layerSetup.addStatusInfo(102, null, nom);
            }
            if (prj.maxExtent == null) {
                prj.maxExtent = new FloatRectangle(0.0, 0.0, 0.0, 0.0);
                Domain domain = new Domain();
                domain.ext = prj.maxExtent;
                domain.minDate = new ExDate(0.0);
                domain.maxDate = new ExDate(2006L, 1L, 1L);
                prj.domains.put("full", domain);
                prj.domainsNames = prj.domainsNames + "full\n\r";
                prj.startDate = domain.minDate;
                prj.endDate = domain.maxDate;
            }
            if (prj.startExtentName == null) {
                prj.startExtentName = maxExtentName;
            }
            nodes = root.getElementsByTagName("ThematicMap");
            count = nodes.size();
            for (i = 0; i < count; ++i) {
                el = (XmlElement)nodes.elementAt(i);
                String theme_id = XmlUtils.getElString("index", el, null);
                String theme_name = XmlUtils.getElString("name", el, null);
                if (theme_name == null) {
                    throw new AlovMapException("Thematic map name not specified");
                }
                if (theme_id != null) {
                    prj.themes.put(theme_name, theme_id);
                    prj.themesNames = prj.themesNames + theme_name + "\n\r";
                    if (theme_id.equals(MapUtils.predefTheme)) {
                        MapUtils.predefTheme = theme_name;
                    }
                    if (i != 0 && !XmlUtils.getElBoolean("startup", el, false)) continue;
                    prj.startTheme = theme_name;
                    continue;
                }
                layerSetup.addStatusInfo(103, null, theme_name);
            }
            if (prj.themes.size() == 0) {
                prj.themes.put("unnamed", "0");
                prj.startTheme = "unnamed";
                prj.themesNames = "unnamed\n\r";
            } else if (MapUtils.predefTheme != null) {
                prj.startTheme = MapUtils.predefTheme;
            }
            prj.keyMapBackground = XmlUtils.getElColor("ClrKeyMapBackground", root, prj.mapBackground);
            prj.keyMapOutline = XmlUtils.getElColor("ClrKeyMapRectangle", root, Color.red);
            prj.keyMapTheme = null;
            XmlElement el2 = root.getFirstElementByName(_TPR_AutoLayerAdd);
            boolean bl = prj.isDynamic = el2 != null && !MapUtils.isRunFromDisk && XmlUtils.getElBoolean(sEnabled, el2, true);
            if (prj.isDynamic) {
                prj.isDynamic_AcceptAll = XmlUtils.getElBoolean(_TPR_ACCEPT_ALL, el2, false);
                prj.isDynamic_SearchAlways = XmlUtils.getElBoolean(_TPR_SEARCH_ALWAYS, el2, true);
                prj.isDynamic_LayerVisible = XmlUtils.getElBoolean(_TPR_LayerVisible, el2, false);
                prj.isDynamic_RemoveOutOfExtent = !XmlUtils.getElBoolean("retain", el2, false);
                prj.iDynamic_OrderOfLayers = XmlUtils.getElInt(_TPR_DRAWORDER, el2, 0);
                nodes = el2.getElementsByTagName("MetadataElement");
                count = nodes.size();
                for (int i2 = 0; i2 < count; ++i2) {
                    el2 = (XmlElement)nodes.elementAt(i2);
                    String id = XmlUtils.getElString("id", el2, null);
                    String val = XmlUtils.getElString("Contains", el2, null);
                    if (Strings.isNullOrBlank(val) || Strings.isNullOrBlank(id)) continue;
                    prj.sDynamoAdd = prj.sDynamoAdd + id + '@' + val + ',';
                }
                if (prj.sDynamoAdd.length() > 0) {
                    prj.sDynamoAdd = prj.sDynamoAdd.substring(0, prj.sDynamoAdd.length() - 1);
                }
            }
            prj.isTimeMap = true;
        }
        if ((el = root.getFirstElementByName("projection")) != null && !Strings.isNullOrBlank(param = XmlUtils.getElString("name", el, null))) {
            prj.MapUnits = param.toLowerCase().startsWith(_COORDSYS_LATLONG) || param.startsWith("EPSG:4326") ? 0 : 1;
            if (!param.toLowerCase().startsWith(_COORDSYS_LATLONG) && !param.toLowerCase().startsWith(_COORDSYS_PROJECTED)) {
                Properties mapProjection = new Properties();
                ((Hashtable)mapProjection).put("name", param);
                if (param.indexOf("EPSG") < 0) {
                    param = XmlUtils.getElString("a", el, null);
                    if (Strings.isNumeric(param)) {
                        ((Hashtable)mapProjection).put("a", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("f", el, null))) {
                        ((Hashtable)mapProjection).put("f", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("phi0", el, null))) {
                        ((Hashtable)mapProjection).put("phi0", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("lambda0", el, null))) {
                        ((Hashtable)mapProjection).put("lambda0", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("fe", el, null))) {
                        ((Hashtable)mapProjection).put("fe", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("fn", el, null))) {
                        ((Hashtable)mapProjection).put("fn", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("phi1", el, null))) {
                        ((Hashtable)mapProjection).put("phi1", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("phi2", el, null))) {
                        ((Hashtable)mapProjection).put("phi2", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("ef", el, null))) {
                        ((Hashtable)mapProjection).put("ef", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("nf", el, null))) {
                        ((Hashtable)mapProjection).put("nf", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("k0", el, null))) {
                        ((Hashtable)mapProjection).put("k0", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("phi_f", el, null))) {
                        ((Hashtable)mapProjection).put("phi_f", param);
                    }
                    if (Strings.isNumeric(param = XmlUtils.getElString("lambda_f", el, null))) {
                        ((Hashtable)mapProjection).put("lambda_f", param);
                    }
                }
                prj.geoProjection = MapUtils.getPropAsString(mapProjection, ',');
            }
        }
        boolean isWrapText = XmlUtils.getElBoolean("WrapLayerTitles", root, false);
        nodes = root.getElementsByTagName(_TPR_DATASET);
        count = nodes.size();
        for (k = 0; k < count; ++k) {
            XmlElement elDataset = (XmlElement)nodes.elementAt(k);
            XmlElement elMetadata = elDataset.getFirstElementByName("metadata");
            String dsURL = XmlUtils.getElString(_TPR_PATH, elDataset, null);
            String dsType = XmlUtils.getElString(_TPR_TYPE, elDataset, "shp");
            String dsId = XmlUtils.getElString(_TPR_ECAI_ID, elDataset, null);
            if (MapUtils.isRunFromDisk && dsId != null) {
                layerSetup.addStatusInfo(0, null, "WARNING#116  dataset id#" + dsId);
                dsId = null;
            }
            if (dsURL == null && dsId == null && !"group".equalsIgnoreCase(dsType)) {
                layerSetup.addStatusInfo(105, null, "dataset#" + k);
                continue;
            }
            if (isDynAdd && prj.getLayerByDsId(dsId) != null) continue;
            Properties connectionData = new Properties();
            ((Hashtable)connectionData).put("type", dsType);
            if (dsURL != null) {
                ((Hashtable)connectionData).put("url", dsURL);
            }
            if (dsId != null) {
                ((Hashtable)connectionData).put("id", dsId);
            }
            if (!XmlUtils.getBoolean(_TPR_FORCESERVERDELIVERY, elDataset, dsId != null)) {
                ((Hashtable)connectionData).put("direct", "yes");
            }
            int reloadTimeRange = XmlUtils.getElInt("reloadtime", elDataset, 0);
            boolean isFullLoad = XmlUtils.getBoolean(_TPR_PRELOADDATASET, elDataset, false);
            boolean isForceEmptyLoad = XmlUtils.getBoolean(_TPR_PRELOADMETADATA, elDataset, false);
            Vector nodes2 = elDataset.getElementsByTagName(_TPR_LAYER);
            count2 = nodes2.size();
            if (count2 <= 0) {
                layerSetup.addStatusInfo(109, null, "dataset#" + k);
                continue;
            }
            for (int i = 0; i < count2; ++i) {
                Layer lyr;
                el = (XmlElement)nodes2.elementAt(i);
                String nom = XmlUtils.getElString("Handle", el, "unnamed");
                try {
                    lyr = layerSetup.createLayer(connectionData);
                }
                catch (AlovMapException e) {
                    layerSetup.addStatusInfo(e.getCode(), null, nom + "  " + e.getMessage());
                    continue;
                }
                if (LoaderTM3.loadLayer(prj, lyr, el)) {
                    Layer mainLayer;
                    Layer layer = mainLayer = lyr instanceof LayerRaster && ((LayerRaster)lyr).resolutionLevel > 0 ? null : prj.getLayerByDsId(lyr.datasetId);
                    if (mainLayer != null) {
                        lyr.metadata = mainLayer.metadata;
                        lyr.dataStorage = mainLayer.dataStorage;
                    }
                    if (elMetadata != null) {
                        lyr.metadata.loadMetadata3(elMetadata);
                        lyr.resolveMetadata();
                    }
                    lyr.metadata.reloadTimeRange = reloadTimeRange;
                    prj.layers.addElement(lyr);
                    if (lyr.id == null) {
                        lyr.id = prj.getLayerCount() + "-" + lyr.datasetId;
                    }
                    lyr.isFullLoad = lyr.isKeyMap || isFullLoad;
                    lyr.metadata.forceEmptyLoad = isForceEmptyLoad;
                    lyr.legendWrapText = isWrapText;
                    boolean bl = prj.hasKeyMap = prj.hasKeyMap || lyr.isKeyMap;
                    if (XmlUtils.getElBoolean("startup", el, false) || XmlUtils.getElBoolean(_TPR_ACTIVEONSTARTUP, el, false)) {
                        prj.startLayer = lyr.id;
                    }
                    lyr.removeOutOfExtent = isDynAdd && prj.isDynamic_RemoveOutOfExtent;
                    continue;
                }
                lyr.clear(true);
                lyr = null;
            }
        }
        if (!isDynAdd) {
            count2 = prj.getLayerCount();
            for (int i = 0; i < count2; ++i) {
                Layer lyr = prj.getLayerByIndex(i);
                lyr.drawOrder = count2 - lyr.drawOrder;
            }
            for (int i = 0; i < count2; ++i) {
                for (int j = count2 - 1; j > i; --j) {
                    int l2 = prj.getLayerByIndex((int)j).drawOrder;
                    int l1 = prj.getLayerByIndex((int)i).drawOrder;
                    if (l2 <= l1) continue;
                    Layer lyr = prj.getLayerByIndex(i);
                    prj.layers.setElementAt(prj.getLayerByIndex(j), i);
                    prj.layers.setElementAt(lyr, j);
                }
            }
        }
        if (prj.getLayerCount() == 0) {
            layerSetup.addStatusInfo(109, null, prj.name);
            throw new AlovMapException(109, prj.name);
        }
        nodes = root.getElementsByTagName(_TPR_RADIOGROUP);
        count = nodes.size();
        for (k = 0; k < count; ++k) {
            el = (XmlElement)nodes.elementAt(k);
            String name = XmlUtils.getElString("Name", el, null);
            int levels = XmlUtils.getElInt(_TPR_RADIOGROUP_LEVELS, el, 1);
            if (Strings.isNullOrBlank(name) || levels < 1 || prj.getRadioGroupByName(name) != null) {
                layerSetup.addStatusInfo(117, null, name);
                continue;
            }
            RadioGroup rg = new RadioGroup(name, levels);
            String dependent = XmlUtils.getElString(_TPR_CONTROL_VISIBILITY, el, null);
            if (!Strings.isNullOrBlank(dependent)) {
                StringTokenizer st = new StringTokenizer(dependent, " ,;");
                while (st.hasMoreTokens()) {
                    String layerId = st.nextToken();
                    Layer lyr = prj.getLayerById(layerId);
                    if (lyr == null) continue;
                    rg.addLayer(lyr);
                }
            }
            if (rg.size() > 1) {
                prj.radioGroups.addElement(rg);
                continue;
            }
            layerSetup.addStatusInfo(117, null, name);
        }
    }

    private static boolean loadLayer(Project prj, Layer lyr, XmlElement el) {
        try {
            StringTokenizer st;
            StringTokenizer tok;
            lyr.id = XmlUtils.getElString("Handle", el, null);
            lyr.setName(XmlUtils.getElString(_TPR_LayerTitle, el, null));
            if (lyr.getName() == null) {
                lyr.setName("unnamed#" + prj.getLayerCount() + 1);
            }
            layerSetup.addStatusInfo(0, lyr, "Parse");
            if (lyr.id != null && prj.getLayerById(lyr.id) != null) {
                layerSetup.addStatusInfo(106, lyr, lyr.id + " isn't unique");
                lyr.id = null;
            }
            lyr.metadata.passResolved = XmlUtils.getBoolean("password", el, true);
            lyr.metadata.passFirstTime = !prj.isDynamic;
            lyr.legendWrapText = XmlUtils.getElBoolean("WrapLayerTitles", el, false);
            lyr.zmin = XmlUtils.getElFloat(_TPR_ZoomMinDegrees, el, -1.0f) * 100.0f;
            lyr.zmax = XmlUtils.getElFloat(_TPR_ZoomMaxDegrees, el, -1.0f) * 100.0f;
            if (lyr.zmin < 0.0f) {
                lyr.zmin = 0.0f;
            }
            if (lyr.zmax < 0.0f) {
                lyr.zmax = 100000.0f;
            }
            lyr.zmin = XmlUtils.getElFloat(_TPR_ZoomMinKm, el, lyr.zmin);
            lyr.zmax = XmlUtils.getElFloat(_TPR_ZoomMaxKm, el, lyr.zmax);
            lyr.withinZoom = XmlUtils.getElBoolean(_TPR_WithinZoom, el, false);
            lyr.zoom_for_select = XmlUtils.getElFloat("ZoomLevelOnSelect", el, 0.0f);
            lyr.timeMin = ExDate.parseString(XmlUtils.getElString(_TPR_DateMin, el, "-10000000/1/1"));
            lyr.timeMax = ExDate.parseString(XmlUtils.getElString(_TPR_DateMax, el, "2050"));
            lyr.withinDate = (lyr.timeMin != null || lyr.timeMax != null) && XmlUtils.getElBoolean(_TPR_WithinDate, el, false);
            lyr.timeVarying = XmlUtils.getElBoolean(_TPR_TimeVarying, el, false);
            lyr.isKeyMap = XmlUtils.getElBoolean(_TPR_KEYMAP, el, false);
            if (lyr.isKeyMap) {
                lyr.setVisible(false);
                lyr.legendVisible = false;
            } else {
                lyr.visible_always = XmlUtils.getElBoolean(_TPR_LayerAlwaysVisible, el, false);
                lyr.setVisible(lyr.visible_always ? true : XmlUtils.getElBoolean(_TPR_LayerVisible, el, true));
                lyr.legendVisible = XmlUtils.getElBoolean(_TPR_ItemVisible, el, true);
                lyr.legendExpanded = XmlUtils.getElBoolean(_TPR_ItemExpanded, el, false);
                lyr.legendName = XmlUtils.getElString("Legend", el, null);
            }
            lyr.initiallyVisible = lyr.isVisible();
            String maps = XmlUtils.getElString(_TPR_SHOW_IN_THEMATIC_MAP, el, "all");
            if (!maps.equalsIgnoreCase("all")) {
                tok = new StringTokenizer(maps, " ,;");
                while (tok.hasMoreTokens()) {
                    String elt = tok.nextToken();
                    if (Strings.isNullOrBlank(elt = elt.trim()) || elt.equalsIgnoreCase("all")) continue;
                    lyr.themes.addElement(elt);
                }
            }
            lyr.legendObjectType = XmlUtils.getElInt("LegType", el, 0);
            maps = XmlUtils.getElString("legendsymbolshape", el, null);
            if (maps != null) {
                tok = new StringTokenizer(maps, " ,;");
                double[] tempArray = new double[1000];
                int cnt = 0;
                while (tok.hasMoreTokens()) {
                    tempArray[cnt] = MapUtils.toDouble(tok.nextToken());
                    ++cnt;
                }
                if (cnt > 0) {
                    double[] tempArray2 = new double[cnt];
                    System.arraycopy(tempArray, 0, tempArray2, 0, cnt);
                    lyr.legendSymbolShape = new Shape(tempArray2);
                }
                tempArray = null;
            }
            lyr.legendHideOutRange = XmlUtils.getElBoolean(_TPR_HIDELEGENDOUTOFRANGE, el, false);
            lyr.canSearch = XmlUtils.getElBoolean(_TPR_CANSEARCH, el, true);
            lyr.drawOrder = XmlUtils.getElInt(_TPR_DRAWORDER, el, 0);
            lyr.linkMain = XmlUtils.getElString(_TPR_WEB_LINK, el, lyr.linkMain);
            String dependent = XmlUtils.getElString(_TPR_CONTROL_VISIBILITY, el, null);
            if (!Strings.isNullOrBlank(dependent)) {
                st = new StringTokenizer(dependent, " ,;");
                lyr.controlledLayers = new Hashtable();
                while (st.hasMoreTokens()) {
                    lyr.controlledLayers.put(st.nextToken(), "1");
                }
            }
            if (!Strings.isNullOrBlank(dependent = XmlUtils.getElString("ControlsInverseVisibilityOf", el, null))) {
                st = new StringTokenizer(dependent, " ,;");
                if (lyr.controlledLayers == null) {
                    lyr.controlledLayers = new Hashtable();
                }
                while (st.hasMoreTokens()) {
                    lyr.controlledLayers.put(st.nextToken(), "0");
                }
            }
            if (lyr instanceof LayerVector) {
                XmlElement el2;
                int i;
                if (lyr instanceof LayerZoomify) {
                    ((LayerZoomify)lyr).maxPixelSize = XmlUtils.getElFloat("resolution", el, 2.0f);
                    ((LayerZoomify)lyr).transparency = XmlUtils.getElInt("transparency", el, -1);
                    lyr.canSearch = false;
                }
                ((LayerVector)lyr).linkSearch = XmlUtils.getElString(_TPR_WEB_SRCH, el, ((LayerVector)lyr).linkSearch);
                ((LayerVector)lyr).linkInfo = XmlUtils.getElString(_TPR_WEB_INFO, el, ((LayerVector)lyr).linkInfo);
                ((LayerVector)lyr).linkTips = XmlUtils.getElString(_TPR_WEB_ROLLOVER, el, ((LayerVector)lyr).linkTips);
                ((LayerVector)lyr).localFilter = XmlUtils.getElString(_TPR_LAYER_FILTER, el, ((LayerVector)lyr).localFilter);
                boolean useDefault = false;
                Vector nodes = el.getElementsByTagName(_TPR_SYMBOL);
                int count = nodes.size();
                boolean isNotSet_SelSymbol = false;
                boolean isDefNotFound = true;
                for (i = 0; i < count; ++i) {
                    el2 = (XmlElement)nodes.elementAt(i);
                    if (XmlUtils.getElBoolean(_TPR_SymDefault, el2, false) && isDefNotFound) {
                        LoaderTM3.loadSymbol(((LayerVector)lyr).symbol, null, el2, false, true);
                        isDefNotFound = false;
                        useDefault = XmlUtils.getElBoolean(sDrawBackground, el, true);
                        continue;
                    }
                    if (!XmlUtils.getElBoolean(_TPR_IsSelectionSymbol, el2, false)) continue;
                    LoaderTM3.loadSymbol(((LayerVector)lyr).selectedSymbol, null, el2, false, true);
                    isNotSet_SelSymbol = false;
                }
                if (isNotSet_SelSymbol) {
                    ((LayerVector)lyr).selectedSymbol.style = ((LayerVector)lyr).symbol.style;
                    ((LayerVector)lyr).selectedSymbol.fontStyle = ((LayerVector)lyr).symbol.fontStyle;
                    ((LayerVector)lyr).selectedSymbol.size = ((LayerVector)lyr).symbol.size;
                }
                nodes = el.getElementsByTagName(_TPR_RENDERER);
                count = nodes.size();
                for (i = 0; i < count; ++i) {
                    el2 = (XmlElement)nodes.elementAt(i);
                    int k = XmlUtils.getElInt(_TPR_RendType, el2, 0);
                    Renderer rend = null;
                    switch (k) {
                        case 1: {
                            rend = new RendererGrad(lyr);
                            rend.equal = -1;
                            break;
                        }
                        case 7: {
                            rend = new RendererGrad(lyr);
                            rend.equal = 2;
                            break;
                        }
                        case 2: {
                            rend = new RendererGrad(lyr);
                            rend.equal = 0;
                            break;
                        }
                        case 3: {
                            rend = new RendererDot(lyr);
                            break;
                        }
                        case 4: {
                            rend = new RendererLabel(lyr);
                            rend.equal = 0;
                            break;
                        }
                        case 5: {
                            rend = new RendererChart(lyr);
                            break;
                        }
                        case 9: {
                            rend = new RendererDef(lyr);
                        }
                    }
                    if (rend != null) {
                        if (!LoaderTM3.loadRenderer(lyr, rend, el2)) continue;
                        rend.name = String.valueOf(i);
                        lyr.renderers.addElement(rend);
                        continue;
                    }
                    layerSetup.addStatusInfo(107, lyr, "Renderer#" + i + " type=" + k);
                }
                if (lyr.renderers.size() == 0 || useDefault) {
                    lyr.renderers.insertElementAt(lyr.createDefaultRenderer(), 0);
                }
            } else if (lyr instanceof LayerRaster) {
                ((LayerRaster)lyr).resolutionLevel = XmlUtils.getElInt("resolution", el, 0);
                ((LayerRaster)lyr).transparentColor = XmlUtils.getElColor("transparentColor", el, null);
                ((LayerRaster)lyr).transparency = XmlUtils.getElInt("transparency", el, -1);
                Renderer rend = lyr.createDefaultRenderer();
                rend.name = "1";
                rend.label = XmlUtils.getElString(sLegendLabel4Image, el, null);
                rend.legendVisible = rend.label != null;
                lyr.renderers.addElement(rend);
            }
            return true;
        }
        catch (Exception e) {
            layerSetup.addStatusInfo(106, lyr, null);
            e.printStackTrace();
            return false;
        }
    }

    private static boolean loadRenderer(Layer lyr, Renderer rend, XmlElement el) {
        try {
            Renderer rg;
            rend.label = XmlUtils.getElString(sRendHeader, el, null);
            rend.legendVisible = XmlUtils.getElBoolean(sLegShow, el, true);
            rend.allowToggle = XmlUtils.getElBoolean("AllowOnOffInLegend", el, false);
            rend.enabled = XmlUtils.getElBoolean(sEnabled, el, true);
            rend.radioGroupLevel = XmlUtils.getElInt(_TPR_RADIOGROUPLEVEL, el, 0);
            String maps = XmlUtils.getElString(_TPR_SHOW_IN_THEMATIC_MAP, el, "all");
            if (!maps.equalsIgnoreCase("all")) {
                StringTokenizer tok = new StringTokenizer(maps, " ,;");
                while (tok.hasMoreTokens()) {
                    String elt = tok.nextToken();
                    if (Strings.isNullOrBlank(elt = elt.trim()) || elt.equalsIgnoreCase("all")) continue;
                    rend.themes.addElement(elt);
                }
            }
            rend.drawMarker = XmlUtils.getElBoolean("DrawMarker", el, false);
            Vector nodes = el.getElementsByTagName(_TPR_SYMBOL);
            int symbolCount = nodes.size();
            rend.symbolsUnprepared = new Vector();
            boolean isFontMaker = rend instanceof RendererLabel;
            if (symbolCount > 0) {
                Symbol prevSym = null;
                for (int i = 0; i < symbolCount; ++i) {
                    Symbol sym = new Symbol();
                    XmlElement elSymbol = (XmlElement)nodes.elementAt(i);
                    if (!LoaderTM3.loadSymbol(sym, prevSym, elSymbol, isFontMaker, false)) continue;
                    if (!isFontMaker || symbolCount > 1) {
                        // empty if block
                    }
                    sym.drawMarker = rend.drawMarker;
                    rend.symbolsUnprepared.addElement(sym);
                    if (prevSym != null) continue;
                    prevSym = sym;
                }
            }
            if (rend instanceof RendererDef) {
                if (rend.symbolsUnprepared.size() > 0) {
                    rend.symbols = new Symbol[1];
                    rend.symbols[0] = (Symbol)rend.symbolsUnprepared.elementAt(0);
                }
            } else if (rend instanceof RendererChart) {
                rg = (RendererChart)rend;
                rg.outlineColor = XmlUtils.getElBoolean(sShowOutline, el, true) ? Color.black : null;
                rg.nullValue = XmlUtils.getElFloat(sNullValueOmitChart, el, Float.NaN);
                int t = XmlUtils.getElInt(sChartType, el, 0);
                int n = rg.type = t == 1 ? 2 : 1;
                if (rg.type == 2) {
                    rg.normalization = XmlUtils.getElFloat("normalization", el, 0.0f);
                    rg.normFieldName = XmlUtils.getElString(sNormalizationField, el, null);
                    rg.height = XmlUtils.getElInt(sBarHeight, el, 50);
                    rg.width = XmlUtils.getElInt(sBarWidth, el, 25);
                } else {
                    rg.sizeFieldName = XmlUtils.getElString(sSizeField, el, null);
                    rg.minSize = XmlUtils.getElInt(sMinPieSize, el, 8);
                    rg.maxSize = XmlUtils.getElInt(sMaxPieSize, el, 50);
                }
                nodes = el.getElementsByTagName(_TPR_FIELD);
                int count = nodes.size();
                if (count == 0) {
                    nodes = el.getElementsByTagName(sChartField);
                    count = nodes.size();
                }
                rg.fieldsUnprepared = new Vector();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        XmlElement fieldEl = (XmlElement)nodes.elementAt(i);
                        String s = XmlUtils.getElString(sRenderField, fieldEl, XmlUtils.getElString(sFieldName, fieldEl, null));
                        if (s == null) continue;
                        FieldDef fi = new FieldDef();
                        fi.index = -1;
                        fi.name = s;
                        fi.color = XmlUtils.getElColor("color", fieldEl, XmlUtils.getElColor(sDisplayColor, fieldEl, Color.white));
                        fi.label = s;
                        rg.fieldsUnprepared.addElement(fi);
                    }
                }
                if (rg.fieldsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
                lyr.hasChart = true;
            } else if (rend instanceof RendererGrad) {
                RendererGrad rg2 = (RendererGrad)rend;
                rg2.fieldName = XmlUtils.getElString(sRenderField, el, null);
                int cnt = rg2.symbolsUnprepared.size();
                if (rg2.fieldName == null && rg2.equal != 2 || cnt <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
                if (rg2.equal < 0 && cnt > 1) {
                    Symbol sym1 = (Symbol)rg2.symbolsUnprepared.elementAt(cnt - 2);
                    Symbol sym2 = (Symbol)rg2.symbolsUnprepared.elementAt(cnt - 1);
                    sym2.valueStr = sym1.valueStr;
                }
                rg2.drawDefault = XmlUtils.getElBoolean(_TPR_UseDefault, el, false);
            } else if (rend instanceof RendererDot) {
                rg = (RendererDot)rend;
                ((RendererDot)rg).fieldName = XmlUtils.getElString(sRenderField, el, null);
                ((RendererDot)rg).dotSize = XmlUtils.getElFloat("ValuePerDot", el, 10000.0f);
                if (((RendererDot)rg).fieldName == null || ((RendererDot)rg).dotSize <= 0.0f) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
                rend.symbols = new Symbol[1];
                rend.symbols[0] = new Symbol(XmlUtils.getElColor("DotColor", el, Color.black), Color.black, true, false, XmlUtils.getElInt("DotSize", el, 5));
            } else if (rend instanceof RendererLabel) {
                RendererLabel rg3 = (RendererLabel)rend;
                rg3.labelFieldName = XmlUtils.getElString(sRenderField, el, null);
                if (rg3.labelFieldName == null || rg3.symbolsUnprepared.size() <= 0) {
                    layerSetup.addStatusInfo(108, lyr, "renderer#" + rend.name);
                    return false;
                }
                rg3.symbolFieldName = XmlUtils.getElString(sSymbolField, el, null);
                rg3.rotationFieldName = XmlUtils.getElString(sRotationField, el, null);
                rg3.sizeFieldName = XmlUtils.getElString(sHeightField, el, null);
                rg3.useDefault = true;
            }
            return true;
        }
        catch (Exception e) {
            layerSetup.addStatusInfo(106, lyr, "renderer#" + rend.name);
            return false;
        }
    }

    public static boolean loadSymbol(Symbol symb, Symbol prevSymb, XmlElement el, boolean isFontMarker, boolean useDefault) {
        if (el == null) {
            return false;
        }
        boolean isDefault = XmlUtils.getElBoolean(_TPR_SymDefault, el, false);
        if (!isDefault || useDefault) {
            int symType;
            int iDef = prevSymb == null ? 4 : prevSymb.SymType;
            symb.SymType = symType = XmlUtils.getElInt(sSymType, el, iDef);
            iDef = prevSymb == null ? (isFontMarker ? 10 : (symType == 0 ? 4 : 1)) : prevSymb.size;
            symb.size = XmlUtils.getElInt(sSymSize, el, iDef);
            if (symType == 0 && prevSymb == null) {
                symb.size += 2;
            }
            symb.minSize = symb.size;
            symb.maxSize = XmlUtils.getElInt("maxsize", el, 25);
            symb.useZoom = XmlUtils.getElBoolean(_IncreaseSizeWithZoom, el, false) && symb.minSize < symb.maxSize;
            iDef = prevSymb == null ? 0 : prevSymb.style;
            symb.fontStyle = symb.style = XmlUtils.getElInt(sSymStyle, el, iDef);
            symb.fill = symb.style == 0 || symb.style > 7 || symType != 2;
            Color clrDef = prevSymb == null ? Color.black : prevSymb.fillColor;
            symb.fillColor = XmlUtils.getElColor(sSymColor, el, clrDef);
            symb.imageAnimated = XmlUtils.getElBoolean(sSymAnimated, el, false);
            symb.imageUrl = XmlUtils.getElString(sSymCustomStyleFile, el, null);
            if (isFontMarker && symb.size < 10) {
                symb.size = 10;
            } else if (symb.size > 100) {
                symb.size = 100;
            }
            if (!isFontMarker) {
                float[] dashPattern;
                if (symType == 1) {
                    symb.outline = true;
                    symb.outlineColor = symb.fillColor;
                    if (Utils2D.have2d()) {
                        symb.g2dStroke = new Vector();
                        symb.g2dStrokeColours = new Vector();
                        dashPattern = LoaderTM3.moStyleToDashPattern(symb.style);
                        symb.g2dStroke.addElement(Load2D.getBasicStroke(symb.size, "butt", "square", 0.0f, dashPattern, 0.0f));
                        symb.g2dStrokeColours.addElement(symb.outlineColor);
                    }
                } else {
                    symb.outline = XmlUtils.getElBoolean(sSymOutline, el, true);
                    clrDef = prevSymb == null ? Color.black : prevSymb.outlineColor;
                    symb.outlineColor = XmlUtils.getElColor(sOutlineColor, el, clrDef);
                }
                if (symType == 2) {
                    if (null == el.getFirstElementByName("Paint")) {
                        if (Utils2D.have2d()) {
                            Object paint;
                            symb.g2dPaint = paint = LoaderTM3.moStyleToPaint(symb);
                            boolean bl = symb.fill = paint != null || symb.style > 5;
                            if (symb.imageUrl != null) {
                                symb.textureAnchor = null;
                                symb.textureUrl = symb.imageUrl;
                                symb.fill = true;
                            }
                        } else if (symb.style > 0) {
                            symb.fill = false;
                        }
                    }
                    if (Utils2D.have2d() && 1 < symb.size) {
                        dashPattern = null;
                        if (null == symb.g2dStroke) {
                            symb.g2dStroke = new Vector();
                        }
                        if (null == symb.g2dStrokeColours) {
                            symb.g2dStrokeColours = new Vector();
                        }
                        symb.g2dStroke.addElement(Load2D.getBasicStroke(symb.size, "butt", "square", 0.0f, dashPattern, 0.0f));
                        symb.g2dStrokeColours.addElement(symb.outlineColor);
                    }
                }
            } else if (symType == 0) {
                symb.outline = XmlUtils.getElBoolean(sSymOutline, el, true);
                clrDef = prevSymb == null ? Color.black : prevSymb.outlineColor;
                symb.outlineColor = XmlUtils.getElColor(sOutlineColor, el, clrDef);
            }
            symb.offsetMin = Strings.time2DeltaExtDate(XmlUtils.getElString("offsetmin", el, null));
            symb.offsetMax = Strings.time2DeltaExtDate(XmlUtils.getElString("offsetmax", el, null));
            symb.label = XmlUtils.getElString(sRemark, el, null);
            symb.valueStr = XmlUtils.getElString(sSymValueStr, el, null);
            if (symb.valueStr == null) {
                symb.valueStr = XmlUtils.getElString(sSymValue, el, null);
            }
            symb.legendVisible = XmlUtils.getElBoolean(sLegShow, el, true);
            symb.visible = XmlUtils.getElBoolean(sEnabled, el, true);
            if (isFontMarker || symb.style == 4 && symType == 0) {
                symb.outline = XmlUtils.getElBoolean(sSymOutline, el, true);
                symb.fontName = XmlUtils.getElString(sSymFont, el, MapUtils.defaultPlainFont.getName());
                symb.fontStyle = XmlUtils.getElInt(sFontStyle, el, 0);
                symb.sampleFont = symb.font = MapUtils.createAndVerifyFont(symb.fontName, symb.fontStyle, symb.size, null);
                if (symb.font == null) {
                    layerSetup.addStatusInfo(117, null, symb.fontName);
                    return false;
                }
                symb.align = XmlUtils.getElInt("align", el, 2);
                symb.align = XmlUtils.getElInt("labelstyle", el, 2);
                symb.rotation = -XmlUtils.getElFloat("rotation", el, 0.0f);
                symb.rotation = symb.rotation / 180.0f * (float)Math.PI;
                symb.xOffset = XmlUtils.getElInt("xoffset", el, 0);
                symb.yOffset = XmlUtils.getElInt("yoffset", el, 0);
                int posV = XmlUtils.getElInt(_VerAlign, el, 0);
                int posH = XmlUtils.getElInt(_HorAlign, el, 0);
                symb.position = posV > 0 || posH > 0 ? (posV == 2 ? (posH == 3 ? 7 : (posH == 4 ? 1 : 8)) : (posV == 1 ? (posH == 3 ? 5 : (posH == 4 ? 3 : 4)) : (posH == 3 ? 6 : (posH == 4 ? 2 : 0)))) : 1;
                char ch = (char)XmlUtils.getElInt("CharIndex", el, 0);
                symb.charMarker = new Character(ch).toString();
            }
            Loader.load2Dfeatures(el, symb);
            return true;
        }
        return false;
    }

    private static Object moStyleToPaint(Symbol symb) {
        int r = symb.fillColor.getRed();
        int g = symb.fillColor.getGreen();
        int b = symb.fillColor.getBlue();
        switch (symb.style) {
            case 0: {
                return symb.fillColor;
            }
            case 1: {
                return null;
            }
            case 2: {
                return new GradientPaint(0.0f, 0.0f, new Color(r, g, b, 0), 0.0f, 2.0f, new Color(r, g, b, 255), true);
            }
            case 3: {
                return new GradientPaint(0.0f, 0.0f, new Color(r, g, b, 0), 2.0f, 0.0f, new Color(r, g, b, 255), true);
            }
            case 4: {
                return new GradientPaint(2.0f, 0.0f, new Color(r, g, b, 0), 0.0f, 2.0f, new Color(r, g, b, 255), true);
            }
            case 5: {
                return new GradientPaint(0.0f, 0.0f, new Color(r, g, b, 0), 2.0f, 2.0f, new Color(r, g, b, 255), true);
            }
            case 6: {
                symb.textureAnchor = new Rectangle(0, 0, 8, 8);
                symb.textureUrl = "TMJavaResources/img/cross.gif";
                return null;
            }
            case 7: {
                symb.textureAnchor = new Rectangle(0, 0, 8, 8);
                symb.textureUrl = "TMJavaResources/img/cross_diag.gif";
                return null;
            }
            case 8: {
                symb.style = 0;
                return new Color(r, g, b, 190);
            }
            case 9: {
                symb.style = 0;
                return new Color(r, g, b, 235);
            }
            case 10: {
                symb.style = 0;
                return new Color(r, g, b, 240);
            }
        }
        return null;
    }

    private static float[] moStyleToDashPattern(int lineStyle) {
        switch (lineStyle) {
            case 1: {
                return new float[]{16.0f, 4.0f};
            }
            case 2: {
                return new float[]{2.0f, 2.0f};
            }
            case 3: {
                return new float[]{8.0f, 4.0f, 2.0f, 4.0f};
            }
            case 4: {
                return new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f};
            }
        }
        return null;
    }
}

