/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.util.Strings;

class Load2D {
    private static Method transform = null;
    private static Method make = null;
    private static boolean projectionFail = false;
    private static Class ofClass = null;
    private static Class opClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage toBufferedImage(Image image, int imgWidth, int imgHeight) {
        BufferedImage img = new BufferedImage(imgWidth, imgHeight, 6);
        Graphics g = img.getGraphics();
        if (g != null) {
            try {
                g.drawImage(image, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }
        return img;
    }

    private Load2D() {
    }

    static TexturePaint getTexturePaint(Image image, int imgWidth, int imgHeight, Rectangle rect) {
        return new TexturePaint(Load2D.toBufferedImage(image, imgWidth, imgHeight), rect);
    }

    static GradientPaint getGradientPaint(float x1, float y1, Color color1, float x2, float y2, Color color2, boolean cyclic) {
        return new GradientPaint(x1, y1, color1, x2, y2, color2, cyclic);
    }

    static BasicStroke getBasicStroke(float width, String sCap, String sJoin, float miterLimit, float[] finalDashPattern, float dashPhase) {
        String ROUND = "round";
        String SQUARE = "square";
        String MITER = "miter";
        int cap = 0;
        int join = 2;
        if (sCap != null) {
            if ("round".equalsIgnoreCase(sCap)) {
                cap = 1;
            } else if ("square".equalsIgnoreCase(sCap)) {
                cap = 2;
            }
        }
        if (sJoin != null) {
            if ("miter".equalsIgnoreCase(sJoin)) {
                join = 0;
            } else if ("round".equalsIgnoreCase(sJoin)) {
                join = 1;
            }
        }
        if (finalDashPattern == null) {
            return new BasicStroke(width, cap, join, miterLimit);
        }
        return new BasicStroke(width, cap, join, miterLimit, finalDashPattern, dashPhase);
    }

    static AlphaComposite getAlphaComposite(String sRule, float alpha) {
        int rule = 3;
        try {
            Class<?> alphaCompositeClass = Class.forName("java.awt.AlphaComposite");
            rule = alphaCompositeClass.getField(sRule).getInt(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AlphaComposite.getInstance(rule, alpha);
    }

    static boolean isInvalidFont(Font font, String test) {
        if (null == font) {
            return true;
        }
        if (Strings.isNullOrBlank(test)) {
            return !font.canDisplay('A');
        }
        int res = font.canDisplayUpTo(test);
        return res >= 0 && res < test.length();
    }

    static void makeProjection(Layer lyr, String targetProj) {
        if (projectionFail) {
            return;
        }
        try {
            if (transform == null) {
                ofClass = Class.forName("org.alov.projections.OperationFactory");
                opClass = Class.forName("org.alov.projections.Operation");
                if (ofClass == null || opClass == null) {
                    projectionFail = true;
                    return;
                }
                make = ofClass.getMethod("make", new String().getClass(), new String().getClass());
                transform = opClass.getMethod("transform2", new LayerVector().getClass(), new Boolean(false).getClass());
            }
            Object of = ofClass.newInstance();
            Object op = null;
            if (of != null) {
                op = make.invoke(of, lyr.metadata.getStr(162), targetProj);
            }
            if (op != null) {
                transform.invoke(op, lyr, new Boolean(false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

