/*
 * Decompiled with CFR 0.152.
 */
package org.alov.map;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.alov.map.Layer;
import org.alov.util.Const;
import org.alov.util.Log;
import org.alov.util.Logger;
import org.alov.util.Strings;

public class ClientLog
implements Logger,
Const {
    private static Hashtable explanations = null;
    static final String ASTERICS = "***";
    private static final String DATE_FORMAT = "yyyy.MM.dd hh:mm:ss";
    public static boolean showMapName = false;
    private SimpleDateFormat sdf2 = new SimpleDateFormat("hh:mm:ss");
    private Vector status = new Vector();

    public void setExplanations(Hashtable explanations) {
        ClientLog.explanations = explanations;
    }

    public void init() {
    }

    public void log(int level, String message) {
        if (this.status.size() > 30) {
            this.status.removeElementAt(1);
        }
        this.status.addElement(message);
        if (Log.debugLevel > 1) {
            System.out.println(message);
        }
    }

    public void log(int level, Exception ex) {
        this.log(level, ex.getMessage());
    }

    public Vector getStatus() {
        return this.status;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.status.size(); ++i) {
            sb.append((String)this.status.elementAt(i)).append("\r\n");
        }
        return sb.toString();
    }

    public void addStatusInfo(int messageCode, String mapName, Layer lyr, String obj) {
        String sMessage;
        StringBuffer sMess = new StringBuffer();
        if (this.status.size() == 0) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            sMess.append(sdf.format(new Date(System.currentTimeMillis())));
        } else {
            sMess.append(this.sdf2.format(new Date(System.currentTimeMillis())));
        }
        if (!Strings.isNullOrBlank(mapName) && showMapName) {
            sMess.append(" ").append(mapName);
        }
        String sLayer = "";
        if (lyr != null) {
            if (!Strings.isNullOrBlank(lyr.datasetId) && lyr.provider == null) {
                sLayer = "#" + lyr.datasetId + ": ";
            }
            sLayer = sLayer + lyr.getName() + ". ";
        }
        sMess.append("  ");
        String string = sMessage = Strings.isNullOrBlank(obj) ? "" : obj + ". ";
        if (messageCode > 0) {
            String expl;
            this.log(-1, "");
            sMess.append("  ").append(ASTERICS).append(" ").append("ERROR#" + messageCode).append(" ").append(ASTERICS).append("  ").append(sLayer).append(sMessage);
            this.log(-1, sMess.toString());
            if (explanations != null && !Strings.isNullOrBlank(expl = (String)explanations.get(String.valueOf(messageCode)))) {
                this.log(-1, "");
                this.log(-1, expl);
            }
            this.log(-1, "");
        } else {
            sMess.append("  ").append(sMessage).append(sLayer);
            this.log(0, sMess.toString());
        }
    }

    public void kill() {
        this.status.removeAllElements();
        this.status = null;
    }
}

