/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.text;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.text.DefineFontInfo;

public class DefineFontInfo2
extends DefineFontInfo {
    public static final int LANGCODE_DEFAULT = 0;
    public static final int LANGCODE_LATIN = 1;
    public static final int LANGCODE_JAPANESE = 2;
    public static final int LANGCODE_KOREAN = 3;
    public static final int LANGCODE_CHINESE_S = 4;
    public static final int LANGCODE_CHINESE_T = 5;
    private int languageCode = 0;

    public int getTagCode() {
        return 13;
    }

    public long getTagLength() {
        byte[] bName;
        try {
            bName = this.getFontName().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bName = new byte[]{};
        }
        int tl = 3 + bName.length + 1;
        tl += this.getGlyphsCount();
        if (this.isFlagWideCodes()) {
            tl += this.getGlyphsCount();
        }
        return tl;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.getCharacterID());
        byte[] bName = this.getFontName().getBytes("UTF-8");
        fs.writeUI8(bName.length);
        int i = 0;
        while (i < bName.length) {
            fs.write(bName);
            ++i;
        }
        fs.writeBits(0, 2);
        fs.writeUB1(this.isFlagSmallText());
        fs.writeUB1(this.isFlagShiftJIS());
        fs.writeUB1(this.isFlagANSI());
        fs.writeUB1(this.isFlagItalic());
        fs.writeUB1(this.isFlagBold());
        fs.writeUB1(this.isFlagWideCodes());
        fs.writeUI8(this.languageCode);
        i = 0;
        while (i < this.getGlyphsCount()) {
            if (this.isFlagWideCodes()) {
                fs.writeUI16(this.getGlyphCode(i));
            } else {
                fs.writeUI8(this.getGlyphCode(i));
            }
            ++i;
        }
    }

    public int getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(int languageCode) {
        this.languageCode = languageCode;
    }
}

