/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.text;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.alov.flashapi.DefinitionTag;
import org.alov.flashapi.FlashOutputStream;

public class DefineFontInfo
extends DefinitionTag {
    private String fontName = "";
    private boolean flagSmallText = false;
    private boolean flagShiftJIS = false;
    private boolean flagANSI = false;
    private boolean flagItalic = false;
    private boolean flagBold = false;
    private boolean flagWideCodes = false;
    private int glyphsCount = 0;
    private int[] codeTable = new int[this.glyphsCount];

    public int getTagCode() {
        return 13;
    }

    public long getTagLength() {
        byte[] bName;
        try {
            bName = this.fontName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bName = new byte[]{};
        }
        int tl = 3 + bName.length + 1;
        tl += this.glyphsCount;
        if (this.flagWideCodes) {
            tl += this.glyphsCount;
        }
        return tl;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.getCharacterID());
        byte[] bName = this.fontName.getBytes("UTF-8");
        fs.writeUI8(bName.length);
        int i = 0;
        while (i < bName.length) {
            fs.write(bName);
            ++i;
        }
        fs.writeBits(0, 2);
        fs.writeUB1(this.flagSmallText);
        fs.writeUB1(this.flagShiftJIS);
        fs.writeUB1(this.flagANSI);
        fs.writeUB1(this.flagItalic);
        fs.writeUB1(this.flagBold);
        fs.writeUB1(this.flagWideCodes);
        i = 0;
        while (i < this.glyphsCount) {
            if (this.flagWideCodes) {
                fs.writeUI16(this.codeTable[i]);
            } else {
                fs.writeUI8(this.codeTable[i]);
            }
            ++i;
        }
    }

    public boolean isFlagANSI() {
        return this.flagANSI;
    }

    public void setFlagANSI(boolean flagANSI) {
        this.flagANSI = flagANSI;
    }

    public boolean isFlagBold() {
        return this.flagBold;
    }

    public void setFlagBold(boolean flagBold) {
        this.flagBold = flagBold;
    }

    public boolean isFlagItalic() {
        return this.flagItalic;
    }

    public void setFlagItalic(boolean flagItalic) {
        this.flagItalic = flagItalic;
    }

    public boolean isFlagShiftJIS() {
        return this.flagShiftJIS;
    }

    public void setFlagShiftJIS(boolean flagShiftJIS) {
        this.flagShiftJIS = flagShiftJIS;
    }

    public boolean isFlagSmallText() {
        return this.flagSmallText;
    }

    public void setFlagSmallText(boolean flagSmallText) {
        this.flagSmallText = flagSmallText;
    }

    public boolean isFlagWideCodes() {
        return this.flagWideCodes;
    }

    public void setFlagWideCodes(boolean flagWideCodes) {
        this.flagWideCodes = flagWideCodes;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getGlyphsCount() {
        return this.glyphsCount;
    }

    public void setGlyphsCount(int glyphsCount) {
        this.glyphsCount = glyphsCount;
        int[] oldTable = this.codeTable;
        this.codeTable = new int[glyphsCount];
        System.arraycopy(oldTable, 0, this.codeTable, 0, Math.min(oldTable.length, this.codeTable.length));
    }

    public void setGlyphCode(int index, int code) {
        if (index < this.glyphsCount && index >= 0) {
            this.codeTable[index] = code;
        }
    }

    public int getGlyphCode(int index) {
        int result = -1;
        if (index < this.glyphsCount && index >= 0) {
            result = this.codeTable[index];
        }
        return result;
    }
}

