/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.text;

import java.awt.Font;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.text.DefineFont;
import org.alov.flashapi.text.DefineFontInfo2;

public class DefineFont2
extends DefineFont {
    private DefineFontInfo2 fontInfo = new DefineFontInfo2();
    private boolean flagHasLayout = false;
    private boolean flagWideOffsets = false;
    private int fontAscent = 0;
    private int fontDescent = 0;
    private int fontLeading = 0;
    private int[] fontAdvanceTable = new int[0];
    private long codeTableOffset;

    public DefineFont2() {
        this(null);
    }

    public DefineFont2(Font font) {
        if (font != null) {
            this.setFontName(font.getFontName(Locale.ENGLISH));
        }
    }

    public void setCharacterID(int fontID) {
        super.setCharacterID(fontID);
        this.fontInfo.setCharacterID(fontID);
    }

    public int getGlyphsCount() {
        return super.getGlyphsCount();
    }

    public void setGlyphsCount(int glyphsCount) {
        super.setGlyphsCount(glyphsCount);
        this.fontInfo.setGlyphsCount(glyphsCount);
        int[] oldAdvance = this.fontAdvanceTable;
        this.fontAdvanceTable = new int[glyphsCount];
        System.arraycopy(oldAdvance, 0, this.fontAdvanceTable, 0, Math.min(oldAdvance.length, this.fontAdvanceTable.length));
    }

    public void setGlyphCode(int index, int code) {
        this.fontInfo.setGlyphCode(index, code);
    }

    public int getGlyphCode(int index) {
        return this.fontInfo.getGlyphCode(index);
    }

    public void setFontAdvance(int index, int advance) {
        if (index < this.getGlyphsCount() && index >= 0) {
            this.fontAdvanceTable[index] = advance;
        }
    }

    public int getFontAdvance(int index) {
        int result = 0;
        if (index < this.getGlyphsCount() && index >= 0) {
            result = this.fontAdvanceTable[index];
        }
        return result;
    }

    public boolean isFlagHasLayout() {
        return this.flagHasLayout;
    }

    public void setFlagHasLayout(boolean flagHasLayout) {
        if (flagHasLayout) {
            throw new UnsupportedOperationException("Layout is not implemented.");
        }
        this.flagHasLayout = flagHasLayout;
    }

    public boolean isFlagANSI() {
        return this.fontInfo.isFlagANSI();
    }

    public void setFlagANSI(boolean flagANSI) {
        this.fontInfo.setFlagANSI(flagANSI);
    }

    public boolean isFlagBold() {
        return this.fontInfo.isFlagBold();
    }

    public void setFlagBold(boolean flagBold) {
        this.fontInfo.setFlagBold(flagBold);
    }

    public boolean isFlagItalic() {
        return this.fontInfo.isFlagItalic();
    }

    public void setFlagItalic(boolean flagItalic) {
        this.fontInfo.setFlagItalic(flagItalic);
    }

    public boolean isFlagShiftJIS() {
        return this.fontInfo.isFlagShiftJIS();
    }

    public void setFlagShiftJIS(boolean flagShiftJIS) {
        this.fontInfo.setFlagShiftJIS(flagShiftJIS);
    }

    public boolean isFlagSmallText() {
        return this.fontInfo.isFlagSmallText();
    }

    public void setFlagSmallText(boolean flagSmallText) {
        this.fontInfo.setFlagSmallText(flagSmallText);
    }

    public boolean isFlagWideCodes() {
        return this.fontInfo.isFlagWideCodes();
    }

    public void setFlagWideCodes(boolean flagWideCodes) {
        this.fontInfo.setFlagWideCodes(flagWideCodes);
    }

    public boolean isFlagWideOffsets() {
        return this.flagWideOffsets;
    }

    public void setFlagWideOffsets(boolean flagWideOffsets) {
        this.flagWideOffsets = flagWideOffsets;
    }

    public int getLanguageCode() {
        return this.fontInfo.getLanguageCode();
    }

    public void setLanguageCode(int languageCode) {
        this.fontInfo.setLanguageCode(languageCode);
    }

    public String getFontName() {
        return this.fontInfo.getFontName();
    }

    public void setFontName(String fontName) {
        this.fontInfo.setFontName(fontName);
    }

    public int getTagCode() {
        return 48;
    }

    public long getTagLength() {
        byte[] bName;
        int tl = 5;
        try {
            bName = this.getFontName().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            bName = new byte[]{};
        }
        tl += bName.length + 1;
        tl += 2;
        tl += 2 * this.getGlyphsCount();
        this.codeTableOffset = 2 * this.getGlyphsCount();
        if (this.isFlagWideOffsets()) {
            tl += 2 * this.getGlyphsCount();
            this.codeTableOffset += (long)(2 * this.getGlyphsCount());
        }
        tl += 2;
        this.codeTableOffset += 2L;
        if (this.isFlagWideOffsets()) {
            tl += 2;
            this.codeTableOffset += 2L;
        }
        int bitLength = 0;
        int i = 0;
        while (i < this.getGlyphsCount()) {
            bitLength += this.getGlyphShape(i).getLength(0) + 7 >> 3 << 3;
            ++i;
        }
        tl += bitLength >> 3;
        this.codeTableOffset += (long)(bitLength >> 3);
        tl += this.getGlyphsCount();
        if (this.isFlagWideOffsets()) {
            tl += this.getGlyphsCount();
        }
        if (this.isFlagHasLayout()) {
            tl += 6;
            tl += 2 * this.getGlyphsCount();
        }
        return tl;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.getCharacterID());
        fs.writeUB1(this.isFlagHasLayout());
        fs.writeUB1(this.isFlagShiftJIS());
        fs.writeUB1(this.isFlagSmallText());
        fs.writeUB1(this.isFlagANSI());
        fs.writeUB1(this.isFlagWideOffsets());
        fs.writeUB1(this.isFlagWideCodes());
        fs.writeUB1(this.isFlagItalic());
        fs.writeUB1(this.isFlagBold());
        fs.flushBuffer();
        fs.writeUI8(this.getLanguageCode());
        byte[] bName = this.getFontName().getBytes("UTF-8");
        fs.writeUI8(bName.length + 1);
        fs.write(bName);
        fs.writeUI8(0);
        fs.writeUI16(this.getGlyphsCount());
        int i = 0;
        while (i < this.getGlyphsCount()) {
            if (this.isFlagWideOffsets()) {
                fs.writeUI32(this.getGlyphOffset(i));
            } else {
                fs.writeUI16((int)this.getGlyphOffset(i));
            }
            ++i;
        }
        if (this.isFlagWideOffsets()) {
            fs.writeUI32(this.codeTableOffset);
        } else {
            fs.writeUI16((int)this.codeTableOffset);
        }
        i = 0;
        while (i < this.getGlyphsCount()) {
            this.getGlyphShape(i).write(fs, 0);
            fs.flushBuffer();
            ++i;
        }
        i = 0;
        while (i < this.getGlyphsCount()) {
            if (this.isFlagWideOffsets()) {
                fs.writeUI16(this.getGlyphCode(i));
            } else {
                fs.writeUI8(this.getGlyphCode(i));
            }
            ++i;
        }
        if (this.isFlagHasLayout()) {
            fs.writeSI16(this.getFontAscent());
            fs.writeSI16(this.getFontDescent());
            fs.writeSI16(this.getFontLeading());
            i = 0;
            while (i < this.getGlyphsCount()) {
                fs.writeSI16(this.getFontAdvance(i));
                ++i;
            }
        }
    }

    public int getFontAscent() {
        return this.fontAscent;
    }

    public void setFontAscent(int fontAscent) {
        this.fontAscent = fontAscent;
    }

    public int getFontDescent() {
        return this.fontDescent;
    }

    public void setFontDescent(int fontDescent) {
        this.fontDescent = fontDescent;
    }

    public int getFontLeading() {
        return this.fontLeading;
    }

    public void setFontLeading(int fontLeading) {
        this.fontLeading = fontLeading;
    }
}

