/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.text;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import org.alov.flashapi.DefinitionTag;
import org.alov.flashapi.FlashOutputStream;

public class DefineEditText
extends DefinitionTag {
    private static final int MIN_MAX_LENGTH = 1;
    private static final int MAX_MAX_LENGTH = 65535;
    private static final int MIN_MARGIN = 1;
    private static final int MAX_MARGIN = 65535;
    private static final int MIN_INDENT = 1;
    private static final int MAX_INDENT = 65535;
    private static final int MIN_LEADING = 1;
    private static final int MAX_LEADING = 65535;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int JUSTIFY = 3;
    private Rectangle bounds;
    private boolean hasText;
    private boolean wordWrap;
    private boolean multiline;
    private boolean password;
    private boolean readOnly;
    private boolean hasTextColor;
    private boolean hasMaxLength;
    private boolean autoSize;
    private boolean hasLayout;
    private boolean noSelect;
    private boolean hasBorder;
    private boolean HTML;
    private boolean useOutlines;
    private Color textColor = Color.black;
    private int maxLength;
    private int align;
    private int leftMargin;
    private int rightMargin;
    private int indent;
    private int leading;
    private String variableName;
    private String initialText;
    private int fontID;
    private int fontHeight;
    private boolean hasFont;

    public DefineEditText() {
        this.bounds = new Rectangle();
    }

    public int getTagCode() {
        return 37;
    }

    public long getTagLength() {
        int tl = 32;
        tl += FlashOutputStream.getRectangleLength(this.getBounds());
        if (this.hasTextColor()) {
            tl += 32;
        }
        if (this.hasMaxLength()) {
            tl += 16;
        }
        if (this.hasLayout()) {
            tl += 72;
        }
        if (this.hasFont()) {
            tl += 32;
        }
        tl += this.getVariableName().length() + 1 << 3;
        if (this.hasText()) {
            tl += this.getInitialText().length() + 1 << 3;
        }
        return tl + 7 >> 3;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.getCharacterID());
        fs.writeRectangle(this.getBounds());
        fs.writeUB1(this.hasText());
        fs.writeUB1(this.isWordWrap());
        fs.writeUB1(this.isMultiline());
        fs.writeUB1(this.isPassword());
        fs.writeUB1(this.isReadOnly());
        fs.writeUB1(this.hasTextColor());
        fs.writeUB1(this.hasMaxLength());
        fs.writeUB1(this.hasFont());
        fs.writeUB1(false);
        fs.writeUB1(this.isAutoSize());
        fs.writeUB1(this.hasLayout());
        fs.writeUB1(this.isNoSelect());
        fs.writeUB1(this.hasBorder());
        fs.writeUB1(false);
        fs.writeUB1(this.isHTML());
        fs.writeUB1(this.isUseOutlines());
        fs.flushBuffer();
        if (this.hasFont()) {
            fs.writeUI16(this.getFontID());
            fs.writeUI16(this.getFontHeight());
        }
        if (this.hasTextColor()) {
            fs.writeRGBA(this.getTextColor());
        }
        if (this.hasMaxLength()) {
            fs.writeUI16(this.getMaxLength());
        }
        if (this.hasLayout()) {
            fs.writeUI8(this.getAlign());
            fs.writeUI16(this.getLeftMargin());
            fs.writeUI16(this.getRightMargin());
            fs.writeUI16(this.getIndent());
            fs.writeUI16(this.getLeading());
        }
        fs.writeString(this.getVariableName());
        if (this.hasText()) {
            fs.writeString(this.getInitialText());
        }
    }

    public void setBounds(Rectangle bounds) {
        this.bounds.setBounds(bounds);
    }

    public Rectangle getBounds() {
        return this.bounds.getBounds();
    }

    public void setHasText(boolean hasText) {
        this.hasText = hasText;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public boolean hasFont() {
        return this.hasFont;
    }

    public void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    public boolean isWordWrap() {
        return this.wordWrap;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setHasTextColor(boolean hasTextColor) {
        this.hasTextColor = hasTextColor;
    }

    public boolean hasTextColor() {
        return this.hasTextColor;
    }

    public void setHasMaxLength(boolean hasMaxLength) {
        this.hasMaxLength = hasMaxLength;
    }

    public boolean hasMaxLength() {
        return this.hasMaxLength;
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public void setHasLayout(boolean hasLayout) {
        this.hasLayout = hasLayout;
    }

    public boolean hasLayout() {
        return this.hasLayout;
    }

    public void setNoSelect(boolean noSelect) {
        this.noSelect = noSelect;
    }

    public boolean isNoSelect() {
        return this.noSelect;
    }

    public void setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public void setHTML(boolean HTML2) {
        this.HTML = HTML2;
    }

    public boolean isHTML() {
        return this.HTML;
    }

    public void setUseOutlines(boolean useOutlines) {
        this.useOutlines = useOutlines;
    }

    public boolean isUseOutlines() {
        return this.useOutlines;
    }

    public void setTextColor(Color textColor) {
        this.setHasTextColor(true);
        if (textColor == null) {
            textColor = Color.black;
        }
        this.textColor = textColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 1) {
            maxLength = 1;
        }
        if (maxLength > 65535) {
            maxLength = 65535;
        }
        this.maxLength = maxLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setAlign(int align) {
        if (align < 0 || align > 3) {
            align = 0;
        }
        this.align = align;
    }

    public int getAlign() {
        return this.align;
    }

    public void setLeftMargin(int leftMargin) {
        if (leftMargin < 1) {
            leftMargin = 1;
        }
        if (leftMargin > 65535) {
            leftMargin = 65535;
        }
        this.leftMargin = leftMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(int rightMargin) {
        if (rightMargin < 1) {
            rightMargin = 1;
        }
        if (rightMargin > 65535) {
            rightMargin = 65535;
        }
        this.rightMargin = rightMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setIndent(int indent) {
        if (indent < 1) {
            indent = 1;
        }
        if (indent > 65535) {
            indent = 65535;
        }
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setLeading(int leading) {
        if (leading < 1) {
            leading = 1;
        }
        if (leading > 65535) {
            leading = 65535;
        }
        this.leading = leading;
    }

    public int getLeading() {
        return this.leading;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableName() {
        String result = this.variableName;
        if (result == null) {
            result = this.variableName = "det" + this.getCharacterID();
        }
        return result;
    }

    public void setInitialText(String initialText) {
        this.setHasText(true);
        this.initialText = initialText;
    }

    public String getInitialText() {
        return this.initialText;
    }

    public void setHasFont(boolean hasFont) {
        this.hasFont = hasFont;
    }

    public int getFontID() {
        return this.fontID;
    }

    public void setFontID(int fontID) {
        this.fontID = fontID;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
    }

    public void mapCharacterID(Map charMapping) {
        super.mapCharacterID(charMapping);
        if (this.hasFont()) {
            this.setFontID(DefinitionTag.getMappedCharID(charMapping, this.getFontID()));
        }
    }
}

