/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.io.IOException;
import java.util.Map;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.shapes.ShapeRecord;
import org.alov.flashapi.shapes.ShapeStyle;

public class StyleChangeRecord
extends ShapeRecord {
    public static final int STATE_NEW_STYLES = 1;
    public static final int STATE_LINE_STYLE = 2;
    public static final int STATE_FILL_STYLE0 = 4;
    public static final int STATE_FILL_STYLE1 = 8;
    public static final int STATE_MOVE_TO = 16;
    private boolean stateNewStyles;
    private boolean stateLineStyle;
    private boolean stateFillStyle1;
    private boolean stateFillStyle0;
    private boolean stateMoveTo;
    private int moveDeltaX;
    private int moveDeltaY;
    private int fillStyle0;
    private int fillStyle1;
    private int lineStyle;
    private ShapeStyle newStyle;
    private int fillBits = -1;
    private int lineBits = -1;

    public StyleChangeRecord() {
        this(0, 0, 0, 0, 0, 0);
    }

    public StyleChangeRecord(int state, int dx, int dy, int fs0, int fs1, int ls) {
        this.setStateNewStyles(FlashOutputStream.checkMask(state, 1));
        this.setStateFillStyle0(FlashOutputStream.checkMask(state, 4));
        this.setStateFillStyle1(FlashOutputStream.checkMask(state, 8));
        this.setStateLineStyle(FlashOutputStream.checkMask(state, 2));
        this.setStateMove(FlashOutputStream.checkMask(state, 16));
        if (this.hasMove()) {
            this.setMoveDeltaX(dx);
            this.setMoveDeltaY(dy);
        }
        if (this.hasFillStyle0()) {
            this.setFillStyle0(fs0);
        }
        if (this.hasFillStyle1()) {
            this.setFillStyle1(fs1);
        }
        if (this.hasLineStyle()) {
            this.setLineStyle(ls);
        }
    }

    public boolean hasNewStyles() {
        return this.stateNewStyles;
    }

    public boolean hasLineStyle() {
        return this.stateLineStyle;
    }

    public boolean hasFillStyle0() {
        return this.stateFillStyle0;
    }

    public boolean hasFillStyle1() {
        return this.stateFillStyle1;
    }

    public boolean hasMove() {
        return this.stateMoveTo;
    }

    public void setStateNewStyles(boolean v) {
        this.stateNewStyles = v;
    }

    public void setStateLineStyle(boolean v) {
        this.stateLineStyle = v;
    }

    public void setStateFillStyle0(boolean v) {
        this.stateFillStyle0 = v;
    }

    public void setStateFillStyle1(boolean v) {
        this.stateFillStyle1 = v;
    }

    public void setStateMove(boolean v) {
        this.stateMoveTo = v;
    }

    public int getMoveDeltaX() {
        return this.moveDeltaX;
    }

    public int getMoveDeltaY() {
        return this.moveDeltaY;
    }

    public void setMoveDeltaX(int v) {
        this.moveDeltaX = v;
    }

    public void setMoveDeltaY(int v) {
        this.moveDeltaY = v;
    }

    public int getFillStyle0() {
        return this.fillStyle0;
    }

    public int getFillStyle1() {
        return this.fillStyle1;
    }

    public void setFillStyle0(int v) {
        this.fillStyle0 = v;
    }

    public void setFillStyle1(int v) {
        this.fillStyle1 = v;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int v) {
        this.lineStyle = v;
    }

    public void setNewStyle(ShapeStyle newStyle) {
        if (newStyle == null) {
            throw new NullPointerException("Shape Style cannot be null");
        }
        this.newStyle = newStyle;
    }

    public ShapeStyle getNewStyle() {
        return this.newStyle;
    }

    public void setFillBits(int fillBits) {
        this.fillBits = fillBits;
    }

    public void setLineBits(int lineBits) {
        this.lineBits = lineBits;
    }

    public void combineWith(StyleChangeRecord rec) {
        this.setStateNewStyles(this.hasNewStyles() || rec.hasNewStyles());
        this.setStateLineStyle(this.hasLineStyle() || rec.hasLineStyle());
        this.setStateFillStyle1(this.hasFillStyle1() || rec.hasFillStyle1());
        this.setStateFillStyle0(this.hasFillStyle0() || rec.hasFillStyle0());
        this.setStateMove(this.hasMove() || rec.hasMove());
        if (this.hasNewStyles()) {
            this.setNewStyle(rec.getNewStyle());
        }
        if (rec.hasLineStyle()) {
            this.setLineStyle(rec.getLineStyle());
        }
        if (rec.hasFillStyle1()) {
            this.setFillStyle1(rec.getFillStyle1());
        }
        if (rec.hasFillStyle0()) {
            this.setFillStyle0(rec.getFillStyle0());
        }
        if (this.hasMove()) {
            this.setMoveDeltaX(rec.getMoveDeltaX());
            this.setMoveDeltaY(rec.getMoveDeltaY());
        }
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        fs.writeUB1(false);
        fs.writeUB1(this.stateNewStyles);
        fs.writeUB1(this.stateLineStyle);
        fs.writeUB1(this.stateFillStyle1);
        fs.writeUB1(this.stateFillStyle0);
        fs.writeUB1(this.stateMoveTo);
        if (this.stateMoveTo) {
            int len = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(this.moveDeltaX, this.moveDeltaY));
            fs.writeBits(len, 5);
            fs.writeBits(this.moveDeltaX, len);
            fs.writeBits(this.moveDeltaY, len);
        }
        if (this.stateFillStyle0) {
            fs.writeBits(this.fillStyle0, this.fillBits);
        }
        if (this.stateFillStyle1) {
            fs.writeBits(this.fillStyle1, this.fillBits);
        }
        if (this.stateLineStyle) {
            fs.writeBits(this.lineStyle, this.lineBits);
        }
        if (this.stateNewStyles) {
            if (this.newStyle == null) {
                throw new NullPointerException("newStyle is null but newStyles state is set");
            }
            this.newStyle.write(fs, options);
        }
    }

    public int getLength(int options) {
        int tl = 6;
        if (this.stateMoveTo) {
            int len = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(this.moveDeltaX, this.moveDeltaY));
            tl += 5 + len * 2;
        }
        if (this.stateFillStyle0) {
            tl += this.fillBits;
        }
        if (this.stateFillStyle1) {
            tl += this.fillBits;
        }
        if (this.stateLineStyle) {
            tl += this.lineBits;
        }
        if (this.stateNewStyles) {
            if (this.newStyle == null) {
                throw new NullPointerException("newStyle is null but newStyles state is set");
            }
            tl += this.newStyle.getLength(options);
        }
        return tl;
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof StyleChangeRecord;
        if (result) {
            StyleChangeRecord scr = (StyleChangeRecord)obj;
            boolean bl = result = scr.stateFillStyle0 == this.stateFillStyle0 && scr.stateFillStyle1 == this.stateFillStyle1 && scr.stateLineStyle == this.stateLineStyle && scr.stateMoveTo == this.stateMoveTo && scr.stateNewStyles == this.stateNewStyles;
            if (result && this.stateFillStyle0) {
                boolean bl2 = result = scr.fillStyle0 == this.fillStyle0;
            }
            if (result && this.stateFillStyle1) {
                boolean bl3 = result = scr.fillStyle1 == this.fillStyle1;
            }
            if (result && this.stateLineStyle) {
                boolean bl4 = result = scr.lineStyle == this.lineStyle;
            }
            if (result && this.stateMoveTo) {
                boolean bl5 = result = scr.moveDeltaX == this.moveDeltaX && scr.moveDeltaY == this.moveDeltaY;
            }
            if (result && this.stateNewStyles) {
                result = scr.newStyle.equals(this.newStyle);
            }
        }
        return result;
    }

    public boolean isEdgeRecord() {
        return false;
    }

    public void mapFillStyle(Map fillMap) {
        Integer newFS;
        int fs0 = this.getFillStyle0();
        int fs1 = this.getFillStyle1();
        if (this.hasFillStyle0() && fs0 > 0) {
            newFS = (Integer)fillMap.get(new Integer(fs0));
            this.setFillStyle0(newFS);
        }
        if (this.hasFillStyle1() && fs1 > 0) {
            newFS = (Integer)fillMap.get(new Integer(fs1));
            this.setFillStyle1(newFS);
        }
    }

    public void mapLineStyle(Map lineMap) {
        int ls = this.getLineStyle();
        if (this.hasLineStyle() && ls > 0) {
            Integer newLS = (Integer)lineMap.get(new Integer(ls));
            this.setLineStyle(newLS);
        }
    }
}

