/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.io.IOException;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.shapes.ShapeRecord;

public class StraightEdgeRecord
extends ShapeRecord {
    private int deltaX;
    private int deltaY;

    public StraightEdgeRecord() {
        this(0, 0);
    }

    public StraightEdgeRecord(int dx, int dy) {
        this.setDeltaX(dx);
        this.setDeltaY(dy);
    }

    public void setDeltaX(int v) {
        this.deltaX = v;
    }

    public void setDeltaY(int v) {
        this.deltaY = v;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setFillBits(int fillBits) {
    }

    public void setLineBits(int lineBits) {
    }

    private int getNumBits() {
        int numBits = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(this.deltaX, this.deltaY));
        if (numBits < 3) {
            numBits = 3;
        }
        return numBits;
    }

    private boolean isGeneral() {
        return this.deltaX != 0 && this.deltaY != 0;
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        fs.writeBits(3, 2);
        int len = this.getNumBits();
        fs.writeBits(len - 2, 4);
        fs.writeBits(this.isGeneral() ? 1 : 0, 1);
        if (this.isGeneral()) {
            fs.writeBits(this.deltaX, len);
            fs.writeBits(this.deltaY, len);
        } else if (this.deltaX == 0) {
            fs.writeBits(1, 1);
            fs.writeBits(this.deltaY, len);
        } else {
            fs.writeBits(0, 1);
            fs.writeBits(this.deltaX, len);
        }
    }

    public int getLength(int options) {
        int tl = 7;
        int len = this.getNumBits();
        tl = this.isGeneral() ? (tl += len * 2) : (tl += len + 1);
        return tl;
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof StraightEdgeRecord;
        if (result) {
            StraightEdgeRecord ser = (StraightEdgeRecord)obj;
            result = ser.deltaX == this.deltaX && ser.deltaY == this.deltaY;
        }
        return result;
    }

    public boolean isEdgeRecord() {
        return true;
    }
}

