/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.shapes.CurvedEdgeRecord;
import org.alov.flashapi.shapes.EndShapeRecord;
import org.alov.flashapi.shapes.ShapeRecord;
import org.alov.flashapi.shapes.ShapeRecordsArray;
import org.alov.flashapi.shapes.ShapeStyle;
import org.alov.flashapi.shapes.StraightEdgeRecord;
import org.alov.flashapi.shapes.StyleChangeRecord;

public class ShapeWithStyle
implements Serializable {
    private static final boolean DEBUG = false;
    private boolean useStyle;
    private Rectangle bounds;
    private int currentX;
    private int currentY;
    private ShapeStyle style;
    private ShapeRecordsArray shapeRecords;
    private int currentLineStyle;
    private int currentFillStyle0;
    private int currentFillStyle1;

    protected ShapeWithStyle(boolean useStyle) {
        this.useStyle = useStyle;
        this.currentX = 0;
        this.currentY = 0;
        this.style = new ShapeStyle();
        this.shapeRecords = new ShapeRecordsArray();
        this.currentLineStyle = 0;
        this.currentFillStyle0 = 0;
        this.currentFillStyle1 = 0;
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        return new Rectangle(this.bounds);
    }

    public void setBounds(Rectangle v) {
        this.setBounds(v.x, v.y, v.x + v.width, v.y + v.height);
    }

    public void unionBounds(Rectangle v) {
        if (this.bounds == null) {
            this.bounds = new Rectangle(v);
        } else {
            this.bounds.add(v);
        }
    }

    public void unionBounds(Point v) {
        if (this.bounds == null) {
            this.bounds = new Rectangle(v);
        } else {
            this.bounds.add(v);
        }
    }

    public void setBounds(int xmin, int ymin, int xmax, int ymax) {
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        this.bounds.setBounds(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public boolean isEmpty() {
        boolean result = true;
        Iterator iter = this.shapeRecords.iterator();
        while (iter.hasNext()) {
            ShapeRecord item = (ShapeRecord)iter.next();
            if (!item.isEdgeRecord()) continue;
            result = false;
            break;
        }
        return result;
    }

    public ShapeStyle getStyle() {
        return this.style;
    }

    private void addShapeRecord(ShapeRecord rec) {
        boolean addRecord = false;
        if (rec instanceof StraightEdgeRecord) {
            this.setCurrentLocation(this.getCurrentX() + ((StraightEdgeRecord)rec).getDeltaX(), this.getCurrentY() + ((StraightEdgeRecord)rec).getDeltaY());
            addRecord = true;
        } else if (rec instanceof CurvedEdgeRecord) {
            Point control = new Point(this.getCurrentX() + ((CurvedEdgeRecord)rec).getControlDeltaX(), this.getCurrentY() + ((CurvedEdgeRecord)rec).getControlDeltaY());
            Point anchor = new Point(control.x + ((CurvedEdgeRecord)rec).getAnchorDeltaX(), control.y + ((CurvedEdgeRecord)rec).getAnchorDeltaY());
            this.unionBounds(CurvedEdgeRecord.calculateBounds(new Point(this.getCurrentX(), this.getCurrentY()), control, anchor));
            this.setCurrentLocation(anchor.x, anchor.y);
            addRecord = true;
        } else if (rec instanceof StyleChangeRecord) {
            ShapeRecord lastRecord;
            StyleChangeRecord screc = (StyleChangeRecord)rec;
            if (screc.hasLineStyle()) {
                addRecord |= this.getCurrentLineStyle() != screc.getLineStyle();
                this.setCurrentLineStyle(screc.getLineStyle());
            }
            if (screc.hasFillStyle0()) {
                addRecord |= this.getCurrentFillStyle0() != screc.getFillStyle0();
                this.setCurrentFillStyle0(screc.getFillStyle0());
            }
            if (screc.hasFillStyle1()) {
                addRecord |= this.getCurrentFillStyle1() != screc.getFillStyle1();
                this.setCurrentFillStyle1(screc.getFillStyle1());
            }
            if (screc.hasMove() && (screc.getMoveDeltaX() != this.getCurrentX() || screc.getMoveDeltaY() != this.getCurrentY())) {
                addRecord = true;
                this.setCurrentLocation(screc.getMoveDeltaX(), screc.getMoveDeltaY());
            }
            if (!this.shapeRecords.isEmpty() && (lastRecord = (ShapeRecord)this.shapeRecords.lastElement()) instanceof StyleChangeRecord) {
                ((StyleChangeRecord)lastRecord).combineWith(screc);
                addRecord = false;
            }
        } else {
            addRecord = true;
        }
        if (addRecord) {
            this.shapeRecords.add(rec);
        }
    }

    public StyleChangeRecord getLastStyleChange() {
        StyleChangeRecord rec = null;
        Iterator iter = this.shapeRecords.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (!(item instanceof StyleChangeRecord)) continue;
            rec = (StyleChangeRecord)item;
        }
        return rec;
    }

    public void lineTo(int x, int y) {
        this.addShapeRecord(new StraightEdgeRecord(x - this.getCurrentX(), y - this.getCurrentY()));
    }

    public void moveTo(int x, int y) {
        this.changeStyle(16, x, y, 0, 0, 0);
    }

    public void lineTo(boolean relative, int x, int y) {
        if (relative) {
            this.addShapeRecord(new StraightEdgeRecord(x, y));
        } else {
            this.lineTo(x, y);
        }
    }

    public void changeStyle(int state, int x, int y, int fs0, int fs1, int ls) {
        this.addShapeRecord(new StyleChangeRecord(state, x, y, fs0, fs1, ls));
    }

    public void curveTo(int x, int y, int cx, int cy) {
        this.addShapeRecord(new CurvedEdgeRecord(cx - this.currentX, cy - this.currentY, x - cx, y - cy));
    }

    public void curveTo(boolean relative, int x, int y, int cx, int cy) {
        if (relative) {
            this.addShapeRecord(new CurvedEdgeRecord(cx, cy, x, y));
        } else {
            this.curveTo(x, y, cx, cy);
        }
    }

    private void ensureRecClose() {
        if (this.shapeRecords.isEmpty() || !(this.shapeRecords.lastElement() instanceof EndShapeRecord)) {
            this.addShapeRecord(new EndShapeRecord());
        }
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        fs.flushBuffer();
        if (this.useStyle) {
            this.style.write(fs, options);
        }
        this.ensureRecClose();
        this.shapeRecords.setFillBits(this.style.getFillBits());
        this.shapeRecords.setLineBits(this.style.getLineBits());
        this.shapeRecords.write(fs, options);
    }

    public int getLength(int options) {
        this.ensureRecClose();
        int tl = 0;
        if (this.useStyle) {
            tl += this.style.getLength(options);
        }
        this.shapeRecords.setFillBits(this.style.getFillBits());
        this.shapeRecords.setLineBits(this.style.getLineBits());
        return tl += this.shapeRecords.getLength(options);
    }

    public int getCurrentFillStyle0() {
        return this.currentFillStyle0;
    }

    public int getCurrentFillStyle1() {
        return this.currentFillStyle1;
    }

    public int getCurrentLineStyle() {
        return this.currentLineStyle;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    protected void setCurrentLocation(int currentX, int currentY) {
        this.currentX = currentX;
        this.currentY = currentY;
        this.unionBounds(new Point(this.getCurrentX(), this.getCurrentY()));
    }

    protected void setStyle(ShapeStyle style) {
        this.style = style;
    }

    protected ShapeRecordsArray getShapeRecords() {
        return this.shapeRecords;
    }

    protected void setShapeRecords(ShapeRecordsArray shapeRecords) {
        this.shapeRecords.clear();
        this.shapeRecords.addAll(shapeRecords);
    }

    public void setCurrentFillStyle0(int currentFillStyle0) {
        this.currentFillStyle0 = currentFillStyle0;
    }

    public void setCurrentFillStyle1(int currentFillStyle1) {
        this.currentFillStyle1 = currentFillStyle1;
    }

    public void setCurrentLineStyle(int currentLineStyle) {
        this.currentLineStyle = currentLineStyle;
    }

    public boolean equals(Object obj) {
        return obj instanceof ShapeWithStyle ? ((ShapeWithStyle)obj).getStyle().equals(this.getStyle()) && ((ShapeWithStyle)obj).getShapeRecords().equals(this.getShapeRecords()) : false;
    }

    public void add(ShapeWithStyle shape, Map charMapping) {
        Map fillMap = this.getStyle().getFillStyles().combine(shape.getStyle().getFillStyles(), charMapping);
        Map lineMap = this.getStyle().getLineStyles().combine(shape.getStyle().getLineStyles());
        Iterator iter = shape.shapeRecords.iterator();
        while (iter.hasNext()) {
            ShapeRecord item = (ShapeRecord)iter.next();
            if (item instanceof EndShapeRecord) continue;
            if (item instanceof StyleChangeRecord) {
                StyleChangeRecord rec = (StyleChangeRecord)item;
                rec.mapFillStyle(fillMap);
                rec.mapLineStyle(lineMap);
            }
            this.addShapeRecord(item);
        }
    }
}

