/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.io.IOException;
import java.io.Serializable;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.shapes.FillStyleArray;
import org.alov.flashapi.shapes.LineStyleArray;

public class ShapeStyle
implements Serializable {
    private FillStyleArray fillStyles = new FillStyleArray();
    private LineStyleArray lineStyles = new LineStyleArray();
    private int fillBits = -1;
    private int lineBits = -1;

    public int getFillBits() {
        if (this.fillBits < 0) {
            throw new IllegalStateException("Fill bits are not yet set");
        }
        return this.fillBits;
    }

    public int getLineBits() {
        if (this.lineBits < 0) {
            throw new IllegalStateException("Line bits are not yet set");
        }
        return this.lineBits;
    }

    public FillStyleArray getFillStyles() {
        return this.fillStyles;
    }

    public LineStyleArray getLineStyles() {
        return this.lineStyles;
    }

    private void resetBits() {
        this.fillBits = FlashOutputStream.getMinBitsU(this.fillStyles.size());
        this.lineBits = FlashOutputStream.getMinBitsU(this.lineStyles.size());
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        this.fillStyles.write(fs, options);
        this.lineStyles.write(fs, options);
        this.resetBits();
        fs.writeUI8(this.fillBits << 4 | this.lineBits);
    }

    public int getLength(int options) {
        int tl = 8;
        tl += this.fillStyles.getLength(options);
        this.resetBits();
        return tl += this.lineStyles.getLength(options);
    }

    public boolean equals(Object obj) {
        return obj instanceof ShapeStyle ? ((ShapeStyle)obj).getFillStyles().equals(this.getFillStyles()) && ((ShapeStyle)obj).getLineStyles().equals(this.getLineStyles()) : false;
    }
}

