/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import org.alov.flashapi.ArrayItem;
import org.alov.flashapi.FlashOutputStream;

public class LineStyle
implements ArrayItem,
Serializable {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 65535;
    private int width;
    private Color color;

    public LineStyle() {
        this(20, Color.black);
    }

    public LineStyle(int w, Color c) {
        this.setWidth(w);
        this.setColor(c);
    }

    public void setWidth(int v) {
        if (v < 1 || v > 65535) {
            throw new IllegalArgumentException("The Width must be in range from 1 to 65535");
        }
        this.width = v;
    }

    public int getWidth() {
        return this.width;
    }

    public void setColor(Color v) {
        if (v == null) {
            v = Color.black;
        }
        this.color = new Color(v.getRed(), v.getGreen(), v.getBlue(), v.getAlpha());
    }

    public Color getColor() {
        return this.color;
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        fs.writeUI16(this.width);
        if ((options & 1) != 0) {
            fs.writeRGBA(this.color);
        } else {
            fs.writeRGB(this.color);
        }
    }

    public int getLength(int options) {
        int tl = 16;
        tl = (options & 1) != 0 ? (tl += 32) : (tl += 24);
        return tl;
    }

    public boolean equals(Object obj) {
        return obj instanceof LineStyle ? ((LineStyle)obj).color.equals(this.color) && ((LineStyle)obj).width == this.width : false;
    }
}

