/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.awt.Color;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import org.alov.flashapi.ArrayItem;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.Matrix;

public class FillStyle
implements ArrayItem,
Serializable {
    public static final int SOLID = 0;
    public static final int LINEAR_GRADIENT = 16;
    public static final int RADIAL_GRADIENT = 18;
    public static final int REPEATING_BITMAP = 64;
    public static final int CLIPPED_BITMAP = 65;
    public static final int NS_REPEATING_BITMAP = 66;
    public static final int NS_CLIPPED_BITMAP = 67;
    private int type;
    private Color color;
    private int bitmapID;
    private Matrix bitmapMatrix;

    public FillStyle(int type) {
        this.type = type;
        if (type == 16 || type == 18) {
            throw new IllegalArgumentException("Gradient fill isn't supported");
        }
        this.bitmapID = 0;
        this.bitmapMatrix = new Matrix();
        this.color = Color.white;
    }

    public void setColor(Color v) {
        if (v == null) {
            v = Color.black;
        }
        this.color = new Color(v.getRed(), v.getGreen(), v.getBlue(), v.getAlpha());
    }

    public Color getColor() {
        return this.color;
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        fs.writeUI8(this.type);
        switch (this.type) {
            case 0: {
                if ((options & 1) != 0) {
                    fs.writeRGBA(this.color);
                    break;
                }
                fs.writeRGB(this.color);
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                fs.writeUI16(this.getBitmapID());
                this.getBitmapMatrix().write(fs);
                fs.flushBuffer();
                break;
            }
            default: {
                throw new InterruptedIOException("Invalid type");
            }
        }
    }

    public int getLength(int options) {
        int tl = 8;
        switch (this.type) {
            case 0: {
                if ((options & 1) != 0) {
                    tl += 32;
                    break;
                }
                tl += 24;
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                tl += 16;
                tl += this.getBitmapMatrix().getLength() + 7 >> 3 << 3;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type");
            }
        }
        return tl;
    }

    public int getBitmapID() {
        return this.bitmapID;
    }

    public void setBitmapID(int bitmapID) {
        this.bitmapID = bitmapID;
    }

    public Matrix getBitmapMatrix() {
        return this.bitmapMatrix;
    }

    public void setBitmapMatrix(Matrix bitmapMatrix) {
        this.bitmapMatrix = bitmapMatrix == null ? new Matrix() : bitmapMatrix;
    }

    public int getType() {
        return this.type;
    }

    public boolean isBitmapStyle() {
        boolean result;
        switch (this.getType()) {
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof FillStyle) {
            FillStyle fill = (FillStyle)obj;
            boolean bl = result = fill.getType() == this.getType();
            if (result) {
                switch (this.getType()) {
                    case 0: {
                        result = this.getColor().equals(fill.getColor());
                        break;
                    }
                    default: {
                        result = this.getBitmapID() == fill.getBitmapID() && this.getBitmapMatrix().equals(fill.getBitmapMatrix());
                        break;
                    }
                }
            }
        } else {
            result = super.equals(obj);
        }
        return result;
    }
}

