/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.Adler32;
import org.alov.flashapi.DefinitionTag;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.shapes.ShapeWithStyle;

public class DefineShape
extends DefinitionTag {
    private static final boolean DEBUG = false;
    public static final int DEFINE_SHAPE = 1;
    public static final int DEFINE_SHAPE2 = 2;
    public static final int DEFINE_SHAPE3 = 3;
    private int type;
    private ShapeWithStyle shape;

    public DefineShape(int type) {
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException("Invalid DefineShape type");
        }
        this.type = type;
        this.shape = new ShapeWithStyle(true);
    }

    public boolean isEmpty() {
        return this.shape.isEmpty();
    }

    public void setBounds(Rectangle v) {
        this.getShape().setBounds(v);
    }

    public void setBounds(int xmin, int ymin, int xmax, int ymax) {
        this.getShape().setBounds(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public Rectangle getBounds() {
        return this.getShape().getBounds();
    }

    public ShapeWithStyle getShape() {
        return this.shape;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.getCharacterID());
        fs.writeRectangle(this.getShape().getBounds());
        int options = 0;
        options = this.type == 3 ? 1 : 0;
        this.shape.write(fs, options);
    }

    public int getTagCode() {
        switch (this.type) {
            case 1: {
                return 2;
            }
            case 2: {
                return 22;
            }
            case 3: {
                return 32;
            }
        }
        return 2;
    }

    public long getTagLength() {
        int tl = 16;
        tl += FlashOutputStream.getRectangleLength(this.getShape().getBounds());
        int options = 0;
        options = this.type == 3 ? 1 : 0;
        tl = (tl + 7) / 8 * 8;
        return ((tl += this.shape.getLength(options)) + 7) / 8;
    }

    public long getChecksum() {
        Adler32 checksum = new Adler32();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FlashOutputStream stream = new FlashOutputStream(out);
        try {
            int options = 0;
            options = this.type == 3 ? 1 : 0;
            this.shape.write(stream, options);
            stream.flushBuffer();
            stream.flush();
            checksum.update(out.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return checksum.getValue();
    }

    public boolean equals(Object obj) {
        return obj instanceof DefineShape ? ((DefineShape)obj).type == this.type && ((DefineShape)obj).getShape().equals(this.getShape()) : false;
    }

    public boolean add(DefinitionTag tag, Map charMapping) {
        boolean result = tag instanceof DefineShape;
        if (result) {
            this.getShape().add(((DefineShape)tag).getShape(), charMapping);
        }
        return result;
    }
}

