/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.shapes;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.shapes.ShapeRecord;

public class CurvedEdgeRecord
extends ShapeRecord {
    private int controlDeltaX;
    private int controlDeltaY;
    private int anchorDeltaX;
    private int anchorDeltaY;

    public CurvedEdgeRecord() {
        this(0, 0, 0, 0);
    }

    protected static Point calculateCoord(Point anchor1, Point control, Point anchor2, double theta) {
        return new Point((int)((1.0 - theta) * (1.0 - theta) * (double)anchor1.x + 2.0 * theta * (1.0 - theta) * (double)control.x + theta * theta * (double)anchor2.x), (int)((1.0 - theta) * (1.0 - theta) * (double)anchor1.y + 2.0 * theta * (1.0 - theta) * (double)control.y + theta * theta * (double)anchor2.y));
    }

    public static Rectangle calculateBounds(Point anchor1, Point control, Point anchor2) {
        Rectangle result = new Rectangle(anchor1);
        result.add(anchor2);
        double theta = 0.5;
        double denom = 2 * control.x - anchor1.x - anchor2.x;
        if (denom != 0.0) {
            theta = (double)(control.x - anchor1.x) / denom;
            theta = Math.min(1.0, Math.max(theta, 0.0));
            result.add(CurvedEdgeRecord.calculateCoord(anchor1, control, anchor2, theta));
        }
        theta = 0.5;
        denom = 2 * control.y - anchor1.y - anchor2.y;
        if (denom != 0.0) {
            theta = (double)(control.y - anchor1.y) / denom;
            theta = Math.min(1.0, Math.max(theta, 0.0));
            result.add(CurvedEdgeRecord.calculateCoord(anchor1, control, anchor2, theta));
        }
        return result;
    }

    public CurvedEdgeRecord(int cdx, int cdy, int adx, int ady) {
        this.setControlDeltaX(cdx);
        this.setControlDeltaY(cdy);
        this.setAnchorDeltaX(adx);
        this.setAnchorDeltaY(ady);
    }

    public void setControlDeltaX(int v) {
        this.controlDeltaX = v;
    }

    public void setControlDeltaY(int v) {
        this.controlDeltaY = v;
    }

    public void setAnchorDeltaX(int v) {
        this.anchorDeltaX = v;
    }

    public void setAnchorDeltaY(int v) {
        this.anchorDeltaY = v;
    }

    public int getControlDeltaX() {
        return this.controlDeltaX;
    }

    public int getControlDeltaY() {
        return this.controlDeltaY;
    }

    public int getAnchorDeltaX() {
        return this.anchorDeltaX;
    }

    public int getAnchorDeltaY() {
        return this.anchorDeltaY;
    }

    public void setFillBits(int fillBits) {
    }

    public void setLineBits(int lineBits) {
    }

    private int getNumBits() {
        int len = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(this.controlDeltaX, this.controlDeltaY, this.anchorDeltaX, this.anchorDeltaY));
        if (len < 3) {
            len = 3;
        }
        return len;
    }

    public void write(FlashOutputStream fs, int options) throws IOException {
        fs.writeBits(2, 2);
        int len = this.getNumBits();
        fs.writeBits(len - 2, 4);
        fs.writeBits(this.controlDeltaX, len);
        fs.writeBits(this.controlDeltaY, len);
        fs.writeBits(this.anchorDeltaX, len);
        fs.writeBits(this.anchorDeltaY, len);
    }

    public int getLength(int options) {
        int tl = 6;
        int len = this.getNumBits();
        return tl += len * 4;
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof CurvedEdgeRecord;
        if (result) {
            CurvedEdgeRecord cer = (CurvedEdgeRecord)obj;
            result = cer.anchorDeltaX == this.anchorDeltaX && cer.anchorDeltaY == this.anchorDeltaY && cer.controlDeltaX == this.controlDeltaX && cer.controlDeltaY == this.controlDeltaY;
        }
        return result;
    }

    public boolean isEdgeRecord() {
        return true;
    }
}

