/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.bitmaps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import org.alov.flashapi.bitmaps.DefineBitsLossless;

public class DefineBitsLossless2
extends DefineBitsLossless {
    protected static final boolean USE_ALPHA = true;
    public static final int BF_8BIT = 3;
    public static final int BF_32BIT = 5;

    public static DefineBitsLossless2 createFromImage(BufferedImage image) {
        return DefineBitsLossless2.createFromImage(image, 0, 0, image.getWidth(), image.getHeight(), null, null);
    }

    public static DefineBitsLossless2 createFromImage(Image image, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        byte[] bytebuf;
        DefineBitsLossless2 result = new DefineBitsLossless2();
        result.setBitmapFormat(5);
        int width = sx2 - sx1;
        int height = sy2 - sy1;
        result.setBitmapWidth(width);
        result.setBitmapHeight(height);
        BufferedImage buffer = new BufferedImage(width, height, 6);
        Graphics2D g = buffer.createGraphics();
        g.drawImage(image, 0, 0, width, height, sx1, sy1, sx2, sy2, bgcolor, observer);
        g.dispose();
        DataBuffer dbuf = buffer.getData().getDataBuffer();
        if (dbuf.getDataType() == 0) {
            bytebuf = ((DataBufferByte)dbuf).getData();
            int count = width * height * 4;
            int i = 1;
            while (i < count) {
                int n = i;
                bytebuf[n] = (byte)(bytebuf[n] ^ bytebuf[i + 2]);
                int n2 = i + 2;
                bytebuf[n2] = (byte)(bytebuf[n2] ^ bytebuf[i]);
                int n3 = i;
                bytebuf[n3] = (byte)(bytebuf[n3] ^ bytebuf[i + 2]);
                i += 4;
            }
        } else {
            throw new UnsupportedOperationException("Byte buffers are only supported");
        }
        result.setData(null, bytebuf);
        return result;
    }

    public int getTagCode() {
        return 36;
    }
}

