/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.bitmaps;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Adler32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.alov.flashapi.DefinitionTag;
import org.alov.flashapi.FlashOutputStream;

public class DefineBitsLossless
extends DefinitionTag {
    private static final boolean DEBUG = false;
    protected static final boolean USE_ALPHA = false;
    public static final int BF_8BIT = 3;
    public static final int BF_15BIT = 4;
    public static final int BF_24BIT = 5;
    private int bitmapFormat = 5;
    private int bitmapWidth = 0;
    private int bitmapHeight = 0;
    private int colorCount = 0;
    private byte[] bitmapData = new byte[0];
    private long checksum = 0L;

    public int getTagCode() {
        return 20;
    }

    public long getTagLength() {
        int tl = 7 + this.bitmapData.length;
        if (this.bitmapFormat == 3) {
            ++tl;
        }
        return tl;
    }

    public int getBitmapFormat() {
        return this.bitmapFormat;
    }

    public void setBitmapFormat(int bitmapFormat) {
        this.bitmapFormat = bitmapFormat;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public void setBitmapHeight(int bitmapHeight) {
        this.bitmapHeight = bitmapHeight;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int bitmapWidth) {
        this.bitmapWidth = bitmapWidth;
    }

    public int getColorCount() {
        return this.colorCount;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setData(byte[] colorData, byte[] bitmapData) {
        if (bitmapData == null) {
            this.bitmapData = new byte[0];
            return;
        }
        try {
            ByteArrayOutputStream compressed = new ByteArrayOutputStream();
            DeflaterOutputStream compressor = new DeflaterOutputStream((OutputStream)compressed, new Deflater(9, false));
            try {
                if (this.getBitmapFormat() == 3 && colorData != null) {
                    compressor.write(colorData);
                    this.colorCount = colorData.length / 3;
                }
                compressor.write(bitmapData);
                compressor.finish();
                compressor.flush();
                this.bitmapData = compressed.toByteArray();
                Adler32 adler = new Adler32();
                adler.update(this.bitmapData);
                this.checksum = adler.getValue();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                compressor.close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                compressor.close();
                return;
            }
        }
        catch (IOException ex) {
            this.bitmapData = new byte[0];
            return;
        }
    }

    public byte[] getBitmapData() {
        return this.bitmapData;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.getCharacterID());
        fs.writeUI8(this.getBitmapFormat());
        fs.writeUI16(this.getBitmapWidth());
        fs.writeUI16(this.getBitmapHeight());
        if (this.getBitmapFormat() == 3) {
            fs.writeUI8(this.getColorCount() - 1);
        }
        fs.write(this.getBitmapData());
    }

    public long getChecksum() {
        return this.checksum;
    }
}

