/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi.actions;

import java.io.IOException;
import java.io.Serializable;
import org.alov.flashapi.FlashOutputStream;

class PushItem
implements Serializable {
    protected static final int PUSH_TYPE_STRING = 0;
    protected static final int PUSH_TYPE_FLOAT = 1;
    protected static final int PUSH_TYPE_NULL = 2;
    protected static final int PUSH_TYPE_UNDEFINED = 3;
    protected static final int PUSH_TYPE_REGISTER = 4;
    protected static final int PUSH_TYPE_BOOLEAN = 5;
    protected static final int PUSH_TYPE_DOUBLE = 6;
    protected static final int PUSH_TYPE_INTEGER = 7;
    protected static final int PUSH_TYPE_CONST8 = 8;
    protected static final int PUSH_TYPE_CONST16 = 9;
    int type;
    Object value;

    PushItem(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    int getLength() {
        int result = 1;
        switch (this.type) {
            case 0: {
                result += ((String)this.value).length() + 1;
                break;
            }
            case 1: {
                result += 4;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                ++result;
                break;
            }
            case 5: {
                ++result;
                break;
            }
            case 6: {
                result += 8;
                break;
            }
            case 7: {
                result += 4;
                break;
            }
            case 8: {
                ++result;
                break;
            }
            case 9: {
                result += 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type of push item");
            }
        }
        return result;
    }

    void write(FlashOutputStream fs) throws IOException {
        fs.writeUI8(this.type);
        switch (this.type) {
            case 0: {
                fs.writeString((String)this.value);
                break;
            }
            case 1: {
                fs.writeFloat(((Float)this.value).floatValue());
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                fs.writeUI8(((Byte)this.value).intValue());
                break;
            }
            case 5: {
                fs.writeUI8((Boolean)this.value != false ? 1 : 0);
                break;
            }
            case 6: {
                fs.writeDouble((Double)this.value);
                break;
            }
            case 7: {
                fs.writeUI32(((Integer)this.value).longValue());
                break;
            }
            case 8: {
                fs.writeUI8(((Byte)this.value).intValue());
                break;
            }
            case 9: {
                fs.writeUI8((Integer)this.value);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type of push item");
            }
        }
    }
}

