/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alov.flashapi.DefinitionTag;
import org.alov.flashapi.FlashPreprocessor;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.Matrix;
import org.alov.flashapi.PlaceObject;
import org.alov.flashapi.ProgressListener;
import org.alov.flashapi.RemoveObject2;
import org.alov.flashapi.ShowFrame;
import org.alov.flashapi.StaticFrameScript;
import org.alov.flashapi.TagStorage;
import org.alov.flashapi.shapes.DefineShape;
import org.alov.util.IntRangeSet;

public class ShapeGluer
implements FlashPreprocessor {
    private static final boolean DEBUG = false;
    private static final boolean BENCHMARK = false;
    private static final boolean USE_INT_RANGES = true;
    private TagStorage initialStorage;
    private TagStorage resultStorage;
    private transient List progressListeners = new ArrayList(1);

    public ShapeGluer() {
    }

    public ShapeGluer(ProgressListener listener) {
        this();
        this.addProgressListener(listener);
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    protected void statusChanged(String status, boolean progressAvailable) {
        Iterator iter = this.progressListeners.iterator();
        while (iter.hasNext()) {
            ProgressListener item = (ProgressListener)iter.next();
            item.statusChanged(status, progressAvailable);
        }
    }

    protected void progressChanged(int position, int maximum) {
        Iterator iter = this.progressListeners.iterator();
        while (iter.hasNext()) {
            ProgressListener item = (ProgressListener)iter.next();
            item.progressChanged(position, maximum);
        }
    }

    private Map buildCharMapping(Map charMap, List newShapes, Set shapes) {
        this.statusChanged("Shape indexing...", true);
        int progress = 0;
        int maxProgress = charMap.size();
        this.progressChanged(progress, maxProgress);
        HashMap charMapping = new HashMap();
        int extraID = newShapes.size() + 1;
        Iterator iter = charMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry item = iter.next();
            Integer value = shapes.contains(item.getKey()) ? new Integer(newShapes.indexOf(item.getValue()) + 1) : new Integer(extraID++);
            charMapping.put(item.getKey(), value);
            this.progressChanged(++progress, maxProgress);
        }
        return charMapping;
    }

    private Map findUniqueSets(Map shapeMap) {
        this.statusChanged("Exploring movie structure...", true);
        int progress = 0;
        int maxProgress = shapeMap.size();
        this.progressChanged(progress, maxProgress);
        HashMap<Set, Set> uniqueSets = new HashMap<Set, Set>();
        Iterator iter = shapeMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer shapeID = (Integer)entry.getKey();
            Set frameSet = (Set)entry.getValue();
            Set shapeSet = (Set)uniqueSets.get(frameSet);
            if (shapeSet == null) {
                shapeSet = new IntRangeSet();
                uniqueSets.put(frameSet, shapeSet);
            }
            shapeSet.add(shapeID);
            this.progressChanged(++progress, maxProgress);
        }
        return uniqueSets;
    }

    private void combineTag(DefinitionTag container, FlashTag tag, Set idSet, Map charMapping) {
        DefinitionTag defTag2;
        Integer tagID;
        if (tag instanceof DefinitionTag && idSet.contains(tagID = new Integer((defTag2 = (DefinitionTag)tag).getCharacterID()))) {
            container.add(defTag2, charMapping);
            idSet.remove(tagID);
        }
    }

    private void restructureShapes(Map charMap, Map uniqueSets, Map charMapping, List newShapes) {
        TagStorage from = this.getInitialStorage();
        TagStorage result = this.getResultStorage();
        Iterator tagItr = from.iterator();
        while (tagItr.hasNext()) {
            FlashTag tag = (FlashTag)tagItr.next();
            if (!(tag instanceof DefinitionTag) || tag instanceof DefineShape) continue;
            ((DefinitionTag)tag).mapCharacterID(charMapping);
            this.resultStorage.addTag(tag);
        }
        this.statusChanged("Shapes optimization...", true);
        int progress = 0;
        int maxProgress = uniqueSets.size();
        this.progressChanged(progress, maxProgress);
        Iterator shapeItr = uniqueSets.entrySet().iterator();
        while (shapeItr.hasNext()) {
            Map.Entry item = shapeItr.next();
            HashSet idSet = new HashSet((Set)item.getValue());
            DefineShape shape = new DefineShape(3);
            shape.setCharacterID(newShapes.indexOf(item.getKey()) + 1);
            tagItr = from.iterator();
            while (!idSet.isEmpty() && tagItr.hasNext()) {
                FlashTag tag = (FlashTag)tagItr.next();
                this.combineTag(shape, tag, idSet, charMapping);
            }
            result.addTag(shape);
            this.progressChanged(++progress, maxProgress);
        }
    }

    private void processTag(FlashTag tag, Map charMapping) {
        if (!(tag instanceof DefineShape)) {
            if (tag instanceof PlaceObject) {
                PlaceObject place = (PlaceObject)tag;
                Integer charID = new Integer(place.getCharacterID());
                Integer depth = new Integer(place.getDepth());
                Integer newID = (Integer)charMapping.get(charID);
                if (!this.resultStorage.getDepthMap().containsValue(newID)) {
                    place.setCharacterID(newID);
                    this.resultStorage.addTag(tag);
                }
            } else if (tag instanceof RemoveObject2) {
                RemoveObject2 remove = (RemoveObject2)tag;
                Integer depth = new Integer(remove.getDepth());
                if (this.resultStorage.getDepthMap().containsKey(depth)) {
                    this.resultStorage.addTag(tag);
                }
            } else if (!(tag instanceof DefinitionTag)) {
                this.resultStorage.addTag(tag);
            }
        }
    }

    private SortedMap reorderDepth(SortedMap depthMap) {
        int depth = 1;
        TreeMap result = new TreeMap();
        Iterator iter = depthMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry item = iter.next();
            if (result.containsValue(item.getValue())) continue;
            result.put(new Integer(depth++), item.getValue());
        }
        return result;
    }

    private void restructureStorage(Map charMapping) {
        TreeMap<Integer, Integer> depthMap = new TreeMap<Integer, Integer>();
        HashMap<Integer, Matrix> matrixMap = new HashMap<Integer, Matrix>();
        Map resultDepthMap = this.resultStorage.getDepthMap();
        this.statusChanged("Recreating movie...", true);
        int progress = 0;
        int maxProgress = this.getInitialStorage().getTagCount();
        this.progressChanged(progress, maxProgress);
        Iterator tagItr = this.getInitialStorage().iterator();
        while (tagItr.hasNext()) {
            FlashTag tag = (FlashTag)tagItr.next();
            this.progressChanged(++progress, maxProgress);
            if (tag instanceof DefinitionTag) continue;
            if (tag instanceof PlaceObject) {
                PlaceObject place = (PlaceObject)tag;
                Integer charID = new Integer(place.getCharacterID());
                Integer depth = new Integer(place.getDepth());
                Integer newID = (Integer)charMapping.get(charID);
                depthMap.put(depth, newID);
                matrixMap.put(newID, place.getMatrix());
                continue;
            }
            if (tag instanceof RemoveObject2) {
                RemoveObject2 remove = (RemoveObject2)tag;
                Integer depth = new Integer(remove.getDepth());
                depthMap.remove(depth);
                continue;
            }
            if (tag instanceof ShowFrame) {
                SortedMap newDepthMap = this.reorderDepth(depthMap);
                StaticFrameScript script = new StaticFrameScript();
                script.setStorage(this.resultStorage);
                script.setShowMap(newDepthMap);
                script.setMatrixMap(matrixMap);
                HashMap hideMap = new HashMap(resultDepthMap);
                hideMap.keySet().removeAll(newDepthMap.keySet());
                script.setHideMap(hideMap);
                script.execute();
                this.resultStorage.addTag(tag);
                continue;
            }
            this.resultStorage.addTag(tag);
        }
    }

    public TagStorage processStorage(TagStorage storage) {
        this.setInitialStorage(storage);
        HashMap charMap = new HashMap(this.getInitialStorage().getCharacterMap());
        charMap.keySet().retainAll(this.getInitialStorage().getShapeSet());
        Map uniqueSets = this.findUniqueSets(charMap);
        ArrayList newShapes = new ArrayList(uniqueSets.keySet());
        Map charMapping = this.buildCharMapping(this.getInitialStorage().getCharacterMap(), newShapes, this.getInitialStorage().getShapeSet());
        this.restructureShapes(charMap, uniqueSets, charMapping, newShapes);
        this.restructureStorage(charMapping);
        this.setInitialStorage(null);
        return this.getResultStorage();
    }

    private static void printShapeMap(PrintStream out, Map shapeMap) {
        out.println("-----");
        Iterator iter = shapeMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry item = iter.next();
            out.println(item.toString());
        }
        out.println("-----");
    }

    protected TagStorage getInitialStorage() {
        return this.initialStorage;
    }

    protected void setInitialStorage(TagStorage initialStorage) {
        if (initialStorage != null && this.getResultStorage() != null) {
            this.getResultStorage().clean();
            this.setResultStorage(null);
        }
        this.initialStorage = initialStorage;
        if (initialStorage != null) {
            this.setResultStorage(initialStorage.createStorage());
        }
    }

    protected TagStorage getResultStorage() {
        return this.resultStorage;
    }

    protected void setResultStorage(TagStorage resultStorage) {
        this.resultStorage = resultStorage;
    }
}

