/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alov.flashapi.CXForm;
import org.alov.flashapi.FlashPreprocessor;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.PlaceObject2;
import org.alov.flashapi.ShowFrame;
import org.alov.flashapi.TagStorage;

public class ShapeFader
implements FlashPreprocessor {
    private static final boolean DEBUG = true;
    private int smoothness;

    public ShapeFader() {
        this(10);
    }

    public ShapeFader(int smoothness) {
        this.smoothness = smoothness;
    }

    private List buildFrameList(Map charMap, int frameCount) {
        ArrayList result = new ArrayList();
        int index = 1;
        while (index <= frameCount) {
            result.add(new HashSet());
            ++index;
        }
        Iterator charItr = charMap.entrySet().iterator();
        while (charItr.hasNext()) {
            Map.Entry item = charItr.next();
            Integer charId = (Integer)item.getKey();
            Set frameSet = (Set)item.getValue();
            Iterator iter = frameSet.iterator();
            while (iter.hasNext()) {
                Integer frameIndex = (Integer)iter.next();
                Set charSet = (Set)result.get(frameIndex - 1);
                if (charSet == null) continue;
                charSet.add(charId);
            }
        }
        return result;
    }

    private void fadeCharacters(List frameList, TagStorage storage) {
        Map depthMap = storage.getDepthMap();
        int frameIndex = storage.getFrameCount();
        if (frameIndex < frameList.size()) {
            HashSet fadeInSet = new HashSet((Collection)frameList.get(frameIndex));
            fadeInSet.removeAll((Collection)frameList.get(frameIndex - 1));
            HashSet fadeOutSet = new HashSet((Collection)frameList.get(frameIndex - 1));
            fadeOutSet.removeAll((Collection)frameList.get(frameIndex));
            int nextDepth = 0;
            Iterator<Object> iter = depthMap.keySet().iterator();
            while (iter.hasNext()) {
                Integer item = (Integer)iter.next();
                if (item <= nextDepth) continue;
                nextDepth = item;
            }
            ++nextDepth;
            int i = 0;
            while (i < this.getSmoothness()) {
                CXForm colorTransform;
                PlaceObject2 place;
                int depth;
                iter = fadeInSet.iterator();
                while (iter.hasNext()) {
                    Integer charId = (Integer)iter.next();
                    depth = i == 0 ? nextDepth++ : (Integer)depthMap.get(charId);
                    place = new PlaceObject2(depth);
                    place.setPlaceFlagMove(i == 0);
                    place.setPlaceFlagHasColorTransform(true);
                    colorTransform = new CXForm(true);
                    colorTransform.setHasAdd(true);
                    colorTransform.setAddTerms(0, 0, 0, 255 * (i + 1) / this.getSmoothness());
                    place.setCXForm(colorTransform);
                    storage.addTag(place);
                }
                iter = depthMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry item = (Map.Entry)iter.next();
                    if (!fadeOutSet.contains(item.getValue())) continue;
                    depth = (Integer)item.getKey();
                    place = new PlaceObject2(depth);
                    place.setPlaceFlagMove(true);
                    place.setPlaceFlagHasColorTransform(true);
                    colorTransform = new CXForm(true);
                    colorTransform.setHasAdd(true);
                    colorTransform.setAddTerms(0, 0, 0, 255 * (this.getSmoothness() - 1 - i) / this.getSmoothness());
                    place.setCXForm(colorTransform);
                    storage.addTag(place);
                }
                storage.addTag(new ShowFrame());
                ++i;
            }
        }
    }

    public TagStorage processStorage(TagStorage storage) {
        TagStorage result = storage.createStorage();
        ShapeFader.printIterator(System.out, storage.getCharacterMap().entrySet().iterator());
        List frameList = this.buildFrameList(storage.getCharacterMap(), storage.getFrameCount());
        ShapeFader.printIterator(System.out, frameList.iterator());
        int totalFrameCount = frameList.size();
        Iterator tagItr = storage.iterator();
        while (tagItr.hasNext()) {
            FlashTag tag = (FlashTag)tagItr.next();
            result.addTag(tag);
            if (tag.getTagCode() != 1) continue;
            this.fadeCharacters(frameList, result);
        }
        return result;
    }

    private static void printIterator(PrintStream out, Iterator iter) {
        out.println("-----");
        while (iter.hasNext()) {
            Object item = iter.next();
            out.println(item.toString());
        }
        out.println("-----");
    }

    public int getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(int smoothness) {
        this.smoothness = smoothness;
    }
}

