/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.IOException;
import org.alov.flashapi.CXForm;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.Matrix;

public class PlaceObject2
extends FlashTag {
    private int characterID = 1;
    private int depth = 1;
    private Matrix matrix;
    private CXForm cxform;
    private boolean placeFlagHasClipActions;
    private boolean placeFlagHasClipDepth;
    private boolean placeFlagHasName;
    private boolean placeFlagHasRatio;
    private boolean placeFlagHasColorTransform;
    private boolean placeFlagHasMatrix;
    private boolean placeFlagHasCharacter;
    private boolean placeFlagMove;
    private int ratio;
    private String name;
    private int clipDepth;

    public PlaceObject2(int depth) {
        this.setDepth(depth);
    }

    public int getTagCode() {
        return 26;
    }

    public long getTagLength() {
        int tl = 24;
        if (this.isPlaceFlagHasCharacter()) {
            tl += 16;
        }
        if (this.isPlaceFlagHasMatrix()) {
            tl += this.matrix.getLength();
        }
        if (this.isPlaceFlagHasColorTransform()) {
            tl += this.cxform.getLength();
        }
        if (this.isPlaceFlagHasRatio()) {
            tl += 16;
        }
        if (this.isPlaceFlagHasName()) {
            tl += (this.name.length() + 1) * 8;
        }
        if (this.isPlaceFlagHasClipDepth()) {
            tl += 16;
        }
        if (this.isPlaceFlagHasClipActions()) {
            throw new UnsupportedOperationException("Clip actions are not implemented");
        }
        return (tl + 7) / 8;
    }

    public void setCharacterID(int v) {
        if (v < 1 || v > 65535) {
            throw new IllegalArgumentException("Invalid character ID: " + v + ". The value must be in range " + 1 + "..." + 65535);
        }
        this.characterID = v;
    }

    public int getCharacterID() {
        return this.characterID;
    }

    public void setDepth(int v) {
        if (v < 1 || v > 65535) {
            throw new IllegalArgumentException("Invalid depth: " + v + ". The value must be in range " + 1 + "..." + 65535);
        }
        this.depth = v;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setMatrix(Matrix v) {
        if (v == null) {
            throw new IllegalArgumentException("Matrix is null");
        }
        this.matrix = v;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setCXForm(CXForm v) {
        this.cxform = v;
    }

    public CXForm getCXForm() {
        return this.cxform;
    }

    public void setPlaceFlagHasClipActions(boolean placeFlagHasClipActions) {
        this.placeFlagHasClipActions = false;
    }

    public boolean isPlaceFlagHasClipActions() {
        return false;
    }

    public void setPlaceFlagHasClipDepth(boolean placeFlagHasClipDepth) {
        this.placeFlagHasClipDepth = placeFlagHasClipDepth;
    }

    public boolean isPlaceFlagHasClipDepth() {
        return this.placeFlagHasClipDepth;
    }

    public void setPlaceFlagHasName(boolean placeFlagHasName) {
        this.placeFlagHasName = placeFlagHasName;
    }

    public boolean isPlaceFlagHasName() {
        return this.placeFlagHasName && this.name != null;
    }

    public void setPlaceFlagHasRatio(boolean placeFlagHasRatio) {
        this.placeFlagHasRatio = placeFlagHasRatio;
    }

    public boolean isPlaceFlagHasRatio() {
        return this.placeFlagHasRatio;
    }

    public void setPlaceFlagHasColorTransform(boolean placeFlagHasColorTransform) {
        this.placeFlagHasColorTransform = placeFlagHasColorTransform;
    }

    public boolean isPlaceFlagHasColorTransform() {
        return this.placeFlagHasColorTransform && this.cxform != null && this.cxform.useAlpha();
    }

    public void setPlaceFlagHasMatrix(boolean placeFlagHasMatrix) {
        this.placeFlagHasMatrix = placeFlagHasMatrix;
    }

    public boolean isPlaceFlagHasMatrix() {
        return this.placeFlagHasMatrix && this.matrix != null;
    }

    public void setPlaceFlagHasCharacter(boolean placeFlagHasCharacter) {
        this.placeFlagHasCharacter = placeFlagHasCharacter;
    }

    public boolean isPlaceFlagHasCharacter() {
        return this.placeFlagHasCharacter;
    }

    public void setPlaceFlagMove(boolean placeFlagMove) {
        this.placeFlagMove = placeFlagMove;
    }

    public boolean isPlaceFlagMove() {
        return this.placeFlagMove;
    }

    public void setRatio(int ratio) {
        this.ratio = ratio;
    }

    public int getRatio() {
        return this.ratio;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setClipDepth(int clipDepth) {
        this.clipDepth = clipDepth;
    }

    public int getClipDepth() {
        return this.clipDepth;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUB1(this.isPlaceFlagHasClipActions());
        fs.writeUB1(this.isPlaceFlagHasClipDepth());
        fs.writeUB1(this.isPlaceFlagHasName());
        fs.writeUB1(this.isPlaceFlagHasRatio());
        fs.writeUB1(this.isPlaceFlagHasColorTransform());
        fs.writeUB1(this.isPlaceFlagHasMatrix());
        fs.writeUB1(this.isPlaceFlagHasCharacter());
        fs.writeUB1(this.isPlaceFlagMove());
        fs.flushBuffer();
        fs.writeUI16(this.getDepth());
        if (this.isPlaceFlagHasCharacter()) {
            fs.writeUI16(this.getCharacterID());
        }
        if (this.isPlaceFlagHasMatrix()) {
            this.getMatrix().write(fs);
        }
        if (this.isPlaceFlagHasColorTransform()) {
            this.getCXForm().write(fs);
        }
        if (this.isPlaceFlagHasRatio()) {
            fs.writeUI16(this.getRatio());
        }
        if (this.isPlaceFlagHasName()) {
            fs.writeString(this.name);
        }
        if (this.isPlaceFlagHasClipDepth()) {
            fs.writeUI16(this.getClipDepth());
        }
        if (this.isPlaceFlagHasClipActions()) {
            throw new UnsupportedOperationException("Clip actions are not implemented");
        }
        fs.flushBuffer();
    }
}

