/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.IOException;
import org.alov.flashapi.CXForm;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.Matrix;

public class PlaceObject
extends FlashTag {
    private int characterID = 1;
    private int depth = 1;
    private Matrix matrix = new Matrix();
    private CXForm cxform;

    public PlaceObject(int depth) {
        this.setDepth(depth);
    }

    public PlaceObject(int charID, int depth) {
        this(depth);
        this.setCharacterID(charID);
    }

    public void setCharacterID(int v) {
        if (v < 1 || v > 65535) {
            throw new IllegalArgumentException("Invalid character ID: " + v + ". The value must be in range " + 1 + "..." + 65535);
        }
        this.characterID = v;
    }

    public int getCharacterID() {
        return this.characterID;
    }

    public void setDepth(int v) {
        if (v < 1 || v > 65535) {
            throw new IllegalArgumentException("Invalid depth: " + v + ". The value must be in range " + 1 + "..." + 65535);
        }
        this.depth = v;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setMatrix(Matrix v) {
        if (v == null) {
            throw new IllegalArgumentException("Matrix is null");
        }
        this.matrix = v;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setCXForm(CXForm v) {
        this.cxform = v;
    }

    public CXForm getCXForm() {
        return this.cxform;
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.characterID);
        fs.writeUI16(this.depth);
        this.matrix.write(fs);
        if (this.cxform != null) {
            this.cxform.write(fs);
        }
        fs.flushBuffer();
    }

    public int getTagCode() {
        return 4;
    }

    public long getTagLength() {
        int tl = 32 + this.matrix.getLength();
        if (this.cxform != null) {
            tl += this.cxform.getLength();
        }
        return (tl + 7) / 8;
    }
}

