/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.IOException;
import java.io.Serializable;
import org.alov.flashapi.FlashOutputStream;

public class Matrix
implements Serializable {
    private boolean hasScale;
    private boolean hasRotate;
    private double scaleX;
    private double scaleY;
    private double rotateSkew0;
    private double rotateSkew1;
    private int translateX;
    private int translateY;

    public Matrix() {
        this(false, 1.0, 1.0, false, 0.0, 0.0, 0, 0);
    }

    public Matrix(double scaleX, double scaleY) {
        this(true, scaleX, scaleY, false, 0.0, 0.0, 0, 0);
    }

    public Matrix(int translateX, int translateY) {
        this(false, 1.0, 1.0, false, 0.0, 0.0, translateX, translateY);
    }

    public Matrix(boolean hasScale, double scaleX, double scaleY, boolean hasRotate, double rotateSkew0, double rotateSkew1, int translateX, int translateY) {
        this.setHasScale(hasScale);
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
        this.setHasRotate(hasRotate);
        this.setRotateSkew0(rotateSkew0);
        this.setRotateSkew1(rotateSkew1);
        this.setTranslateX(translateX);
        this.setTranslateY(translateY);
    }

    public void setMatrix(double[] matrix) {
        this.setScaleX(matrix[0]);
        this.setScaleY(matrix[3]);
        this.setHasScale(matrix[0] != 1.0 && matrix[3] != 1.0);
        this.setRotateSkew0(matrix[1]);
        this.setRotateSkew1(matrix[2]);
        this.setHasRotate(matrix[1] != 0.0 && matrix[2] != 0.0);
        this.setTranslateX((int)matrix[4]);
        this.setTranslateY((int)matrix[5]);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleX(double scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(double scaleY) {
        this.scaleY = scaleY;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public void setTranslateX(int translateX) {
        this.translateX = translateX;
    }

    public void setTranslateY(int translateY) {
        this.translateY = translateY;
    }

    public double getRotateSkew0() {
        return this.rotateSkew0;
    }

    public double getRotateSkew1() {
        return this.rotateSkew1;
    }

    public void setRotateSkew0(double rotateSkew0) {
        this.rotateSkew0 = rotateSkew0;
    }

    public void setRotateSkew1(double rotateSkew1) {
        this.rotateSkew1 = rotateSkew1;
    }

    public boolean isHasRotate() {
        return this.hasRotate;
    }

    public boolean isHasScale() {
        return this.hasScale;
    }

    public void setHasRotate(boolean hasRotate) {
        this.hasRotate = hasRotate;
    }

    public void setHasScale(boolean hasScale) {
        this.hasScale = hasScale;
    }

    public void write(FlashOutputStream fs) throws IOException {
        int maxTranslate;
        int nBits;
        fs.writeBits(this.hasScale ? 1 : 0, 1);
        if (this.hasScale) {
            int i_scaleX = FlashOutputStream.double2fixed(this.scaleX);
            int i_scaleY = FlashOutputStream.double2fixed(this.scaleY);
            nBits = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(i_scaleX, i_scaleY));
            fs.writeBits(nBits, 5);
            fs.writeBits(i_scaleX, nBits);
            fs.writeBits(i_scaleY, nBits);
        }
        fs.writeBits(this.hasRotate ? 1 : 0, 1);
        if (this.hasRotate) {
            int i_rotateSkew0 = FlashOutputStream.double2fixed(this.rotateSkew0);
            int i_rotateSkew1 = FlashOutputStream.double2fixed(this.rotateSkew1);
            nBits = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(i_rotateSkew0, i_rotateSkew1));
            fs.writeBits(nBits, 5);
            fs.writeBits(i_rotateSkew0, nBits);
            fs.writeBits(i_rotateSkew1, nBits);
        }
        int nBits2 = (maxTranslate = FlashOutputStream.getMax(this.translateX, this.translateY)) == 0 ? 0 : FlashOutputStream.getMinBitsS(maxTranslate);
        fs.writeBits(nBits2, 5);
        if (nBits2 > 0) {
            fs.writeBits(this.translateX, nBits2);
            fs.writeBits(this.translateY, nBits2);
        }
    }

    public int getLength() {
        int maxTranslate;
        int nBits;
        int len = 2;
        if (this.hasScale) {
            int i_scaleX = FlashOutputStream.double2fixed(this.scaleX);
            int i_scaleY = FlashOutputStream.double2fixed(this.scaleY);
            nBits = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(i_scaleX, i_scaleY));
            len += 5;
            len += nBits * 2;
        }
        if (this.hasRotate) {
            int i_rotateSkew0 = FlashOutputStream.double2fixed(this.rotateSkew0);
            int i_rotateSkew1 = FlashOutputStream.double2fixed(this.rotateSkew1);
            nBits = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(i_rotateSkew0, i_rotateSkew1));
            len += 5;
            len += nBits * 2;
        }
        int nBits2 = (maxTranslate = FlashOutputStream.getMax(this.translateX, this.translateY)) == 0 ? 0 : FlashOutputStream.getMinBitsS(maxTranslate);
        len += 5;
        return len += nBits2 * 2;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof Matrix) {
            Matrix matrix = (Matrix)obj;
            boolean bl = result = this.isHasScale() == matrix.isHasScale() && this.isHasRotate() == matrix.isHasRotate();
            if (result && this.isHasScale()) {
                boolean bl2 = result = this.getScaleX() == matrix.getScaleX() && this.getScaleY() == matrix.getScaleY();
            }
            if (result && this.isHasRotate()) {
                boolean bl3 = result = this.getRotateSkew0() == matrix.getRotateSkew0() && this.getRotateSkew1() == matrix.getRotateSkew1();
            }
            if (result) {
                result = this.getTranslateX() == matrix.getTranslateX() && this.getTranslateY() == matrix.getTranslateY();
            }
        } else {
            result = super.equals(obj);
        }
        return result;
    }
}

