/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LineClipper {
    private LineClipper() {
    }

    private static void move(GeneralPath result, Rectangle2D clip, Point2D.Float position) {
        if (clip.contains(position.x, position.y)) {
            result.moveTo(position.x, position.y);
        }
    }

    private static void line(GeneralPath result, Rectangle2D clip, Line2D.Float line) {
        if (clip.intersectsLine(line)) {
            Point2D pos;
            int outcode;
            float x1 = line.x1;
            float y1 = line.y1;
            float x2 = line.x2;
            float y2 = line.y2;
            int i = 0;
            while (i < 2) {
                float y;
                float x;
                outcode = clip.outcode(x1, y1);
                if (outcode == 0) break;
                if ((outcode & 1) != 0) {
                    x = (float)clip.getX();
                    y1 += (x - x1) * (y2 - y1) / (x2 - x1);
                    x1 = x;
                } else if ((outcode & 4) != 0) {
                    x = (float)(clip.getX() + clip.getWidth());
                    y1 += (x - x1) * (y2 - y1) / (x2 - x1);
                    x1 = x;
                } else if ((outcode & 2) != 0) {
                    y = (float)clip.getY();
                    x1 += (y - y1) * (x2 - x1) / (y2 - y1);
                    y1 = y;
                } else if ((outcode & 8) != 0) {
                    y = (float)(clip.getY() + clip.getHeight());
                    x1 += (y - y1) * (x2 - x1) / (y2 - y1);
                    y1 = y;
                }
                ++i;
            }
            if ((pos = result.getCurrentPoint()) == null || pos.getX() != (double)x1 || pos.getY() != (double)y1) {
                result.moveTo(x1, y1);
            }
            int i2 = 0;
            while (i2 < 2) {
                float y;
                float x;
                outcode = clip.outcode(x2, y2);
                if (outcode == 0) break;
                if ((outcode & 1) != 0) {
                    x = (float)clip.getX();
                    y2 = y1 + (x - x1) * (y2 - y1) / (x2 - x1);
                    x2 = x;
                } else if ((outcode & 4) != 0) {
                    x = (float)(clip.getX() + clip.getWidth());
                    y2 = y1 + (x - x1) * (y2 - y1) / (x2 - x1);
                    x2 = x;
                } else if ((outcode & 2) != 0) {
                    y = (float)clip.getY();
                    x2 = x1 + (y - y1) * (x2 - x1) / (y2 - y1);
                    y2 = y;
                } else if ((outcode & 8) != 0) {
                    y = (float)(clip.getY() + clip.getHeight());
                    x2 = x1 + (y - y1) * (x2 - x1) / (y2 - y1);
                    y2 = y;
                }
                ++i2;
            }
            if ((pos = result.getCurrentPoint()).getX() != (double)x2 || pos.getY() != (double)y2) {
                result.lineTo(x2, y2);
            }
        }
    }

    public static Shape clipShape(Shape shape, Rectangle2D clip) {
        GeneralPath result = new GeneralPath();
        float[] coords = new float[6];
        float startX = 0.0f;
        float startY = 0.0f;
        float curX = 0.0f;
        float curY = 0.0f;
        PathIterator path = shape.getPathIterator(null);
        while (!path.isDone()) {
            switch (path.currentSegment(coords)) {
                case 0: {
                    float x = coords[0];
                    float y = coords[1];
                    LineClipper.move(result, clip, new Point2D.Float(x, y));
                    startX = curX = x;
                    startY = curY = y;
                    break;
                }
                case 4: {
                    LineClipper.line(result, clip, new Line2D.Float(curX, curY, startX, startY));
                    curX = startX;
                    curY = startY;
                    break;
                }
                case 1: {
                    float x = coords[0];
                    float y = coords[1];
                    LineClipper.line(result, clip, new Line2D.Float(curX, curY, x, y));
                    curX = x;
                    curY = y;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Line segments are only supported");
                }
            }
            path.next();
        }
        return result;
    }
}

