/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import org.alov.util.LittleEndianOutputStream;

public class FlashOutputStream
extends LittleEndianOutputStream {
    private int startPos = 0;
    private static final double FRACTION = 65536.0;
    private int buffer = 0;
    private int bitCount = 0;
    private static final int[] BITS_LENGTH;

    static {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 3;
        nArray[7] = 3;
        nArray[8] = 4;
        nArray[9] = 4;
        nArray[10] = 4;
        nArray[11] = 4;
        nArray[12] = 4;
        nArray[13] = 4;
        nArray[14] = 4;
        nArray[15] = 4;
        BITS_LENGTH = nArray;
    }

    public static final boolean checkMask(int value, int mask) {
        return (value & mask) != 0;
    }

    public FlashOutputStream(OutputStream out) {
        super(out);
    }

    public static int double2fixed(double value) {
        return (int)(value * 65536.0);
    }

    public static int getMinBitsS(int v) {
        if (v < 0) {
            v = -v;
        }
        return FlashOutputStream.getMinBitsU(v) + 1;
    }

    public static int getMinBitsU(int v) {
        int n = 0;
        if ((v & 0xFFFF0000) != 0) {
            n += 16;
            v >>>= 16;
        }
        if ((v & 0xFFFFFF00) != 0) {
            n += 8;
            v >>>= 8;
        }
        if ((v & 0xFFFFFFF0) != 0) {
            n += 4;
            v >>>= 4;
        }
        return n += BITS_LENGTH[v];
    }

    public static int getMax(int a, int b, int c, int d) {
        if (a < 0) {
            a = -a;
        }
        if (b < 0) {
            b = -b;
        }
        if (c < 0) {
            c = -c;
        }
        if (d < 0) {
            d = -d;
        }
        return a > b ? (a > c ? (a > d ? a : d) : (c > d ? c : d)) : (b > c ? (b > d ? b : d) : (c > d ? c : d));
    }

    public void flushBuffer() throws IOException {
        if (this.bitCount > 0) {
            this.writeUI8(this.buffer << 8 - this.bitCount);
            this.bitCount = 0;
            this.buffer = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    public final void writeBits(int v, int len) throws IOException {
        while (true) {
            v &= (1 << len) - 1;
            int free = 8 - this.bitCount;
            int out = len - free;
            if (out <= 0) {
                this.buffer = this.buffer << len | v;
                this.bitCount += len;
                return;
            }
            int bb = this.buffer << free | v >>> out;
            this.writeByte(bb);
            len = out;
            this.buffer = 0;
            this.bitCount = 0;
        }
    }

    public final void writeSI8(int v) throws IOException {
        this.writeByte(v);
    }

    public final void writeSI16(int v) throws IOException {
        this.writeShort(v);
    }

    public final void writeSI32(int v) throws IOException {
        this.writeInt(v);
    }

    public final void writeUI8(int v) throws IOException {
        this.writeByte(v);
    }

    public final void writeUI16(int v) throws IOException {
        this.writeShort(v);
    }

    public final void writeUI32(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0) & 0xFF);
        out.write((int)(v >>> 8) & 0xFF);
        out.write((int)(v >>> 16) & 0xFF);
        out.write((int)(v >>> 24) & 0xFF);
        this.incCount(4);
    }

    public final void writeFixed(double v) throws IOException {
        this.writeInt(FlashOutputStream.double2fixed(v));
    }

    public static int getMax(int a, int b) {
        if (a < 0) {
            a = -a;
        }
        if (b < 0) {
            b = -b;
        }
        return a >= b ? a : b;
    }

    public final void writeString(String v) throws IOException {
        this.flushBuffer();
        this.writeBytes(v);
        this.writeByte(0);
        this.incCount(v.length() + 1);
    }

    public final void writeRGB(Color v) throws IOException {
        this.flushBuffer();
        this.writeByte(v.getRed());
        this.writeByte(v.getGreen());
        this.writeByte(v.getBlue());
    }

    public final void writeRGBA(Color v) throws IOException {
        this.writeRGB(v);
        this.writeByte(v.getAlpha());
    }

    public final void writeRectangle(Rectangle v) throws IOException {
        int l = FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(v.x, v.y, v.x + v.width, v.y + v.height));
        this.writeBits(l, 5);
        this.writeBits(v.x, l);
        this.writeBits(v.x + v.width, l);
        this.writeBits(v.y, l);
        this.writeBits(v.y + v.height, l);
        this.flushBuffer();
    }

    public final void writeUB1(boolean b) throws IOException {
        this.writeBits(b ? 1 : 0, 1);
    }

    public static final int getRectangleLength(Rectangle v) {
        return 5 + (FlashOutputStream.getMinBitsS(FlashOutputStream.getMax(v.x, v.y, v.x + v.width, v.y + v.height)) << 2) + 7 & 0xFFFFFFF8;
    }

    public final void markStart() {
        this.startPos = this.written;
    }

    public final int getLength() {
        return this.written - this.startPos;
    }
}

