/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alov.flashapi.FlashFile;
import org.alov.flashapi.FlashOptimizer;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.LineClipper;
import org.alov.flashapi.Matrix;
import org.alov.flashapi.PlaceObject;
import org.alov.flashapi.RemoveObject2;
import org.alov.flashapi.ShowFrame;
import org.alov.flashapi.actions.ActionPush;
import org.alov.flashapi.actions.ActionSetVariable;
import org.alov.flashapi.actions.DoAction;
import org.alov.flashapi.bitmaps.DefineBitsLossless2;
import org.alov.flashapi.shapes.DefineShape;
import org.alov.flashapi.shapes.FillStyle;
import org.alov.flashapi.shapes.LineStyle;
import org.alov.flashapi.shapes.ShapeWithStyle;
import org.alov.flashapi.text.DefineEditText;
import org.alov.flashapi.text.DefineFont2;
import org.alov.flashapi.util.FlashFileListener;

public class FlashGraphics
extends Graphics2D
implements FlashFileListener,
FlashOptimizer {
    private static final boolean DEBUG = false;
    private static final boolean FONT_DEBUG = false;
    private static final Color TRANSPARENT_COLOR = null;
    private Color color;
    private Paint paint;
    private Stroke stroke;
    private FontMetrics fontMetrics;
    private Font font;
    private DefineFont2 flashFont;
    private FlashFile file;
    private Rectangle2D fileClip;
    private DefineShape currentShape;
    private AffineTransform transform;
    private boolean splitEnabled;
    private Map shapeMap;
    private Map depthMap;
    private Set frameDepths;
    private List textList;
    private int nextText;
    private Map varMap;
    private Map imageMap;
    private List removeScript;
    private transient int currentFrame;
    private static final float APPROX_THRESHOLD = 0.1f;

    private static Shape createClippedShape(Shape shape, Rectangle2D clip) {
        Shape result = null;
        if (shape != null) {
            if (shape instanceof GeneralPath || shape instanceof Line2D) {
                result = LineClipper.clipShape(shape, clip);
            } else {
                Area shapeArea = new Area(shape);
                if (clip != null) {
                    Area clipArea = new Area(clip);
                    shapeArea.intersect(clipArea);
                }
                result = shapeArea;
            }
        }
        return result;
    }

    public FlashGraphics() {
        this(null, false);
    }

    public FlashGraphics(FlashFile file) {
        this(file, false);
    }

    public FlashGraphics(FlashFile file, boolean splitEnabled) {
        this.setFile(file);
        this.setSplitEnabled(splitEnabled);
        this.transform = new AffineTransform();
        this.transform.scale(20.0, 20.0);
        this.setColor(Color.black);
        this.setStroke(new BasicStroke());
        this.setFont(new Font(null));
        this.shapeMap = new HashMap();
        this.depthMap = new HashMap();
        this.frameDepths = new HashSet();
        this.removeScript = new ArrayList();
        this.imageMap = new HashMap();
        this.currentFrame = 1;
        this.textList = new ArrayList();
        this.nextText = 0;
        this.varMap = new HashMap();
        this.beginShape();
    }

    private FillStyle createFlashFillStyle() {
        FillStyle result = null;
        if (this.paint != null) {
            if (this.paint instanceof Color) {
                result = new FillStyle(0);
                result.setColor((Color)this.paint);
            } else if (this.paint instanceof GradientPaint) {
                result = new FillStyle(0);
                Color color1 = ((GradientPaint)this.paint).getColor1();
                Color color2 = ((GradientPaint)this.paint).getColor2();
                Color middle = new Color((color1.getRed() + color2.getRed()) / 2, (color1.getGreen() + color2.getGreen()) / 2, (color1.getBlue() + color2.getBlue()) / 2, (color1.getAlpha() + color2.getAlpha()) / 2);
                result.setColor(middle);
            } else if (this.paint instanceof TexturePaint) {
                TexturePaint txtp = (TexturePaint)this.paint;
                DefineBitsLossless2 imageBits = DefineBitsLossless2.createFromImage(txtp.getImage());
                Long checksum = new Long(imageBits.getChecksum());
                Integer imageID = (Integer)this.imageMap.get(checksum);
                if (imageID == null) {
                    imageBits.setCharacterID(this.getFile().getNextCharId());
                    this.getFile().addTag(imageBits);
                    imageID = new Integer(imageBits.getCharacterID());
                    this.imageMap.put(checksum, imageID);
                }
                AffineTransform xform = this.getTransform();
                Rectangle2D anchor = txtp.getAnchorRect();
                xform.translate(-0.5, -0.5);
                xform.translate(anchor.getX(), anchor.getY());
                xform.scale(anchor.getWidth() / (double)txtp.getImage().getWidth(), anchor.getHeight() / (double)txtp.getImage().getHeight());
                FillStyle fillStyle = new FillStyle(64);
                fillStyle.setBitmapID(imageID);
                Matrix imageMatrix = fillStyle.getBitmapMatrix();
                double[] matrix = new double[6];
                xform.getMatrix(matrix);
                imageMatrix.setMatrix(matrix);
                result = fillStyle;
            }
        }
        return result;
    }

    private LineStyle createFlashLineStyle() {
        LineStyle result = null;
        if (this.paint != null && this.paint instanceof Color) {
            result = new LineStyle();
            result.setColor((Color)this.paint);
            if (this.getStroke() != null && this.getStroke() instanceof BasicStroke) {
                result.setWidth((int)((BasicStroke)this.getStroke()).getLineWidth() * 20);
            } else {
                result.setWidth(20);
            }
        }
        return result;
    }

    private void ensureDrawStyle(boolean fill, DefineShape shapeDef) {
        if (fill) {
            ShapeWithStyle shape = shapeDef.getShape();
            FillStyle fillStyle = this.createFlashFillStyle();
            int index = 0;
            if (fillStyle != null) {
                index = shape.getStyle().getFillStyles().addFillStyle(fillStyle);
            }
            shape.changeStyle(14, 0, 0, 0, index, 0);
        } else {
            ShapeWithStyle shape = shapeDef.getShape();
            LineStyle lineStyle = this.createFlashLineStyle();
            int index = 0;
            if (lineStyle != null) {
                index = shape.getStyle().getLineStyles().addLineStyle(lineStyle);
            }
            shape.changeStyle(14, 0, 0, 0, 0, index);
        }
    }

    private static Point2D getCubicCurveCoord(CubicCurve2D cubic, float theta) {
        float oneMTheta = 1.0f - theta;
        return new Point2D.Float((float)((double)(oneMTheta * oneMTheta * oneMTheta) * cubic.getX1() + (double)(3.0f * theta * oneMTheta * oneMTheta) * cubic.getCtrlX1() + (double)(3.0f * theta * theta * oneMTheta) * cubic.getCtrlX2() + (double)(theta * theta * theta) * cubic.getX2()), (float)((double)(oneMTheta * oneMTheta * oneMTheta) * cubic.getY1() + (double)(3.0f * theta * oneMTheta * oneMTheta) * cubic.getCtrlY1() + (double)(3.0f * theta * theta * oneMTheta) * cubic.getCtrlY2() + (double)(theta * theta * theta) * cubic.getY2()));
    }

    private static Point2D getQuadCurveCoord(QuadCurve2D quad, float theta) {
        float oneMTheta = 1.0f - theta;
        return new Point2D.Float((float)((double)(oneMTheta * oneMTheta) * quad.getX1() + (double)(2.0f * theta * oneMTheta) * quad.getCtrlX() + (double)(theta * theta) * quad.getX2()), (float)((double)(oneMTheta * oneMTheta) * quad.getY1() + (double)(2.0f * theta * oneMTheta) * quad.getCtrlY() + (double)(theta * theta) * quad.getY2()));
    }

    private static QuadCurve2D cubicToQuad(CubicCurve2D shape) {
        QuadCurve2D.Float result = new QuadCurve2D.Float();
        Point2D midpoint = FlashGraphics.getCubicCurveCoord(shape, 0.5f);
        Point2D.Float ctrl = new Point2D.Float((float)(2.0 * (midpoint.getX() - 0.25 * (shape.getP1().getX() + shape.getP2().getX()))), (float)(2.0 * (midpoint.getY() - 0.25 * (shape.getP1().getY() + shape.getP2().getY()))));
        result.setCurve(shape.getP1(), ctrl, shape.getP2());
        return result;
    }

    private static void divideCubicCurve(CubicCurve2D shape, GeneralPath result) {
        CubicCurve2D left = (CubicCurve2D)shape.clone();
        CubicCurve2D right = (CubicCurve2D)shape.clone();
        shape.subdivide(left, right);
        QuadCurve2D qleft = FlashGraphics.cubicToQuad(left);
        QuadCurve2D qright = FlashGraphics.cubicToQuad(right);
        if (FlashGraphics.getQuadCurveCoord(qleft, 0.5f).distanceSq(FlashGraphics.getCubicCurveCoord(left, 0.5f)) <= (double)0.1f) {
            result.append(qleft, true);
        } else {
            FlashGraphics.divideCubicCurve(left, result);
        }
        if (FlashGraphics.getQuadCurveCoord(qright, 0.5f).distanceSq(FlashGraphics.getCubicCurveCoord(right, 0.5f)) <= (double)0.1f) {
            result.append(qright, true);
        } else {
            FlashGraphics.divideCubicCurve(right, result);
        }
    }

    private static GeneralPath approximateCubicBezier(CubicCurve2D shape) {
        GeneralPath result = new GeneralPath();
        FlashGraphics.divideCubicCurve(shape, result);
        return result;
    }

    private void processShape(Shape s, DefineShape shapeDef) {
        this.processShape(s, this.transform, shapeDef);
    }

    private void processShape(Shape s, AffineTransform transform, DefineShape shapeDef) {
        ShapeWithStyle shape = shapeDef.getShape();
        float[] coords = new float[6];
        float startX = 0.0f;
        float startY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        PathIterator path = s.getPathIterator(transform);
        while (!path.isDone()) {
            int segType = path.currentSegment(coords);
            switch (segType) {
                case 0: {
                    startX = coords[0];
                    startY = coords[1];
                    shape.moveTo((int)coords[0], (int)coords[1]);
                    lastX = startX;
                    lastY = startY;
                    break;
                }
                case 4: {
                    shape.lineTo((int)startX, (int)startY);
                    lastX = startX;
                    lastY = startY;
                    break;
                }
                case 1: {
                    lastX = coords[0];
                    lastY = coords[1];
                    shape.lineTo((int)lastX, (int)lastY);
                    break;
                }
                case 2: {
                    lastX = coords[2];
                    lastY = coords[3];
                    int controlX = (int)coords[0];
                    int controlY = (int)coords[1];
                    shape.curveTo((int)lastX, (int)lastY, controlX, controlY);
                    break;
                }
                case 3: {
                    this.processShape(FlashGraphics.approximateCubicBezier(new CubicCurve2D.Float(lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5])), null, shapeDef);
                    lastX = coords[4];
                    lastY = coords[5];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown segment type");
                }
            }
            path.next();
        }
    }

    public void draw(Shape s) {
        if (this.isSplitEnabled()) {
            this.beginShape();
        }
        this.ensureDrawStyle(false, this.getCurrentShape());
        this.processShape(FlashGraphics.createClippedShape(s, this.fileClip), this.getCurrentShape());
        if (this.isSplitEnabled()) {
            this.endShape();
        }
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        throw new UnsupportedOperationException("Method drawImage(Image, AffineTransform, ImageObserver) is not supported");
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        throw new UnsupportedOperationException("Method drawImage(BufferedImage, BufferedImageOp, int, int) is not supported");
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public Integer getFreeTextID() throws IOException {
        if (this.nextText == this.textList.size()) {
            DefineEditText text = new DefineEditText();
            if (this.flashFont != null) {
                text.setHasFont(true);
                text.setFontID(this.flashFont.getCharacterID());
                text.setFontHeight(this.font.getSize() * 20);
            }
            text.setTextColor(this.getColor());
            text.setInitialText("");
            text.setAutoSize(true);
            text.setHasLayout(false);
            text.setHasBorder(false);
            text.setReadOnly(true);
            text.setNoSelect(true);
            text.setCharacterID(this.getFile().getNextCharId());
            text.setVariableName("det" + this.textList.size());
            this.getFile().addTag(text);
            Integer textID = new Integer(text.getCharacterID());
            this.textList.add(textID);
            this.varMap.put(textID, text.getVariableName());
        }
        return (Integer)this.textList.get(this.nextText++);
    }

    private String getTextVarName(Integer textID) {
        return (String)this.varMap.get(textID);
    }

    private void setTextVariable(String varName, String value) throws IOException {
        DoAction actions = new DoAction();
        ActionPush push = new ActionPush();
        actions.addAction(push);
        push.pushString(varName);
        push.pushString(value);
        actions.addAction(new ActionSetVariable());
        this.getFile().addTag(actions);
    }

    private void placeText(Integer textID, Integer depth, int x, int y) throws IOException {
        PlaceObject placeObject = new PlaceObject(textID, depth);
        Matrix matrix = placeObject.getMatrix();
        matrix.setTranslateX(x);
        matrix.setTranslateY(y);
        this.getFile().addTag(placeObject);
        this.depthMap.put(depth, textID);
        this.frameDepths.add(depth);
    }

    public void drawString(String s, float x, float y) {
        if (!this.isSplitEnabled()) {
            this.endShape();
        }
        this.ensureFontWritten();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        try {
            Integer textID = this.getFreeTextID();
            String varName = this.getTextVarName(textID);
            Integer textDepth = new Integer(this.getFile().getNextDepth());
            this.freeDepth(textDepth);
            this.setTextVariable(varName, s);
            Point2D location = this.transform.transform(new Point2D.Float(x - 2.0f, y - (float)fm.getAscent() - 2.0f), null);
            this.placeText(textID, textDepth, (int)location.getX(), (int)location.getY());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.drawString(iterator, (int)x, (int)y);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public void fill(Shape s) {
        if (this.isSplitEnabled()) {
            this.beginShape();
        }
        this.ensureDrawStyle(true, this.getCurrentShape());
        this.processShape(FlashGraphics.createClippedShape(s, this.fileClip), this.getCurrentShape());
        if (this.isSplitEnabled()) {
            this.endShape();
        }
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape shape = onStroke ? this.getStroke().createStrokedShape(s) : s;
        return shape.intersects(rect);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        if (paint instanceof Color) {
            this.color = (Color)paint;
        }
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    public void setTransform(AffineTransform Tx) {
        if (Tx == null) {
            this.transform.setToIdentity();
        } else {
            this.transform.setTransform(Tx);
        }
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public Paint getPaint() {
        return this.getColor();
    }

    public Composite getComposite() {
        return null;
    }

    public void setBackground(Color color) {
    }

    public Color getBackground() {
        return null;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape s) {
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public void setDepth(int depth) {
        this.file.setNextDepth(depth);
    }

    protected DefineShape getCurrentShape() {
        return this.currentShape;
    }

    private static DefineShape createNewShape() {
        return new DefineShape(3);
    }

    private void beginShape() {
        this.setCurrentShape(FlashGraphics.createNewShape());
    }

    private static Long getShapeChecksum(DefineShape shape) {
        return new Long(shape.getChecksum());
    }

    private boolean isShapeAlreadyWritten(Long checksum) {
        return this.shapeMap.containsKey(checksum);
    }

    private boolean isShapeOnDepth(Integer shapeID, Integer depth) {
        return this.depthMap.containsKey(depth) && this.depthMap.get(depth).equals(shapeID);
    }

    private Integer getShapeID(Long checksum) {
        return (Integer)this.shapeMap.get(checksum);
    }

    private void putShape(DefineShape shape, Long checksum, Integer shapeID) throws IOException {
        shape.setCharacterID(shapeID);
        this.getFile().addTag(shape);
        this.shapeMap.put(checksum, shapeID);
    }

    private void placeShape(Integer shapeID, Integer depth) throws IOException {
        this.getFile().addTag(new PlaceObject(shapeID, depth));
        this.depthMap.put(depth, shapeID);
        this.frameDepths.add(depth);
    }

    private void freeDepth(Integer depth) throws IOException {
        Integer shapeID = (Integer)this.depthMap.get(depth);
        if (shapeID != null) {
            this.getFile().addTag(new RemoveObject2(depth));
            this.depthMap.remove(depth);
            this.frameDepths.remove(depth);
        }
    }

    public void endShape() {
        DefineShape shape = this.getCurrentShape();
        try {
            if (!shape.isEmpty()) {
                Integer shapeID;
                Long checksum = FlashGraphics.getShapeChecksum(shape);
                if (this.isShapeAlreadyWritten(checksum)) {
                    shapeID = this.getShapeID(checksum);
                } else {
                    shapeID = new Integer(this.getFile().getNextCharId());
                    this.putShape(shape, checksum, shapeID);
                }
                Integer shapeDepth = new Integer(this.getFile().getNextDepth());
                if (!this.isShapeOnDepth(shapeID, shapeDepth)) {
                    this.freeDepth(shapeDepth);
                    this.placeShape(shapeID, shapeDepth);
                } else {
                    this.frameDepths.add(shapeDepth);
                }
                if (!this.isSplitEnabled()) {
                    this.beginShape();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFile(FlashFile file) {
        if (this.file != null) {
            this.file.removeListener(this);
            this.file.removeOptimizer(this);
        }
        if (file != null) {
            this.file = file;
            this.file.addListener(this);
            this.file.addOptimizer(this);
            Dimension frameSize = this.file.getSize();
            this.frameSizeChanged(frameSize.width, frameSize.height);
        }
    }

    public FlashFile getFile() {
        return this.file;
    }

    protected void ensureDrawStyle(boolean useFill0, boolean useFill1, boolean useLine, FillStyle imageFill0, FillStyle imageFill1) {
        DefineShape shapeDef = this.getCurrentShape();
        ShapeWithStyle shape = shapeDef.getShape();
        boolean changeFill0 = false;
        boolean changeFill1 = false;
        boolean changeLine = false;
        int currentFS0 = shape.getCurrentFillStyle0();
        int currentFS1 = shape.getCurrentFillStyle1();
        int currentLS = shape.getCurrentLineStyle();
        if (!useFill0) {
            changeFill0 = currentFS0 != 0;
        } else {
            boolean bl = changeFill0 = currentFS0 == 0;
            if (!changeFill0) {
                boolean bl2 = changeFill0 = !((FillStyle)shape.getStyle().getFillStyles().itemAt(currentFS0)).getColor().equals(this.getColor());
            }
        }
        if (!useFill1) {
            changeFill1 = currentFS1 != 0;
        } else {
            boolean bl = changeFill1 = currentFS1 == 0;
            if (!changeFill1) {
                boolean bl3 = changeFill1 = !((FillStyle)shape.getStyle().getFillStyles().itemAt(currentFS1)).getColor().equals(this.getColor());
            }
        }
        if (!useLine) {
            changeLine = currentLS != 0;
        } else {
            boolean bl = changeLine = currentLS == 0;
            if (!changeLine) {
                changeLine = !((LineStyle)shape.getStyle().getLineStyles().itemAt(currentLS)).getColor().equals(this.getColor());
            }
        }
        LineStyle lineStyle = null;
        FillStyle fillStyle0 = null;
        FillStyle fillStyle1 = null;
        int state = 0;
        if (changeFill0) {
            if (useFill0) {
                if (imageFill0 == null) {
                    fillStyle0 = new FillStyle(0);
                    fillStyle0.setColor(this.getColor());
                } else {
                    fillStyle0 = imageFill0;
                }
                currentFS0 = shape.getStyle().getFillStyles().addFillStyle(fillStyle0);
            } else {
                currentFS0 = 0;
            }
            state |= 4;
        }
        if (changeFill1) {
            if (useFill1) {
                if (imageFill1 == null) {
                    fillStyle1 = new FillStyle(0);
                    fillStyle1.setColor(this.getColor());
                } else {
                    fillStyle1 = imageFill1;
                }
                currentFS1 = shape.getStyle().getFillStyles().addFillStyle(fillStyle1);
            } else {
                currentFS1 = 0;
            }
            state |= 8;
        }
        if (changeLine) {
            if (useLine) {
                lineStyle = new LineStyle(20, this.getColor());
                currentLS = shape.getStyle().getLineStyles().addLineStyle(lineStyle);
            } else {
                currentLS = 0;
            }
            state |= 2;
        }
        if (state != 0) {
            shape.changeStyle(state, 0, 0, currentFS0, currentFS1, currentLS);
        }
    }

    public Graphics create() {
        FlashGraphics result = new FlashGraphics(this.getFile());
        result.transform.setTransform(this.transform);
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.fill(shape);
    }

    public void setPaintMode() {
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        int swidth = img.getWidth(observer);
        int sheight = img.getHeight(observer);
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, swidth, sheight, bgcolor, observer);
    }

    public Color getColor() {
        return this.color;
    }

    public void setClip(Shape clip) {
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight);
        this.draw(shape);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float shape = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 0);
        this.draw(shape);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Arc2D.Float shape = new Arc2D.Float(x, y, width, height, startAngle, arcAngle, 2);
        this.fill(shape);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            Polygon shape = new Polygon(xPoints, yPoints, nPoints);
            this.fill(shape);
        }
    }

    public void clipRect(int x, int y, int width, int height) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        boolean result = false;
        if (img == null) return result;
        Paint oldPaint = this.getPaint();
        try {
            int i = 0;
            while (i < 5) {
                int status = Toolkit.getDefaultToolkit().checkImage(img, -1, -1, observer);
                if ((status & 0x20) != 0) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    break;
                }
                ++i;
            }
            int width = img.getWidth(observer);
            int height = img.getHeight(observer);
            boolean bl = result = width > 0 && height > 0;
            if (result) {
                int selWidth;
                int swidth = sx2 - sx1;
                int sheight = sy2 - sy1;
                int dwidth = dx2 - dx1;
                int dheight = dy2 - dy1;
                if (swidth * sheight > dwidth * dheight) {
                    selWidth = dwidth;
                    int selHeight = dheight;
                } else {
                    selWidth = swidth;
                    int selHeight = sheight;
                }
                BufferedImage buf = new BufferedImage(selWidth, selWidth, 6);
                Graphics g = buf.getGraphics();
                try {
                    g.drawImage(img, 0, 0, selWidth, selWidth, sx1, sy1, sx2, sy2, bgcolor, observer);
                    Object var24_29 = null;
                    g.dispose();
                    Rectangle destRect = new Rectangle(dx1, dy1, dwidth, dheight);
                    TexturePaint imgPaint = new TexturePaint(buf, destRect);
                    this.setPaint(imgPaint);
                    this.fill(destRect);
                }
                catch (Throwable throwable) {
                    Object var24_28 = null;
                    g.dispose();
                    throw throwable;
                }
            }
            Object var26_32 = null;
            this.setPaint(oldPaint);
            return result;
        }
        catch (Throwable throwable) {
            Object var26_31 = null;
            this.setPaint(oldPaint);
            throw throwable;
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float shape = new Ellipse2D.Float(x, y, width, height);
        this.draw(shape);
    }

    public void setFont(Font font) {
        if (font != null) {
            if (!font.equals(this.font)) {
                this.flashFont = new DefineFont2(font);
                this.flashFont.setFlagWideCodes(true);
                this.flashFont.setFlagBold(font.isBold());
                this.flashFont.setFlagItalic(font.isItalic());
            }
        } else {
            this.flashFont = null;
        }
        this.font = font;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new UnsupportedOperationException("Method drawString(AttributedCharacterIterator iterator, int x, int y) not yet implemented.");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            Polygon shape = new Polygon(xPoints, yPoints, nPoints);
            this.draw(shape);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 1) {
            GeneralPath shape = new GeneralPath();
            shape.moveTo(xPoints[0], yPoints[0]);
            int i = 1;
            while (i < nPoints) {
                shape.lineTo(xPoints[i], yPoints[i]);
                ++i;
            }
            this.draw(shape);
        }
    }

    private void ensureFontWritten() {
        if (this.flashFont != null && this.flashFont.getCharacterID() == 0) {
            this.flashFont.setCharacterID(this.getFile().getNextCharId());
            this.getFile().addTag(this.flashFont);
        }
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Float shape = new Line2D.Float(x1, y1, x2, y2);
        this.draw(shape);
    }

    public void dispose() {
        this.endShape();
    }

    public void setClip(int x, int y, int width, int height) {
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        return this.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    public void clearRect(int x, int y, int width, int height) {
    }

    public void setColor(Color c) {
        this.setPaint(c);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, TRANSPARENT_COLOR, observer);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void setXORMode(Color c1) {
        throw new UnsupportedOperationException("Method setXORMode(Color c1) is not supported.");
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public Shape getClip() {
        throw new UnsupportedOperationException("Method getClip() not yet implemented.");
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, TRANSPARENT_COLOR, observer);
    }

    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float shape = new Ellipse2D.Float(x, y, width, height);
        this.fill(shape);
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, TRANSPARENT_COLOR, observer);
    }

    public void fillRect(int x, int y, int width, int height) {
        Rectangle shape = new Rectangle(x, y, width, height);
        this.fill(shape);
    }

    public void drawRect(int x, int y, int width, int height) {
        Rectangle shape = new Rectangle(x, y, width, height);
        this.draw(shape);
    }

    public void frameSizeChanged(int width, int height) {
        this.fileClip = new Rectangle(-1, -1, width / 20 + 2, height / 20 + 2);
    }

    public void beforeWrite() {
        this.currentFrame = 1;
        this.endShape();
    }

    public boolean isSplitEnabled() {
        return this.splitEnabled;
    }

    public void setSplitEnabled(boolean splitEnabled) {
        this.splitEnabled = splitEnabled;
    }

    public void showingFrame() {
        if (!this.isSplitEnabled()) {
            this.endShape();
        }
        Set visibleDepths = this.depthMap.keySet();
        HashSet depthsToClear = new HashSet(visibleDepths);
        visibleDepths.retainAll(this.frameDepths);
        depthsToClear.removeAll(this.frameDepths);
        HashSet scriptSet = new HashSet(depthsToClear.size());
        scriptSet.addAll(depthsToClear);
        this.removeScript.add(scriptSet);
        this.frameDepths.clear();
        this.setDepth(1);
        this.nextText = 0;
    }

    public List processTag(FlashTag tag) {
        ArrayList<FlashTag> result = new ArrayList<FlashTag>();
        result.add(tag);
        if (tag instanceof ShowFrame && this.currentFrame < this.removeScript.size()) {
            Set depthsToClear = (Set)this.removeScript.get(this.currentFrame);
            Iterator iter = depthsToClear.iterator();
            while (iter.hasNext()) {
                Integer depth = (Integer)iter.next();
                result.add(new RemoveObject2(depth));
            }
            ++this.currentFrame;
        }
        return result;
    }

    protected void setCurrentShape(DefineShape currentShape) {
        this.currentShape = currentShape;
    }
}

