/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.alov.flashapi.EndTag;
import org.alov.flashapi.FileTagStorage;
import org.alov.flashapi.FlashOptimizer;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.FlashPreprocessor;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.MemoryTagStorage;
import org.alov.flashapi.ProgressListener;
import org.alov.flashapi.SetBackgroundColor;
import org.alov.flashapi.ShowFrame;
import org.alov.flashapi.TagStorage;
import org.alov.flashapi.util.FlashFileListener;

public class FlashFile
implements TagStorage {
    static final int DEF_VERSION = 6;
    public static final int TWIP_SIZE = 20;
    public static final int HALF_OF_TWIP = 10;
    private transient List listeners = new ArrayList();
    private transient List optimizers = new ArrayList();
    private transient List progressListeners;
    private transient List preprocessors = new ArrayList();
    private boolean compressed;
    private int version;
    private Dimension size;
    private double delay;
    private boolean dumpActive;
    private int nextCharId;
    private int nextDepth;
    private transient TagStorage storage;

    public FlashFile() {
        this(true);
    }

    public FlashFile(boolean useDump) {
        this(useDump, true);
    }

    public FlashFile(boolean useDump, boolean compressed) {
        this(useDump, compressed, 2000, 2000);
    }

    public FlashFile(boolean useDump, boolean compressed, int width, int height) {
        this.progressListeners = new ArrayList(1);
        this.size = new Dimension();
        this.setCompressed(compressed);
        this.setVersion(6);
        this.setSize(width, height);
        this.setDelay(1.0);
        this.setNextCharId(1);
        this.setNextDepth(1);
        this.setDumpActive(useDump);
    }

    public void addListener(FlashFileListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FlashFileListener listener) {
        this.listeners.remove(listener);
    }

    public void addOptimizer(FlashOptimizer optimizer) {
        this.optimizers.add(optimizer);
    }

    public void removeOptimizer(FlashOptimizer optimizer) {
        this.optimizers.remove(optimizer);
    }

    public void addPreprocessor(FlashPreprocessor preprocessor) {
        this.preprocessors.add(preprocessor);
    }

    public void removePreprocessor(FlashPreprocessor preprocessor) {
        this.preprocessors.remove(preprocessor);
    }

    public void addProgressListener(ProgressListener listener) {
        this.progressListeners.add(listener);
    }

    protected void statusChanged(String status, boolean progressAvailable) {
        Iterator iter = this.progressListeners.iterator();
        while (iter.hasNext()) {
            ProgressListener item = (ProgressListener)iter.next();
            item.statusChanged(status, progressAvailable);
        }
    }

    protected void progressChanged(int position, int maximum) {
        Iterator iter = this.progressListeners.iterator();
        while (iter.hasNext()) {
            ProgressListener item = (ProgressListener)iter.next();
            item.progressChanged(position, maximum);
        }
    }

    public int getNextCharId() {
        return this.nextCharId++;
    }

    public int getLastCharId() {
        return this.nextCharId - 1;
    }

    protected void setNextCharId(int nextCharId) {
        this.nextCharId = nextCharId;
    }

    public int getNextDepth() {
        return this.nextDepth++;
    }

    public int getLastDepth() {
        return this.nextDepth - 1;
    }

    protected void setNextDepth(int nextDepth) {
        this.nextDepth = nextDepth;
    }

    public int getTagCount() {
        return this.storage.getTagCount();
    }

    public void setDumpActive(boolean dumpActive) {
        if (this.dumpActive != dumpActive) {
            this.dumpActive = dumpActive;
            this.storage = this.dumpActive ? new FileTagStorage(this.storage) : new MemoryTagStorage(this.storage);
            System.gc();
        }
    }

    public boolean getDumpActive() {
        return this.dumpActive;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setSize(int width, int height) {
        this.size.setSize(width, height);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            FlashFileListener item = (FlashFileListener)iter.next();
            item.frameSizeChanged(width, height);
        }
    }

    public void setSize(Dimension size) {
        this.setSize(size.width, size.height);
    }

    public Dimension getSize() {
        return this.size.getSize();
    }

    public void setDelay(double fps) {
        this.delay = fps;
    }

    public double getDelay() {
        return this.delay;
    }

    public void addTag(FlashTag tag) {
        if (tag instanceof ShowFrame) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                FlashFileListener item = (FlashFileListener)iter.next();
                item.showingFrame();
            }
        }
        this.storage.addTag(tag);
    }

    public Iterator iterator() {
        return this.storage.iterator();
    }

    public void write(OutputStream out) throws IOException {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            FlashFileListener item = (FlashFileListener)iter.next();
            item.beforeWrite();
        }
        this.optimize();
        this.preprocess();
        this.writeInternal(new FlashOutputStream(out));
    }

    public TagStorage createStorage() {
        return this.storage.createStorage();
    }

    public void preprocess() {
        Iterator iter = this.preprocessors.iterator();
        while (iter.hasNext()) {
            FlashPreprocessor preprocessor = (FlashPreprocessor)iter.next();
            this.setStorage(preprocessor.processStorage(this.storage));
        }
    }

    public void optimize() {
        TagStorage storage = this.createStorage();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            FlashTag tag = (FlashTag)iter.next();
            ArrayList<FlashTag> tags = new ArrayList<FlashTag>();
            tags.add(tag);
            Iterator iterOpt = this.optimizers.iterator();
            while (iterOpt.hasNext()) {
                FlashOptimizer item = (FlashOptimizer)iterOpt.next();
                ArrayList optTags = new ArrayList(tags);
                tags.clear();
                Iterator tagIter = optTags.iterator();
                while (tagIter.hasNext()) {
                    FlashTag subtag = (FlashTag)tagIter.next();
                    tags.addAll(item.processTag(subtag));
                }
            }
            Iterator tagIter = tags.iterator();
            while (tagIter.hasNext()) {
                FlashTag subtag = (FlashTag)tagIter.next();
                storage.addTag(subtag);
            }
        }
        this.setStorage(storage);
    }

    private void writeTags(FlashOutputStream stream) throws IOException {
        Rectangle rect = new Rectangle(this.getSize());
        stream.writeRectangle(rect);
        stream.writeUI16((int)this.delay * 256);
        stream.writeUI16(this.getFrameCount());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            FlashTag tag = (FlashTag)iter.next();
            tag.write(stream);
            stream.flushBuffer();
        }
    }

    private void writeHeader(FlashOutputStream stream, long dataSize) throws IOException {
        if (this.isCompressed()) {
            stream.writeUI8(67);
        } else {
            stream.writeUI8(70);
        }
        stream.writeUI8(87);
        stream.writeUI8(83);
        stream.writeUI8(this.getVersion());
        stream.writeUI32(dataSize + 8L);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeInternal(FlashOutputStream stream) throws IOException {
        this.addTag(new EndTag());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FlashOutputStream buf = new FlashOutputStream(baos);
        try {
            this.writeTags(buf);
            buf.flushBuffer();
            buf.flush();
            this.writeHeader(stream, baos.size());
            if (this.isCompressed()) {
                DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)stream, new Deflater(9, false));
                baos.writeTo(out);
                out.finish();
                out.flush();
            } else {
                FlashOutputStream out = stream;
                baos.writeTo(out);
                ((OutputStream)out).flush();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            buf.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        buf.close();
    }

    public int getFrameCount() {
        return this.storage.getFrameCount();
    }

    public void showFrame() throws IOException {
        this.addTag(new ShowFrame());
    }

    public void setBackground(Color color) throws IOException {
        this.addTag(new SetBackgroundColor(color));
    }

    public int getCharacterCount() {
        return this.storage.getCharacterCount();
    }

    public void clean() {
        this.storage.clean();
        System.gc();
    }

    public Map getCharacterMap() {
        return this.storage.getCharacterMap();
    }

    public Map getDepthMap() {
        return this.storage.getDepthMap();
    }

    public void copyFrom(TagStorage storage) {
        this.storage.copyFrom(storage);
    }

    protected void setStorage(TagStorage storage) {
        this.storage.clean();
        this.storage = storage;
    }

    public Set getShapeSet() {
        return this.storage.getShapeSet();
    }
}

