/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.alov.flashapi.AbstractTagStorage;
import org.alov.flashapi.FlashLog;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.TagStorage;

public class FileTagStorage
extends AbstractTagStorage {
    private static final boolean DEBUG = false;
    private static final String TEMP_PREFIX = "FTS";
    private static final String TEMP_SUFFIX = ".fts";
    private transient File dumpFile;
    private transient OutputStream output;
    private transient ObjectOutput objectOutput;

    public FileTagStorage() {
        this(null);
    }

    public FileTagStorage(TagStorage storage) {
        try {
            this.dumpFile = File.createTempFile(TEMP_PREFIX + String.valueOf(this.hashCode()), TEMP_SUFFIX);
        }
        catch (IOException ex) {
            FlashLog.logMessage("Unable to create the dump file: " + ex.getMessage());
        }
        try {
            this.dumpFile.delete();
        }
        catch (SecurityException ex) {
            FlashLog.logMessage("Unable to delete the dump file: " + ex.getMessage());
        }
        this.outputNeeded();
        this.copyFrom(storage);
    }

    protected boolean outputNeeded() {
        boolean result = true;
        if (this.objectOutput == null) {
            try {
                if (this.dumpFile.exists()) {
                    FlashLog.logMessage("Dump file already exists. You can get wrong results.");
                }
                this.output = new BufferedOutputStream(new FileOutputStream(this.dumpFile.getPath(), true));
                this.objectOutput = new ObjectOutputStream(this.output);
            }
            catch (IOException ex) {
                FlashLog.logMessage("Unable to open the dump file for output: " + ex.getMessage());
                result = false;
            }
        }
        return result;
    }

    protected void releaseOutput() {
        if (this.objectOutput != null) {
            try {
                this.objectOutput.close();
            }
            catch (IOException ex) {
                FlashLog.logMessage("Unable to close output" + ex.getMessage());
            }
            this.objectOutput = null;
            this.output = null;
        }
    }

    public void addTag(FlashTag tag) {
        super.addTag(tag);
        try {
            this.objectOutput.writeObject(tag);
        }
        catch (IOException ex) {
            FlashLog.logMessage("Unable to write tag: " + ex.getMessage());
        }
    }

    public Iterator iterator() {
        return new FileTagStgItr();
    }

    public void deleteDump() {
        this.releaseOutput();
        if (this.dumpFile.exists()) {
            boolean bl = this.dumpFile.delete();
        }
    }

    public void clean() {
        System.gc();
        super.clean();
        this.deleteDump();
    }

    protected void finalize() throws Throwable {
        this.clean();
        super.finalize();
    }

    class FileTagStgItr
    implements Iterator {
        private int count;
        private int position;
        private transient InputStream input;
        private transient ObjectInput objectInput;

        public FileTagStgItr() {
            this.count = FileTagStorage.this.getTagCount();
            this.position = 0;
            try {
                FileTagStorage.this.objectOutput.flush();
            }
            catch (IOException ex) {
                FlashLog.logMessage("Unable to flush output: " + ex.getMessage());
            }
            this.inputNeeded();
        }

        protected boolean inputNeeded() {
            boolean result = true;
            if (FileTagStorage.this.outputNeeded() && this.objectInput == null) {
                try {
                    this.input = new BufferedInputStream(new FileInputStream(FileTagStorage.this.dumpFile));
                    this.objectInput = new ObjectInputStream(this.input);
                }
                catch (IOException ex) {
                    FlashLog.logMessage("Unable to open the dump file for input: " + ex.getMessage());
                    result = false;
                }
            }
            return result;
        }

        protected void releaseInput() {
            if (this.objectInput != null) {
                try {
                    this.objectInput.close();
                }
                catch (IOException ex) {
                    FlashLog.logMessage("Unable to close input: " + ex.getMessage());
                }
                this.objectInput = null;
                this.input = null;
            }
        }

        protected void finalize() throws Throwable {
            this.releaseInput();
            super.finalize();
        }

        public boolean hasNext() {
            boolean result;
            boolean bl = result = this.position < this.count;
            if (!result) {
                this.releaseInput();
            }
            return result;
        }

        public Object next() {
            if (this.hasNext()) {
                Object item;
                try {
                    item = this.objectInput.readObject();
                }
                catch (ClassNotFoundException ex) {
                    FlashLog.logMessage("Unable to read object: " + ex.getMessage());
                    item = null;
                }
                catch (IOException ex) {
                    FlashLog.logMessage("Unable to read object: " + ex.getMessage());
                    item = null;
                }
                ++this.position;
                return item;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

