/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.alov.flashapi.FlashOutputStream;
import org.alov.flashapi.FlashTag;

public class ExportAssets
extends FlashTag {
    private Vector items = new Vector();

    public void addItem(int id, String name) {
        this.items.addElement(new ExportItem(id, name));
    }

    public void write(FlashOutputStream fs) throws IOException {
        super.write(fs);
        fs.writeUI16(this.items.size());
        int c = this.items.size();
        int i = 0;
        while (i < c) {
            ExportItem item = (ExportItem)this.items.elementAt(i);
            fs.writeUI16(item.id);
            fs.writeString(item.name);
            ++i;
        }
    }

    public int getTagCode() {
        return 56;
    }

    public long getTagLength() {
        int tl = 2;
        int c = this.items.size();
        int i = 0;
        while (i < c) {
            ExportItem item = (ExportItem)this.items.elementAt(i);
            tl += 2;
            tl += item.name.length() + 1;
            ++i;
        }
        return tl;
    }

    private class ExportItem
    implements Serializable {
        int id;
        String name;

        ExportItem(int id, String name) {
            if (name == null) {
                throw new NullPointerException("Export item name cannot be null");
            }
            this.id = id;
            this.name = name;
        }
    }
}

