/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.io.IOException;
import java.io.Serializable;
import org.alov.flashapi.FlashOutputStream;

public class CXForm
implements Serializable {
    private boolean useAlpha;
    private boolean hasAdd = false;
    private boolean hasMult = false;
    private int rmt = 256;
    private int gmt = 256;
    private int bmt = 256;
    private int amt = 256;
    private int rat = 0;
    private int gat = 0;
    private int bat = 0;
    private int aat = 0;

    public CXForm(boolean withAlpha) {
        this.useAlpha = withAlpha;
    }

    public void setUseAlpha(boolean v) {
        this.useAlpha = v;
    }

    public boolean useAlpha() {
        return this.useAlpha;
    }

    public void setHasAdd(boolean v) {
        this.hasAdd = v;
    }

    public boolean hasAdd() {
        return this.hasAdd;
    }

    public void setHasMult(boolean v) {
        this.hasMult = v;
    }

    public boolean hasMult() {
        return this.hasMult;
    }

    public void setMultTerms(int r, int g, int b) {
        this.rmt = r;
        this.gmt = g;
        this.bmt = b;
    }

    public void setMultTerms(int r, int g, int b, int a) {
        this.setMultTerms(r, g, b);
        this.amt = a;
    }

    public int[] getMultTerms() {
        int[] b = new int[]{this.rmt, this.gmt, this.bmt, this.amt};
        return b;
    }

    public void setAddTerms(int r, int g, int b) {
        this.rat = r;
        this.gat = g;
        this.bat = b;
    }

    public void setAddTerms(int r, int g, int b, int a) {
        this.setMultTerms(r, g, b);
        this.aat = a;
    }

    public int[] getAddTerms() {
        int[] b = new int[]{this.rat, this.gat, this.bat, this.aat};
        return b;
    }

    public void write(FlashOutputStream fs) throws IOException {
        fs.writeBits(this.hasAdd ? 1 : 0, 1);
        fs.writeBits(this.hasMult ? 1 : 0, 1);
        int val = 0;
        if (this.hasMult) {
            val = FlashOutputStream.getMax(val, this.rmt, this.gmt, this.bmt);
            if (this.useAlpha) {
                val = FlashOutputStream.getMax(val, this.amt);
            }
        }
        if (this.hasAdd) {
            val = FlashOutputStream.getMax(val, this.rat, this.gat, this.bat);
            if (this.useAlpha) {
                val = FlashOutputStream.getMax(val, this.aat);
            }
        }
        val = FlashOutputStream.getMinBitsS(val);
        fs.writeBits(val, 4);
        if (this.hasMult) {
            fs.writeBits(this.rmt, val);
            fs.writeBits(this.gmt, val);
            fs.writeBits(this.bmt, val);
            if (this.useAlpha) {
                fs.writeBits(this.amt, val);
            }
        }
        if (this.hasAdd) {
            fs.writeBits(this.rat, val);
            fs.writeBits(this.gat, val);
            fs.writeBits(this.bat, val);
            if (this.useAlpha) {
                fs.writeBits(this.aat, val);
            }
        }
    }

    public int getLength() {
        int len = 6;
        int val = 0;
        if (this.hasMult) {
            val = FlashOutputStream.getMax(val, this.rmt, this.gmt, this.bmt);
            if (this.useAlpha) {
                val = FlashOutputStream.getMax(val, this.amt);
            }
        }
        if (this.hasAdd) {
            val = FlashOutputStream.getMax(val, this.rat, this.gat, this.bat);
            if (this.useAlpha) {
                val = FlashOutputStream.getMax(val, this.aat);
            }
        }
        val = FlashOutputStream.getMinBitsS(val);
        if (this.hasMult) {
            len += val * 3;
            if (this.useAlpha) {
                len += val;
            }
        }
        if (this.hasAdd) {
            len += val * 3;
            if (this.useAlpha) {
                len += val;
            }
        }
        return len;
    }
}

