/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flashapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.alov.flashapi.DefinitionTag;
import org.alov.flashapi.FlashLog;
import org.alov.flashapi.FlashTag;
import org.alov.flashapi.PlaceObject;
import org.alov.flashapi.PlaceObject2;
import org.alov.flashapi.RemoveObject2;
import org.alov.flashapi.ShowFrame;
import org.alov.flashapi.TagStorage;
import org.alov.flashapi.shapes.DefineShape;
import org.alov.util.IntRangeSet;

public abstract class AbstractTagStorage
implements TagStorage {
    private static final boolean CHAR_MAP_ENABLED = true;
    private static final boolean USE_INT_RANGES = true;
    private Set shapeSet;
    private Map charMap;
    private Map depthMap;
    private int frameCount = 0;
    private Integer frameIndex = new Integer(this.frameCount + 1);
    private int characterCount = 0;
    private int tagCount = 0;

    protected AbstractTagStorage() {
        this.charMap = new HashMap(5000);
        this.shapeSet = new HashSet(5000);
        this.depthMap = new HashMap(5000);
    }

    public void copyFrom(TagStorage storage) {
        if (storage != null) {
            Iterator iter = storage.iterator();
            while (iter.hasNext()) {
                this.addTag((FlashTag)iter.next());
            }
        }
    }

    public Map getCharacterMap() {
        return this.charMap;
    }

    public Set getShapeSet() {
        return this.shapeSet;
    }

    public Map getDepthMap() {
        return this.depthMap;
    }

    public void addTag(FlashTag tag) {
        if (tag instanceof ShowFrame) {
            Iterator iter = this.depthMap.values().iterator();
            while (iter.hasNext()) {
                Integer shapeID = (Integer)iter.next();
                Set frameSet = (Set)this.charMap.get(shapeID);
                if (frameSet == null) continue;
                frameSet.add(this.frameIndex);
            }
            ++this.frameCount;
            this.frameIndex = new Integer(this.frameCount + 1);
        } else if (tag instanceof DefinitionTag) {
            ++this.characterCount;
            DefinitionTag character = (DefinitionTag)tag;
            Integer charID = new Integer(character.getCharacterID());
            this.charMap.put(charID, new IntRangeSet());
            if (tag instanceof DefineShape) {
                this.shapeSet.add(charID);
            }
        } else if (tag instanceof PlaceObject) {
            PlaceObject place = (PlaceObject)tag;
            Integer shapeID = new Integer(place.getCharacterID());
            Integer shapeDepth = new Integer(place.getDepth());
            this.depthMap.put(shapeDepth, shapeID);
        } else if (tag instanceof PlaceObject2) {
            PlaceObject2 place = (PlaceObject2)tag;
            if (place.isPlaceFlagHasCharacter()) {
                Integer shapeID = new Integer(place.getCharacterID());
                Integer shapeDepth = new Integer(place.getDepth());
                this.depthMap.put(shapeDepth, shapeID);
            }
        } else if (tag instanceof RemoveObject2) {
            RemoveObject2 remove = (RemoveObject2)tag;
            Integer shapeDepth = new Integer(remove.getDepth());
            this.depthMap.remove(shapeDepth);
        }
        ++this.tagCount;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public void clean() {
        this.tagCount = 0;
        this.characterCount = 0;
        this.frameCount = 0;
    }

    public TagStorage createStorage() {
        String ERR_MSG = "Unable to create new storage: ";
        TagStorage storage = null;
        try {
            storage = (TagStorage)this.getClass().newInstance();
        }
        catch (InstantiationException ex) {
            FlashLog.logMessage("Unable to create new storage: " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            FlashLog.logMessage("Unable to create new storage: " + ex.getMessage());
        }
        return storage;
    }
}

