/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flash;

import java.awt.Color;
import java.util.Hashtable;
import org.alov.map.Project;
import org.alov.util.Strings;

class MovieParameters {
    private static final String PAR_STATIC = "static";
    private static final String PAR_COUNTER = "counter";
    private static final String PAR_UNITS = "units";
    private static final String PAR_MOTION = "motion";
    private static final String PAR_MPF = "mpf";
    private static final String PAR_SPAN = "span";
    private static final String PAR_STEP = "step";
    private static final String PAR_TITLE = "title";
    private static final boolean DEF_STATIC = false;
    private static final boolean DEF_COUNTER = false;
    private static final int DEF_UNITS = 0;
    private static final int DEF_MOTION = 2;
    private static final int DEF_MPF = 1000;
    private static final double DEF_SPAN = 1.0;
    private static final double DEF_STEP = 1.0;
    boolean useAnimation;
    boolean showCounter;
    boolean showTitle;
    int units;
    int motion;
    int mpf;
    double span;
    double step;
    String title;
    Color titleColor = Color.black;
    Color counterColor = Color.black;

    private MovieParameters() {
    }

    MovieParameters(Hashtable params, Project project) {
        this();
        this.parseParameters(params, project);
    }

    private int getIntDef(Integer val, int def) {
        try {
            return val;
        }
        catch (Exception e) {
            return def;
        }
    }

    private double getDoubleDef(Double val, double def) {
        try {
            return val;
        }
        catch (Exception e) {
            return def;
        }
    }

    static boolean getBooleanValue(String val, boolean def) {
        try {
            if (val == null) {
                return def;
            }
            return (Boolean)Strings.strToObject(val, 1005);
        }
        catch (Exception ex) {
            return def;
        }
    }

    void parseParameters(Hashtable params, Project project) {
        this.useAnimation = !project.isTimeEnabled ? false : this.getIntDef((Integer)params.get(PAR_STATIC), 0) != 1;
        this.units = this.getIntDef((Integer)params.get(PAR_UNITS), 0);
        this.motion = this.getIntDef((Integer)params.get(PAR_MOTION), 2);
        this.mpf = this.getIntDef((Integer)params.get(PAR_MPF), 1000);
        this.span = this.getDoubleDef((Double)params.get(PAR_SPAN), 1.0);
        this.step = this.getDoubleDef((Double)params.get(PAR_STEP), 1.0);
        this.showTitle = false;
        Object s = params.get(PAR_TITLE);
        if (s != null) {
            this.showTitle = true;
            this.title = (String)s;
        }
        if ((s = params.get(PAR_COUNTER)) != null) {
            this.showCounter = MovieParameters.getBooleanValue((String)s, false);
        }
        if (!this.useAnimation) {
            this.showCounter = false;
        }
        if (this.motion < 0 || this.motion > 2) {
            this.motion = 2;
        }
        if (this.mpf < 100) {
            this.mpf = 100;
        }
        if (this.step <= 0.0) {
            this.step = this.span;
        }
    }
}

