/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flash;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.flash.FlashDisplayContext;
import org.alov.flash.MovieParameters;
import org.alov.flashapi.FlashFile;
import org.alov.flashapi.FlashGraphics;
import org.alov.flashapi.ProgressListener;
import org.alov.flashapi.ShapeGluer;
import org.alov.flashapi.StorageSorter;
import org.alov.map.DisplayContext;
import org.alov.map.FlashMaker;
import org.alov.map.FlashMakerListener;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Project;
import org.alov.map.RecordsArray;
import org.alov.map.Renderer;
import org.alov.util.ExDate;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.TimeInterval;

public class GraphicsFlashMaker
implements FlashMaker,
ProgressListener {
    private static final String FLASH_VERSION = "3.0";
    private static final boolean VERBOSE_LOG = true;
    private static final boolean DEBUG_FRAMES = false;
    private static final boolean DEBUG_INTERVALS = false;
    private static final boolean TOTAL_BENCHMARK = false;
    private static final int MAX_ALLOWED_FRAMES = 500;
    private static final String MAX_ALLOWED_FRAMES_MSG = "Specified request is valid but frame count exceeds the maximum allowable frame count.\nThe requested frame count is {0,number,integer}.\nThe maximum allowable frame count is {1,number,integer}";
    private static final int _MICRO_COUNT = 10;
    private Project project;
    private DisplayContext context;
    private List layers;
    private MovieParameters movieParameters;
    private int movieWidth;
    private int movieHeight;
    private FlashFile flashFile;
    private FlashGraphics flashGraphics;
    private Font font;
    private FontMetrics fontMetrics;
    private List titleText;
    private List counterText;
    private List listeners = new ArrayList(1);

    public GraphicsFlashMaker() {
        this.flashFile = new FlashFile();
        this.flashGraphics = new FlashGraphics(this.flashFile, true);
        this.setFont(new Font("Arial", 0, 12));
    }

    public void addListener(FlashMakerListener listener) {
        this.listeners.add(listener);
    }

    public void statusChanged(String status, boolean progressAvailable) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            FlashMakerListener item = (FlashMakerListener)iter.next();
            item.statusChanged(status, progressAvailable);
        }
    }

    public void progressChanged(int position, int maximum) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            FlashMakerListener item = (FlashMakerListener)iter.next();
            item.progressChanged(position, maximum);
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = font == null ? null : this.flashGraphics.getFontMetrics(font);
    }

    public Font getFont() {
        return this.font;
    }

    private TimeInterval getGlobalInterval() {
        TimeInterval globalInterval = null;
        globalInterval = this.context != null && this.context.getTimeInterval() != null ? new TimeInterval(new ExDate(this.context.getTimeInterval().date1().getDays()), new ExDate(this.context.getTimeInterval().date2().getDays())) : (this.project != null && this.project.startDate != null && this.project.endDate != null ? new TimeInterval(new ExDate(this.project.startDate.getDays()), new ExDate(this.project.endDate.getDays())) : new TimeInterval(ExDate.parseString("0"), ExDate.parseString("2006")));
        return globalInterval;
    }

    private TimeInterval[] buildTimeIntervals() {
        TimeInterval[] result = null;
        if (this.movieParameters.useAnimation) {
            TimeInterval globalInterval = this.getGlobalInterval();
            int frameCount = 0;
            frameCount = this.movieParameters.motion == 0 ? (int)(this.movieParameters.span / this.movieParameters.step) : (int)Math.round((globalInterval.getLength(this.movieParameters.units) - this.movieParameters.span) / this.movieParameters.step) + 1;
            result = new TimeInterval[frameCount];
            ExDate date1 = new ExDate(globalInterval.date1().getDays());
            ExDate date2 = new ExDate(globalInterval.date1().getDays());
            try {
                date2.increaseUnits(this.movieParameters.units, this.movieParameters.span);
                for (int i = 0; i < frameCount; ++i) {
                    result[i] = new TimeInterval(new ExDate(date1.getDays()), new ExDate(date2.getDays()));
                    if (this.movieParameters.motion == 0 || this.movieParameters.motion == 2) {
                        date1.increaseUnits(this.movieParameters.units, this.movieParameters.step);
                    }
                    if (this.movieParameters.motion != 1 && this.movieParameters.motion != 2) continue;
                    date2.increaseUnits(this.movieParameters.units, this.movieParameters.step);
                }
            }
            catch (Exception ex) {
                Log.log(2, ex);
            }
        } else {
            result = new TimeInterval[]{this.context.getTimeInterval()};
        }
        return result;
    }

    public void outputMessageBox(String msg, Object[] arguments) {
        String message = MessageFormat.format(msg, arguments);
        this.flashGraphics.setFont(this.getFont());
        this.flashGraphics.setColor(new Color(120, 192, 255, 160));
        int width = this.movieWidth * 3 >> 2;
        int height = MapUtils.textHeight(message, this.flashGraphics, width - 20, true) + 20;
        Rectangle rect = new Rectangle(this.movieWidth, this.movieHeight);
        rect.grow(-(this.movieWidth - width) >> 1, -(this.movieHeight - height) >> 1);
        this.flashGraphics.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 20, 20);
        this.flashGraphics.setColor(Color.red);
        rect.grow(-10, -10);
        MapUtils.drawString(this.flashGraphics, message, rect.x, rect.y, rect.width, rect.height, true);
    }

    private List wrapString(String s, int w) {
        ArrayList<String> splitted = new ArrayList<String>();
        if (this.fontMetrics == null) {
            splitted.add(s);
        } else {
            StringTokenizer tok = new StringTokenizer(s, " \t\n\r");
            String nextString = "";
            while (tok.hasMoreTokens()) {
                int width;
                String token = tok.nextToken();
                String testString = nextString;
                if (nextString.length() > 0) {
                    testString = testString + " ";
                }
                if ((width = this.fontMetrics.stringWidth(testString = testString + token)) < w || nextString.length() <= 0) {
                    nextString = testString;
                    continue;
                }
                splitted.add(nextString);
                nextString = token;
            }
            if (nextString.length() >= 0) {
                splitted.add(nextString);
            }
        }
        return splitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream makeFlash(Project project, DisplayContext context, Vector layers, Hashtable parameters, int width, int height) {
        this.statusChanged("Initialization...", false);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.project = project;
        this.context = context;
        this.layers = layers;
        this.movieParameters = new MovieParameters(parameters, project);
        this.movieWidth = width;
        this.movieHeight = height;
        if (!Strings.isNullOrBlank(this.movieParameters.title)) {
            this.titleText = this.wrapString(this.movieParameters.title, this.movieWidth);
        }
        TimeInterval[] intervals = this.buildTimeIntervals();
        try {
            try {
                this.flashFile.setDumpActive(true);
                this.flashFile.addProgressListener(this);
                this.flashFile.setBackground(project.mapBackground);
                this.flashFile.setSize(this.movieWidth * 20, this.movieHeight * 20);
                this.flashFile.setDelay(1000 / this.movieParameters.mpf);
                if (intervals.length > 500) {
                    this.outputMessageBox(MAX_ALLOWED_FRAMES_MSG, new Object[]{new Integer(intervals.length), new Integer(500)});
                    this.flashGraphics.beforeWrite();
                    this.flashFile.showFrame();
                } else {
                    this.statusChanged("Drawing the movie...", true);
                    this.progressChanged(0, intervals.length);
                    for (int i = 0; i < intervals.length; ++i) {
                        this.drawMapImage(intervals[i], null, null);
                        this.flashFile.showFrame();
                        this.progressChanged(i, intervals.length);
                    }
                }
                this.flashFile.addPreprocessor(new StorageSorter());
                this.flashFile.addPreprocessor(new ShapeGluer(this));
                this.statusChanged("Optimization...", false);
                this.flashFile.write(result);
                this.statusChanged("Finalization...", false);
            }
            finally {
                this.flashFile.clean();
            }
        }
        catch (IOException ex) {
            result = null;
            Log.log(-1, ex);
        }
        ByteArrayInputStream inResult = null;
        if (result != null) {
            inResult = new ByteArrayInputStream(result.toByteArray());
        }
        this.statusChanged("", false);
        return inResult;
    }

    private void drawMapImage(TimeInterval interval, Layer activeLayer, RecordsArray activeRecords) {
        FlashDisplayContext flashContext = new FlashDisplayContext(this.flashGraphics, this.context, interval);
        Vector levels = this.project.renderers;
        int levelCount = levels.size();
        String projectSRS = flashContext.getSRS();
        for (int i = 0; i < levelCount; ++i) {
            List level = (List)levels.get(i);
            int rendCount = level.size();
            for (int j = 0; j < rendCount; ++j) {
                Renderer rend = (Renderer)level.get(j);
                Layer l = rend.getLayer();
                if (this.layers.indexOf(l) < 0) continue;
                if (l.isVisibleNow(flashContext) && rend.isRendererVisible(flashContext)) {
                    l.setTimeInterval(flashContext.getTimeInterval());
                    l.paintRecords2(rend, flashContext, 0);
                    if (l == activeLayer && activeRecords != null) {
                        ((LayerVector)l).paintRecords3(activeRecords, rend, true, flashContext, 0);
                    }
                }
                if (this.flashGraphics.isSplitEnabled()) continue;
                this.flashGraphics.endShape();
            }
        }
        int txtY = 30;
        if (this.movieParameters.showTitle) {
            this.flashGraphics.setFont(this.getFont());
            this.flashGraphics.setColor(this.movieParameters.titleColor);
            Iterator iter = this.titleText.iterator();
            while (iter.hasNext()) {
                String item = (String)iter.next();
                int xpos = 0;
                if (this.fontMetrics != null) {
                    xpos = (this.movieWidth - this.fontMetrics.stringWidth(item)) / 2;
                }
                this.flashGraphics.drawString(item, xpos, txtY);
                if (this.fontMetrics != null) {
                    txtY += this.fontMetrics.getMaxAscent() + 10;
                    continue;
                }
                txtY += 30;
            }
        }
        if (this.movieParameters.showCounter) {
            String sDate = interval.date1().toString(this.movieParameters.units) + " - " + interval.date2().toString(this.movieParameters.units);
            this.flashGraphics.setFont(this.getFont());
            this.flashGraphics.setColor(this.movieParameters.counterColor);
            int xpos = 0;
            if (this.movieParameters.showTitle) {
                txtY = this.fontMetrics != null ? (txtY += this.fontMetrics.getMaxAscent() + 10) : (txtY += 30);
            }
            if (this.fontMetrics != null) {
                xpos = (this.movieWidth - this.fontMetrics.stringWidth(sDate)) / 2;
            }
            this.flashGraphics.drawString(sDate, xpos, txtY);
        }
    }
}

