/*
 * Decompiled with CFR 0.152.
 */
package org.alov.flash;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import org.alov.flashapi.FlashGraphics;
import org.alov.map.DisplayContext;
import org.alov.map.FloatRectangle;
import org.alov.map.Projection;
import org.alov.util.TimeInterval;

public class FlashDisplayContext
implements DisplayContext {
    private FlashGraphics graphics;
    private DisplayContext source;
    private TimeInterval timeInterval;

    protected FlashDisplayContext(FlashGraphics graphics, DisplayContext source, TimeInterval timeInterval) {
        if (graphics == null || source == null) {
            throw new NullPointerException("Both graphics and source context should be assigned");
        }
        this.graphics = graphics;
        this.source = source;
        this.timeInterval = timeInterval;
    }

    public String getName() {
        return this.source.getName();
    }

    public Graphics getDrawToGraphics() {
        return this.graphics;
    }

    public Projection getProjection() {
        return this.source.getProjection();
    }

    public String getThematicMap() {
        return this.source.getThematicMap();
    }

    public FloatRectangle getLastExtent() {
        return this.source.getLastExtent();
    }

    public Vector getUsedSpaces() {
        return this.source.getUsedSpaces();
    }

    public double getDistance(FloatRectangle ext) {
        return this.source.getDistance(ext);
    }

    public Component getComponent() {
        return this.source.getComponent();
    }

    public String getRealPath(String url) {
        return this.source.getRealPath(url);
    }

    public Dimension getSize() {
        return this.source.getSize();
    }

    public TimeInterval getTimeInterval() {
        return this.timeInterval;
    }

    public boolean isStopPaint(int step) {
        return this.source.isStopPaint(step);
    }

    public String getParameter(String key, String def) {
        return this.source.getParameter(key, def);
    }

    public String getSRS() {
        return this.source.getSRS();
    }
}

