/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import org.alov.data.Dbf;
import org.alov.data.ShpHeader;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.Readers;

public class Shp
implements Const {
    public static final int SHP_NULL = 0;
    public static final int SHP_POINT = 1;
    public static final int SHP_POLYLINE = 3;
    public static final int SHP_POLYGON = 5;
    public static final int SHP_MULTIPOINT = 8;
    public static final int SHP_POINTZ = 11;
    public static final int SHP_POLYLINEZ = 13;
    public static final int SHP_POLYGONZ = 15;
    public static final int SHP_MULTIPOINTZ = 18;
    ShpHeader header = null;
    private DataInputStream dataInput = null;

    public Shp(InputStream in, Dbf dbf) throws Exception {
        this(in, dbf, null);
    }

    public Shp(InputStream in, Dbf dbf, LayerVector lyr) throws Exception {
        if (in != null) {
            this.dataInput = new DataInputStream(in);
            this.header = new ShpHeader(this.dataInput, dbf, false, -1);
            if (lyr != null) {
                Shp.setLayerParameters(lyr, this.header);
            }
        } else {
            throw new Exception("Trying to instantiate Shp with InputStream == null");
        }
    }

    public static void loadFromStream(InputStream is, Dbf dbf, LayerVector layer, boolean fixHoles) throws AlovMapException {
        try {
            BufferedInputStream bis = new BufferedInputStream(is, 65536);
            DataInputStream in = new DataInputStream(bis);
            ShpHeader hdr = new ShpHeader(in, dbf, fixHoles, layer.fi_id);
            Shp.setLayerParameters(layer, hdr);
            layer.dataStorage.openDataStorageSave(true);
            int recCounter = 1;
            while (hdr.position < hdr.length && in.available() > 0) {
                Record rec;
                if ((rec = Shp.readNextShape(hdr, recCounter++)) == null) continue;
                layer.addRecord(rec);
            }
        }
        catch (AlovMapException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlovMapException(324, e.getMessage());
        }
        finally {
            Object bis = null;
            Object in = null;
            Object hdr = null;
            layer.dataStorage.closeDataStorageSave();
        }
    }

    private static void setLayerParameters(Layer lyr, ShpHeader header) {
        switch (header.type) {
            case 1: 
            case 8: {
                lyr.dataStorage.setObjectType(1);
                break;
            }
            case 3: {
                lyr.dataStorage.setObjectType(2);
                break;
            }
            case 5: {
                lyr.dataStorage.setObjectType(3);
            }
        }
        lyr.metadata.maxExtent = new FloatRectangle(header.xmin, header.ymin, header.xmax, header.ymax);
    }

    public Record readNextShape(int recID) throws Exception {
        return Shp.readNextShape(this.header, recID);
    }

    private static Record readNextShape(ShpHeader header, int recID) throws Exception {
        if (header.position >= header.length) {
            throw new Exception("Trying to read past end of Shape file");
        }
        Dbf dbf = header.dbf;
        boolean fixHoles = header.fixHoles;
        Record rec = null;
        DataInputStream in = header.dataInput;
        int recNo = in.readInt();
        if (recID != recNo) {
            if (dbf != null) {
                dbf.parseNextDbfRecord(null);
            }
            return null;
        }
        int recLength = in.readInt();
        int shapeType = Readers.readInt(in);
        int fieldCount = dbf != null ? dbf.getNumFields() : 0;
        header.position += recLength + 4;
        if (shapeType != 0) {
            if (!(shapeType == header.type || 1 == header.type && shapeType == 11 || 8 == header.type && shapeType == 18 || 3 == header.type && shapeType == 13 || 5 == header.type && shapeType == 15)) {
                throw new AlovMapException(323, "Shape type doesn't correspond with header type");
            }
            rec = new Record(fieldCount);
            rec.index = header.objectNumber;
            switch (shapeType) {
                case 1: 
                case 11: {
                    Shape shp = rec.newShape(1);
                    shp.xCoords[0] = Readers.readDouble(in);
                    shp.yCoords[0] = Readers.readDouble(in);
                    if (11 != shapeType) break;
                    Readers.readDouble(in);
                    Readers.readDouble(in);
                    break;
                }
                case 8: 
                case 18: {
                    int i;
                    Readers.readRectangleLittle(in);
                    int n = Readers.readInt(in);
                    if (n < 0) {
                        throw new Exception("Shp corrupted. Invalid number of points : " + n);
                    }
                    Shape shp = rec.newShape(n);
                    for (i = 0; i < n; ++i) {
                        shp.xCoords[i] = Readers.readDouble(in);
                        shp.yCoords[i] = Readers.readDouble(in);
                    }
                    if (18 != shapeType) break;
                    Readers.readDouble(in);
                    Readers.readDouble(in);
                    for (i = 0; i < n; ++i) {
                        Readers.readDouble(in);
                    }
                    Readers.readDouble(in);
                    Readers.readDouble(in);
                    for (i = 0; i < n; ++i) {
                        Readers.readDouble(in);
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 13: 
                case 15: {
                    int k;
                    int i;
                    int n;
                    Readers.readRectangleLittle(in);
                    int np = Readers.readInt(in);
                    int pntTotal = n = Readers.readInt(in);
                    int pointCount = n;
                    if (np < 1) {
                        if (dbf != null) {
                            dbf.parseNextDbfRecord(null);
                        }
                        return null;
                    }
                    int[] tempArray = header.tempArray;
                    if (tempArray == null || tempArray.length < np) {
                        header.tempArray = tempArray = new int[np];
                    }
                    int prev = 0;
                    int indf = Readers.readInt(in);
                    for (i = 0; i < np - 1; ++i) {
                        tempArray[i] = Readers.readInt(in) - prev;
                        prev += tempArray[i];
                    }
                    if (np > 0) {
                        tempArray[np - 1] = n - prev;
                    }
                    rec.initShapes(np);
                    boolean isHasHole = false;
                    pntTotal = 0;
                    for (i = 0; i < np; ++i) {
                        int pc = tempArray[i];
                        int n2 = pc = pc < 0 ? 0 : (pc > n ? n : pc);
                        if (i == np - 1 && (n -= pc) > 0) {
                            pc = n;
                        }
                        Shape shp = new Shape();
                        shp.xCoords = new double[pc];
                        shp.yCoords = new double[pc];
                        boolean count = false;
                        for (int k2 = 0; k2 < pc; ++k2) {
                            shp.xCoords[k2] = Readers.readDouble(in);
                            shp.yCoords[k2] = Readers.readDouble(in);
                            ++pntTotal;
                        }
                        rec.setShape(i, shp);
                        isHasHole = fixHoles && (isHasHole || (shapeType == 5 || shapeType == 15) && Shape.isClockWise(shp));
                    }
                    if (isHasHole) {
                        Record.addDoughnutShape(rec, pntTotal);
                    }
                    if (shapeType != 15 && shapeType != 13) break;
                    Readers.readDouble(in);
                    Readers.readDouble(in);
                    for (k = 0; k < pointCount; ++k) {
                        Readers.readDouble(in);
                        Readers.readDouble(in);
                    }
                    Readers.readDouble(in);
                    Readers.readDouble(in);
                    for (k = 0; k < pointCount; ++k) {
                        Readers.readDouble(in);
                        Readers.readDouble(in);
                    }
                    break;
                }
            }
            if (dbf != null) {
                dbf.parseNextDbfRecord(rec);
            }
            ++header.objectNumber;
        } else {
            dbf.parseNextDbfRecord(null);
        }
        switch (shapeType) {
            case 11: {
                shapeType = 1;
                break;
            }
            case 13: {
                shapeType = 3;
                break;
            }
            case 15: {
                shapeType = 5;
                break;
            }
            case 18: {
                shapeType = 8;
            }
        }
        return rec;
    }
}

