/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.alov.data.Csv;
import org.alov.data.Dbf;
import org.alov.data.MifHeader;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.Strings;

public class Mif {
    private static final String REGION = "REGION ";
    private static final String PLINE_MULTIPLE = "PLINE MULTIPLE ";
    private static final String PLINE = "PLINE ";
    private static final String POINT = "POINT ";
    private static final String LINE = "LINE ";
    private static final String EMPTY = "";
    private static final int MIF_POINT = 1;
    private static final int MIF_LINE = 2;
    private static final int MIF_POLYGON = 3;
    private MifHeader header;

    public Mif(InputStream input, Dbf dbf) {
        this.header = new MifHeader(input, null, dbf, -1);
    }

    public Mif(InputStream input, InputStream istreamMid, Dbf dbf) {
        this.header = new MifHeader(input, istreamMid, dbf, -1);
    }

    public int getObjectType() {
        return this.header.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadFromStream(InputStream is, InputStream istreamMid, Dbf dbf, LayerVector layer) {
        MifHeader header = new MifHeader(is, istreamMid, dbf, layer.fi_id);
        if (dbf == null) {
            Csv.resolveCsvFields(header.fieldNames, header.fieldsType, layer);
            for (int i = 0; i < header.fieldsType.length; ++i) {
                FieldDef fd = layer.getFieldDef(i);
                fd.fieldlen = header.fieldLens[i];
                fd.fieldnumdec = header.fieldNumDec[i];
            }
        }
        layer.dataStorage.openDataStorageSave(true);
        try {
            Record rec;
            while ((rec = Mif.readNextObject(header)) != null) {
                if (layer.isObjectType(-1) || layer.isObjectType(header.type)) {
                    layer.addRecord(rec);
                    continue;
                }
                rec = null;
            }
            layer.dataStorage.setObjectType(header.type);
            layer.metadata.maxExtent = layer.getLayerExtent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            layer.dataStorage.closeDataStorageSave();
        }
        return header.objectNumber > 0;
    }

    public Record readNextObject() throws IOException {
        return Mif.readNextObject(this.header);
    }

    private static Record readNextObject(MifHeader header) throws IOException {
        String lineStr;
        Record rec = null;
        Dbf dbf = header.dbf;
        BufferedReader reader = header.reader;
        int fieldCount = dbf != null ? dbf.getNumFields() : header.fieldCountMid;
        while ((lineStr = reader.readLine()) != null) {
            Shape shp;
            int i;
            StringBuffer line = new StringBuffer(lineStr.toUpperCase());
            Strings.deleteSpaces(line);
            lineStr = line.toString();
            if (lineStr.startsWith(REGION) || lineStr.startsWith(PLINE_MULTIPLE) || lineStr.startsWith(PLINE)) {
                String figureName;
                boolean pline = false;
                if (lineStr.startsWith(REGION)) {
                    header.type = 3;
                    figureName = REGION;
                } else {
                    if (lineStr.startsWith(PLINE_MULTIPLE)) {
                        figureName = PLINE_MULTIPLE;
                    } else {
                        figureName = PLINE;
                        pline = true;
                    }
                    header.type = 2;
                }
                int count = Integer.parseInt(lineStr.substring(figureName.length()).trim());
                int ptCount = 0;
                if (pline) {
                    ptCount = count;
                    count = 1;
                }
                rec = new Record(fieldCount);
                for (i = 0; i < count; ++i) {
                    if (!pline) {
                        ptCount = Integer.parseInt(reader.readLine().trim());
                    }
                    shp = rec.newShape(ptCount);
                    for (int j = 0; j < ptCount; ++j) {
                        line = new StringBuffer(reader.readLine());
                        Strings.deleteSpaces(line);
                        lineStr = line.toString();
                        int space = lineStr.indexOf(32, 0);
                        shp.xCoords[j] = MapUtils.toDouble(lineStr.substring(0, space));
                        shp.yCoords[j] = MapUtils.toDouble(lineStr.substring(space + 1));
                    }
                }
            } else if (lineStr.startsWith(POINT)) {
                header.type = 1;
                lineStr = lineStr.substring(POINT.length());
                int space = lineStr.indexOf(32, 0);
                double x = MapUtils.toDouble(lineStr.substring(0, space));
                double y = MapUtils.toDouble(lineStr.substring(space + 1));
                rec = new Record(fieldCount);
                shp = rec.newShape(1);
                shp.setVertex(0, x, y);
            } else if (lineStr.startsWith(LINE)) {
                header.type = 2;
                lineStr = lineStr.substring(LINE.length());
                StringTokenizer stok = new StringTokenizer(lineStr, " \t");
                rec = new Record(fieldCount);
                Shape shp2 = rec.newShape(2);
                shp2.setVertex(0, MapUtils.toDouble(stok.nextToken()), MapUtils.toDouble(stok.nextToken()));
                shp2.setVertex(1, MapUtils.toDouble(stok.nextToken()), MapUtils.toDouble(stok.nextToken()));
            }
            if (rec == null) continue;
            if (dbf != null) {
                dbf.parseNextDbfRecord(rec);
            } else {
                Integer I = new Integer(0);
                Double F = new Double(0.0);
                StringBuffer str = Mif.GrabNextMidRec(header);
                Record rec2 = Csv.ParseCsvRecord(str.toString(), EMPTY, fieldCount);
                block12: for (i = 0; i < fieldCount; ++i) {
                    switch (header.fieldsType[i]) {
                        case 'C': 
                        case 'D': 
                        case 'L': {
                            rec.setField(i, rec2.getField(i));
                            continue block12;
                        }
                        case 'F': 
                        case 'N': {
                            try {
                                rec.setField(i, Double.valueOf((String)rec2.getField(i)));
                            }
                            catch (NumberFormatException e) {
                                rec.setField(i, F);
                            }
                            continue block12;
                        }
                        case 'I': {
                            try {
                                rec.setField(i, Integer.decode((String)rec2.getField(i)));
                                continue block12;
                            }
                            catch (NumberFormatException e) {
                                rec.setField(i, I);
                            }
                        }
                    }
                }
            }
            return rec;
        }
        return null;
    }

    private static StringBuffer GrabNextMidRec(MifHeader header) throws IOException {
        String lineStr = header.readerMid.readLine();
        StringBuffer line = new StringBuffer(lineStr);
        Strings.deleteSpaces(line);
        return line;
    }

    public int getFieldCount() {
        return this.header != null ? this.header.fieldCountMid : -1;
    }

    public String getFieldName(int i) {
        if (this.header != null && i >= 0 && i < this.header.fieldCountMid) {
            return this.header.fieldNames[i];
        }
        return null;
    }

    public char getFieldType(int i) {
        if (this.header != null && i >= 0 && i < this.header.fieldCountMid) {
            return this.header.fieldsType[i];
        }
        return '\u0000';
    }

    public int getFieldLen(int i) {
        if (this.header != null && i >= 0 && i < this.header.fieldCountMid) {
            return this.header.fieldLens[i];
        }
        return 0;
    }

    public int getFieldNumDec(int i) {
        if (this.header != null && i >= 0 && i < this.header.fieldCountMid) {
            return this.header.fieldNumDec[i];
        }
        return 0;
    }

    public int getFieldNumber(String name) {
        if (this.header != null) {
            for (int i = 0; i < this.header.fieldCountMid; ++i) {
                if (!name.equalsIgnoreCase(this.header.fieldNames[i])) continue;
                return i;
            }
        }
        return -1;
    }
}

