/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.FloatRectangle;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlParser;
import org.alov.util.XmlUtils;

public class Gml {
    public static final String ATTR_GML_DECIMAL = "decimal";
    public static final String ATTR_GML_CS = "cs";
    public static final String ATTR_GML_TS = "ts";
    public static final String EL_GML_COORD = "coord";
    public static final String EL_GML_COORDS = "coordinates";
    public static final String EL_GML_X = "X";
    public static final String EL_GML_Y = "Y";
    private static FloatRectangle global_rect;
    private static boolean isNewRect;
    public static int objectType;
    public static String[] f_names;
    public static String err_message;
    private static final String FEATURE_MEMBER = "featureMember";
    private static final String M_POINT = "MultiPoint";
    private static final String M_LINE = "MultiLineString";
    private static final String M_POLYGON = "MultiPolygon";
    private static final String _POINT = "Point";
    private static final String _LINE = "LineString";
    private static final String _POLYGON = "Polygon";
    private static final int GEOM_POINT = 1;
    private static final int GEOM_MULTIPOINT = 2;
    private static final int GEOM_LINE = 3;
    private static final int GEOM_MULTILINE = 4;
    private static final int GEOM_POLYGON = 5;
    private static final int GEOM_MULTIPOLYGON = 6;
    private static XmlElement child;

    public static void loadToLayer(InputStream in, LayerVector layer) throws Exception {
        try {
            err_message = null;
            XmlElement root = XmlParser.parseXml(in);
            Gml.parseGML(root, layer);
            layer.dataStorage.setObjectType(objectType);
            if (layer.dataStorage.size() == 0) {
                throw new AlovMapException(310, "Invalid file format. File must contain at least one feature");
            }
            layer.metadata.maxExtent = global_rect;
        }
        catch (Exception e) {
            err_message = e.getMessage();
            throw new Exception(err_message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseGML(XmlElement el, LayerVector layer) throws Exception {
        layer.dataStorage.openDataStorageSave(true);
        try {
            XmlElement box = el.getFirstElementByName("boundedBy");
            if (box != null) {
                box = box.getFirstElementByName("box");
                global_rect = Gml.getGMLBox(box);
                isNewRect = false;
            } else {
                global_rect = new FloatRectangle(0.0, 0.0, 0.0, 0.0);
                isNewRect = true;
            }
            XmlElement collection = Gml.findParentElement(el, FEATURE_MEMBER);
            if (collection == null) {
                return;
            }
            Vector children = collection.getChildren();
            int count = children.size();
            objectType = -1;
            for (int i = 0; i < count; ++i) {
                Record rec;
                child = (XmlElement)children.elementAt(i);
                if (!child.getNodeName().endsWith(FEATURE_MEMBER) || (rec = Gml.parseFeature(child)) == null) continue;
                layer.addRecord(rec);
            }
        }
        catch (Exception e) {
            if (Log.debugLevel > 1) {
                e.printStackTrace();
            }
        }
        finally {
            layer.dataStorage.closeDataStorageSave();
        }
    }

    private static XmlElement findParentElement(XmlElement root, String suffix) {
        XmlElement child;
        int i;
        Vector children = root.getChildren();
        if (children == null) {
            return null;
        }
        int count = children.size();
        for (i = 0; i < count; ++i) {
            child = (XmlElement)children.elementAt(i);
            if (!child.getNodeName().endsWith(suffix)) continue;
            return root;
        }
        for (i = 0; i < count; ++i) {
            child = (XmlElement)children.elementAt(i);
            XmlElement result = Gml.findParentElement(child, suffix);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Record parseFeature(XmlElement el) {
        int count;
        Vector children = el.getChildren();
        int n = count = children == null ? 0 : children.size();
        if (count != 1) {
            return null;
        }
        el = (XmlElement)children.elementAt(0);
        int fieldCount = 0;
        children = el.getChildren();
        count = children.size();
        String[] fieldNames = new String[count];
        Object[] fieldValues = new Object[count];
        for (int i = 0; i < count; ++i) {
            String nme;
            XmlElement child = (XmlElement)children.elementAt(i);
            Vector v2 = child.getChildren();
            if (v2 != null && v2.size() > 0) continue;
            String value = child.value;
            fieldNames[fieldCount] = nme = child.getNodeName();
            fieldValues[fieldCount] = child.value;
            ++fieldCount;
        }
        f_names = fieldNames;
        Object[] recordFieldValues = new Object[fieldCount];
        if (fieldCount > 0) {
            System.arraycopy(fieldValues, 0, recordFieldValues, 0, fieldCount);
        }
        XmlElement geometry = null;
        int geomType = -1;
        if (geometry == null) {
            geometry = Gml.findElement(el, M_POINT);
            geomType = 2;
        }
        if (geometry == null) {
            geometry = Gml.findElement(el, _POINT);
            geomType = 1;
        }
        if (geometry == null) {
            geometry = Gml.findElement(el, M_LINE);
            geomType = 4;
        }
        if (geometry == null) {
            geometry = Gml.findElement(el, _LINE);
            geomType = 3;
        }
        if (geometry == null) {
            geometry = Gml.findElement(el, M_POLYGON);
            geomType = 6;
        }
        if (geometry == null) {
            geometry = Gml.findElement(el, _POLYGON);
            geomType = 5;
        }
        Record record = null;
        if (geometry != null) {
            record = Gml.loadGeometry(geometry, geomType);
            if (record != null) {
                record.setFieldValues(recordFieldValues);
            }
            switch (geomType) {
                case 1: 
                case 2: {
                    objectType = 1;
                    break;
                }
                case 3: 
                case 4: {
                    objectType = 2;
                    break;
                }
                case 5: 
                case 6: {
                    objectType = 3;
                }
            }
        }
        return record;
    }

    private static void loadGeometryCollection(XmlElement el, int geomType, Vector shapes) {
        Vector coords = Gml.findAllElements(el, EL_GML_COORDS);
        int count = coords.size();
        for (int i = 0; i < count; ++i) {
            XmlElement coord = (XmlElement)coords.elementAt(i);
            Shape shp = Gml.loadShape(coord, geomType);
            if (shp == null) continue;
            shapes.addElement(shp);
        }
    }

    private static Record loadGeometry(XmlElement el, int geomType) {
        Record rec;
        Vector<Shape> shapes = new Vector<Shape>();
        switch (geomType) {
            case 1: 
            case 3: 
            case 5: {
                Shape shp = Gml.loadShape(el, geomType);
                if (shp == null) break;
                shapes.addElement(shp);
                break;
            }
            case 2: {
                Gml.loadGeometryCollection(el, geomType, shapes);
                break;
            }
            case 4: {
                Gml.loadGeometryCollection(el, geomType, shapes);
                break;
            }
            case 6: {
                Gml.loadGeometryCollection(el, geomType, shapes);
            }
        }
        int shpCount = shapes.size();
        if (shpCount > 0) {
            rec = new Record();
            rec.initShapes(shpCount);
            for (int i = 0; i < shpCount; ++i) {
                rec.setShape(i, (Shape)shapes.elementAt(i));
            }
        } else {
            rec = null;
        }
        return rec;
    }

    private static XmlElement findElement(XmlElement root, String suffix) {
        if (root.getNodeName().endsWith(suffix)) {
            return root;
        }
        Vector children = root.getChildren();
        if (children == null) {
            return null;
        }
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            XmlElement child = (XmlElement)children.elementAt(i);
            XmlElement result = Gml.findElement(child, suffix);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Vector findAllElements(XmlElement root, String suffix) {
        Vector<XmlElement> list = new Vector<XmlElement>();
        Vector children = root.getChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            XmlElement el = (XmlElement)children.elementAt(i);
            String tag = el.getNodeName();
            if (tag.endsWith(suffix)) {
                list.addElement(el);
            }
            Vector v = Gml.findAllElements(el, suffix);
            list.addAll(v);
        }
        return list;
    }

    private static Shape loadShape(XmlElement el, int type) {
        Shape shp = null;
        XmlElement coordinates = Gml.findElement(el, EL_GML_COORDS);
        if (coordinates != null) {
            shp = Gml.readCoordinates(coordinates, type == 5);
        }
        return shp;
    }

    private static Shape readCoordinates(XmlElement coords, boolean closed) {
        String coordSep;
        Shape shape = null;
        String val = coords.value;
        String pointSep = coords.getAttributeValue(ATTR_GML_TS);
        if (Strings.isNullOrBlank(pointSep)) {
            pointSep = " ";
        }
        if ((coordSep = coords.getAttributeValue(ATTR_GML_CS)) == null) {
            coordSep = ",";
        }
        int coordSepLen = coordSep.length();
        int allocBy = 50;
        int capacity = 0;
        int size = 0;
        double[] xs = null;
        double[] ys = null;
        StringTokenizer tok = new StringTokenizer(val, pointSep);
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            int pos = pair.indexOf(coordSep);
            if (pos <= 0) continue;
            String sx = pair.substring(0, pos);
            String sy = pair.substring(pos + coordSepLen);
            double x = Double.valueOf(sx);
            double y = Double.valueOf(sy);
            if (size >= capacity) {
                double[] nx = new double[capacity += 50];
                double[] ny = new double[capacity];
                if (size > 0) {
                    System.arraycopy(xs, 0, nx, 0, size);
                    System.arraycopy(ys, 0, ny, 0, size);
                }
                xs = nx;
                ys = ny;
            }
            xs[size] = x;
            ys[size] = y;
            if (isNewRect) {
                Gml.global_rect.x = x;
                Gml.global_rect.y = y;
                Gml.global_rect.x2 = x;
                Gml.global_rect.y2 = y;
                isNewRect = false;
            } else {
                if (x < Gml.global_rect.x) {
                    Gml.global_rect.x = x;
                }
                if (x > Gml.global_rect.x2) {
                    Gml.global_rect.x2 = x;
                }
                if (y < Gml.global_rect.y) {
                    Gml.global_rect.y = y;
                }
                if (y > Gml.global_rect.y2) {
                    Gml.global_rect.y2 = y;
                }
            }
            ++size;
        }
        if (closed && size > 0) {
            --size;
        }
        shape = new Shape();
        shape.xCoords = new double[size];
        shape.yCoords = new double[size];
        if (size > 0) {
            System.arraycopy(xs, 0, shape.xCoords, 0, size);
            System.arraycopy(ys, 0, shape.yCoords, 0, size);
        }
        return shape;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FloatRectangle getGMLBox(XmlElement root) throws Exception {
        float xmin = -180.0f;
        float xmax = 180.0f;
        float ymin = -90.0f;
        float ymax = 90.0f;
        Vector v = root.getElementsByTagName(EL_GML_COORD);
        if (v == null || v.size() != 2) {
            XmlElement el = root.getFirstElementByName(EL_GML_COORDS);
            if (el == null) throw new Exception("Box element must contain two <coord> tags or one <coordinates> tag");
            String decimal = ".";
            String cs = ",";
            String ts = " ";
            String val = el.getAttributeValue(ATTR_GML_DECIMAL);
            if (val != null) {
                decimal = val;
            }
            if ((val = el.getAttributeValue(ATTR_GML_CS)) != null) {
                cs = val;
            }
            if ((val = el.getAttributeValue(ATTR_GML_TS)) != null) {
                ts = val;
            }
            val = el.value;
            int coordSepLen = cs.length();
            int count = 0;
            StringTokenizer tok = new StringTokenizer(val, ts);
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int pos = pair.indexOf(cs);
                if (pos <= 0) continue;
                String sx = pair.substring(0, pos);
                String sy = pair.substring(pos + coordSepLen);
                if (count == 0) {
                    xmin = Double.valueOf(sx).floatValue();
                    ymin = Double.valueOf(sy).floatValue();
                } else {
                    xmax = Double.valueOf(sx).floatValue();
                    ymax = Double.valueOf(sy).floatValue();
                }
                ++count;
            }
            return new FloatRectangle(Math.min(xmin, xmax), Math.min(ymin, ymax), Math.max(xmax, xmin), Math.max(ymax, ymin));
        } else {
            boolean bError = false;
            XmlElement el = (XmlElement)v.elementAt(0);
            XmlElement elX = el.getFirstElementByName(EL_GML_X);
            if (elX != null) {
                xmin = XmlUtils.getElFloat(EL_GML_X, el, xmin);
            } else {
                bError = true;
            }
            XmlElement elY = el.getFirstElementByName(EL_GML_Y);
            if (elY != null) {
                ymin = XmlUtils.getElFloat(EL_GML_Y, el, ymin);
            } else {
                bError = true;
            }
            el = (XmlElement)v.elementAt(1);
            elX = el.getFirstElementByName(EL_GML_X);
            if (elX != null) {
                xmax = XmlUtils.getElFloat(EL_GML_X, el, xmax);
            } else {
                bError = true;
            }
            elY = el.getFirstElementByName(EL_GML_Y);
            if (elY != null) {
                ymax = XmlUtils.getElFloat(EL_GML_Y, el, ymax);
            } else {
                bError = true;
            }
            if (!bError) return new FloatRectangle(Math.min(xmin, xmax), Math.min(ymin, ymax), Math.max(xmax, xmin), Math.max(ymax, ymin));
            throw new Exception("Invalid box format (coord tags)");
        }
    }

    static {
        isNewRect = true;
        objectType = -1;
        child = null;
    }
}

