/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alov.data.DbfConsts;
import org.alov.map.LayerVector;
import org.alov.map.Record;
import org.alov.map.Shape;
import org.alov.util.AlovMapException;
import org.alov.util.ExDate;
import org.alov.util.Readers;
import org.alov.util.Strings;

public class Dbf
implements DbfConsts {
    private int dbf_id;
    private int last_update_d;
    private int last_update_m;
    private int last_update_y;
    private int last_rec;
    private int position = -1;
    private int data_offset;
    private int rec_size;
    private StringBuffer[] records = null;
    private boolean hasmemo;
    private int filesize;
    private int numfields;
    private DataInputStream dataInput = null;
    private String encoding = null;
    public DbfFieldDef[] fielddef = null;

    public Dbf(InputStream in, String encoding) throws IOException {
        this(in, encoding, true);
    }

    public Dbf(InputStream in, String encoding, boolean loadFully) throws IOException {
        this.encoding = Strings.isNullOrBlank(encoding) ? Readers.ENCODING : encoding;
        this.dataInput = new DataInputStream(in);
        this.init();
        if (loadFully) {
            this.records = this.GrabFile();
        }
    }

    public void clear() {
        int i;
        if (this.records != null) {
            for (i = 0; i < this.records.length; ++i) {
                this.records[i] = null;
            }
            this.records = null;
        }
        if (this.fielddef != null) {
            for (i = 0; i < this.fielddef.length; ++i) {
                this.fielddef[i] = null;
            }
            this.fielddef = null;
        }
    }

    public int getLastRec() {
        return this.last_rec;
    }

    public int getNumFields() {
        return this.numfields;
    }

    public int getFieldNumber(String name) {
        for (int i = 0; i < this.numfields; ++i) {
            if (!name.equalsIgnoreCase(this.fielddef[i].fieldname.toString())) continue;
            return i;
        }
        return -1;
    }

    public StringBuffer getFieldName(int col) {
        return this.fielddef[col].fieldname;
    }

    public char getFieldType(int col) {
        return this.fielddef[col].fieldtype;
    }

    private void init() throws IOException {
        DbfFileHeader head = new DbfFileHeader(this.dataInput);
        this.fielddef = new DbfFieldDef[this.numfields];
        int widthsofar = 1;
        for (int index = 0; index < this.numfields; ++index) {
            this.fielddef[index] = new DbfFieldDef(this.dataInput, widthsofar);
            widthsofar += this.fielddef[index].fieldlen;
        }
        this.dataInput.skipBytes(1);
        this.position = -1;
    }

    private StringBuffer grabNextDbfRec() throws IOException {
        StringBuffer record = new StringBuffer(this.rec_size + this.numfields);
        if (this.position >= this.last_rec) {
            return record;
        }
        long skipped = 1L;
        while (skipped > 0L) {
            char delSymbol = (char)this.dataInput.readUnsignedByte();
            if (delSymbol != ' ') {
                skipped = this.dataInput.skip(this.rec_size - 1);
                --this.last_rec;
                if (this.position != this.last_rec) continue;
                return record;
            }
            record.append(delSymbol);
            break;
        }
        for (int i = 1; i < this.rec_size; ++i) {
            char cc = (char)this.dataInput.readUnsignedByte();
            record.append(cc);
        }
        return record;
    }

    private StringBuffer[] GrabFile() throws IOException {
        StringBuffer[] records = new StringBuffer[this.last_rec];
        this.position = 0;
        while (this.position < this.last_rec) {
            records[this.position] = this.grabNextDbfRec();
            ++this.position;
        }
        this.position = -1;
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseNextDbfRecord(Record record) throws IOException {
        ++this.position;
        StringBuffer rec = this.records == null ? this.grabNextDbfRec() : this.records[this.position];
        try {
            if (record != null) {
                String t;
                Integer I = new Integer(0);
                Double F = new Double(0.0);
                String string = t = rec == null ? "" : rec.toString();
                if ("&".equals(t) || t.length() < 1) {
                    record = null;
                } else {
                    String s;
                    int lenS = t.length();
                    block13: for (int i = 0; i < this.numfields; ++i) {
                        s = this.fielddef[i].fieldstart > lenS ? "" : t.substring(this.fielddef[i].fieldstart, this.fielddef[i].fieldstart + this.fielddef[i].fieldlen).trim();
                        switch (this.fielddef[i].fieldtype) {
                            case 'C': {
                                record.setField(i, Readers.Read2Unicode(s, this.encoding).trim());
                                continue block13;
                            }
                            case 'D': {
                                record.setField(i, ExDate.parseDBFstring(s));
                                continue block13;
                            }
                            case 'F': 
                            case 'I': 
                            case 'N': {
                                if (this.fielddef[i].fieldnumdec > 0) {
                                    try {
                                        record.setField(i, Double.valueOf(s));
                                    }
                                    catch (NumberFormatException e) {
                                        record.setField(i, F);
                                    }
                                    continue block13;
                                }
                                try {
                                    record.setField(i, Integer.decode(s));
                                }
                                catch (NumberFormatException e) {
                                    record.setField(i, I);
                                }
                                continue block13;
                            }
                            case 'L': {
                                record.setField(i, s);
                                continue block13;
                            }
                        }
                    }
                    s = null;
                }
            }
        }
        finally {
            rec = null;
        }
    }

    public void loadToLayer(LayerVector layer) throws AlovMapException {
        layer.dataStorage.openDataStorageSave(true);
        try {
            int fi_xmin = -1;
            int fi_xmax = -1;
            int fi_ymin = -1;
            int fi_ymax = -1;
            int fi_x = -1;
            int fi_y = -1;
            String sNotFound = "Coordinate fields not found";
            if (layer.isObjectType(4) || layer.isObjectType(2)) {
                fi_xmin = layer.getFieldIndex(layer.f_xmin);
                fi_xmax = layer.getFieldIndex(layer.f_xmax);
                fi_ymin = layer.getFieldIndex(layer.f_ymin);
                fi_ymax = layer.getFieldIndex(layer.f_ymax);
                if (fi_xmin < 0 && fi_xmax < 0 && fi_ymin < 0 && fi_ymax < 0) {
                    fi_xmin = layer.getFieldIndex("xmin");
                    fi_xmax = layer.getFieldIndex("xmax");
                    fi_ymin = layer.getFieldIndex("ymin");
                    fi_ymax = layer.getFieldIndex("ymax");
                }
                if (fi_xmin < 0 || fi_xmax < 0 || fi_ymin < 0 || fi_ymax < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
                if (!layer.isObjectType(2)) {
                    layer.dataStorage.setObjectType(3);
                }
            } else {
                layer.dataStorage.setObjectType(1);
                fi_x = layer.getFieldIndex(layer.f_x);
                fi_y = layer.getFieldIndex(layer.f_y);
                if (fi_x < 0 && fi_y < 0) {
                    fi_x = layer.getFieldIndex("LONG");
                    fi_y = layer.getFieldIndex("LAT");
                }
                if (fi_x < 0 && fi_y < 0) {
                    fi_x = layer.getFieldIndex("LONGITUDE");
                    fi_y = layer.getFieldIndex("LATITUDE");
                }
                if (fi_x < 0 && fi_y < 0) {
                    fi_x = layer.getFieldIndex("X");
                    fi_y = layer.getFieldIndex("Y");
                }
                if (fi_x < 0 || fi_y < 0) {
                    throw new AlovMapException(303, "Coordinate fields not found");
                }
            }
            int count = this.records.length;
            int fieldCount = this.getNumFields();
            for (int i = 0; i < count; ++i) {
                Shape shp;
                Record rec = new Record(fieldCount);
                this.parseNextDbfRecord(rec);
                if (rec == null) continue;
                if (layer.isObjectType(3)) {
                    shp = rec.newShape(4);
                    shp.xCoords[0] = layer.getFieldDouble(rec, fi_xmin);
                    shp.yCoords[0] = layer.getFieldDouble(rec, fi_ymin);
                    shp.xCoords[1] = shp.xCoords[0];
                    shp.yCoords[1] = layer.getFieldDouble(rec, fi_ymax);
                    shp.xCoords[2] = layer.getFieldDouble(rec, fi_xmax);
                    shp.yCoords[2] = shp.yCoords[1];
                    shp.xCoords[3] = shp.xCoords[2];
                    shp.yCoords[3] = shp.yCoords[0];
                } else if (layer.isObjectType(2)) {
                    shp = rec.newShape(2);
                    shp.xCoords[0] = layer.getFieldDouble(rec, fi_xmin);
                    shp.yCoords[0] = layer.getFieldDouble(rec, fi_ymin);
                    shp.xCoords[1] = layer.getFieldDouble(rec, fi_xmax);
                    shp.yCoords[1] = layer.getFieldDouble(rec, fi_ymax);
                } else {
                    shp = rec.newShape(1);
                    shp.xCoords[0] = layer.getFieldDouble(rec, fi_x);
                    shp.yCoords[0] = layer.getFieldDouble(rec, fi_y);
                }
                layer.addRecord(rec);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlovMapException(106, e.getMessage());
        }
        finally {
            layer.dataStorage.closeDataStorageSave();
        }
    }

    public class DbfFieldDef {
        public StringBuffer fieldname = new StringBuffer(11);
        public char fieldtype;
        public int fieldstart;
        public int fieldlen;
        public int fieldnumdec;

        DbfFieldDef(DataInputStream in, int pos) throws IOException {
            boolean allow = true;
            for (int i = 0; i < 11; ++i) {
                char c = (char)in.readUnsignedByte();
                if (c > '\u0000' && allow) {
                    this.fieldname.append(c);
                    continue;
                }
                if (this.fieldname.length() <= 0) continue;
                allow = false;
            }
            this.fieldtype = (char)in.readUnsignedByte();
            this.fieldstart = pos;
            in.skipBytes(4);
            switch (this.fieldtype) {
                case 'C': 
                case 'D': 
                case 'G': 
                case 'L': 
                case 'M': 
                case 'c': {
                    this.fieldlen = in.readUnsignedByte();
                    this.fieldnumdec = in.readUnsignedByte();
                    this.fieldnumdec = 0;
                    break;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    this.fieldlen = in.readUnsignedByte();
                    this.fieldnumdec = in.readUnsignedByte();
                    if (this.fieldnumdec != 0) break;
                    this.fieldtype = (char)73;
                    break;
                }
            }
            in.skipBytes(14);
        }
    }

    class DbfFileHeader {
        DbfFileHeader(DataInputStream file) throws IOException {
            this.getDbfFileHeader(file);
        }

        private void getDbfFileHeader(DataInputStream file) throws IOException {
            Dbf.this.dbf_id = file.readUnsignedByte();
            if (Dbf.this.dbf_id == 3) {
                Dbf.this.hasmemo = true;
            } else {
                Dbf.this.hasmemo = false;
            }
            Dbf.this.last_update_y = file.readUnsignedByte();
            Dbf.this.last_update_m = file.readUnsignedByte();
            Dbf.this.last_update_d = file.readUnsignedByte();
            Dbf.this.last_rec = Readers.readInt(file);
            Dbf.this.data_offset = Readers.readShort(file);
            Dbf.this.rec_size = Readers.readShort(file);
            Dbf.this.filesize = Dbf.this.rec_size * Dbf.this.last_rec + Dbf.this.data_offset + 1;
            Dbf.this.numfields = (Dbf.this.data_offset - 32 - 1) / 32;
            file.skipBytes(20);
        }
    }
}

