/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import org.alov.data.DataProvider;
import org.alov.data.Jpeg2000;
import org.alov.map.Layer;
import org.alov.map.LayerRaster;
import org.alov.map.MapUtils;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;

public class DataProviderImg
extends DataProvider {
    public DataProviderImg(Layer lyr) {
        super(lyr);
    }

    public String loadComplete() throws AlovMapException {
        String baseUrl;
        String xmlUrl = null;
        LayerRaster layerRaster = (LayerRaster)this.layer;
        if (this.layer.connectionData == null || (baseUrl = this.layer.connectionData.getProperty("url")) == null) {
            throw new AlovMapException(105, this.layer.getName());
        }
        if (this.layer.serverType != 11 && this.layer.serverType != 34 && this.layer.serverType != 15) {
            String s;
            if (Strings.checkSuffix(baseUrl, ".tmm")) {
                baseUrl = Strings.changeSuffix(baseUrl, ".jpg");
            }
            if (this.layer.metadata.isNotLoaded) {
                try {
                    xmlUrl = Strings.changeSuffix(baseUrl, ".tmm");
                    StreamCounter sc = this.openURL(xmlUrl);
                    this.layer.metadata.loadMetadata(sc);
                    xmlUrl = sc.url;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!this.layer.metadata.isNotLoaded && (s = this.layer.metadata.getVal(123)) != null && xmlUrl != null) {
                baseUrl = Strings.getAbsPath(Strings.extractDir(xmlUrl), s);
            }
            if (this.layer.metadata.isNotLoaded) {
                xmlUrl = Strings.changeSuffix(baseUrl, ".xml");
                try {
                    this.layer.metadata.loadMetadata(this.openURL(xmlUrl));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.layer.metadata.isNotLoaded || this.layer.metadata.getDouble(144) == 0.0 && this.layer.metadata.getDouble(145) == 0.0) {
                int dot = baseUrl.lastIndexOf(".");
                String ext = baseUrl.substring(dot);
                ext = ext.substring(0, 2) + ext.charAt(ext.length() - 1) + 'w';
                String worldfileUrl = Strings.changeSuffix(baseUrl, ext);
                try {
                    this.layer.metadata.loadWorldfile(this.openURL(worldfileUrl));
                }
                catch (AlovMapException e2) {
                    throw e2;
                }
                catch (Exception e2) {
                    Log.addMessage(0, this.layer.getMap() != null ? this.layer.getMap().getName() : null, this.layer, "WARNING#301Registration parameters not found. " + xmlUrl + "  " + "OR" + "  " + worldfileUrl);
                }
            }
        }
        layerRaster.imageUrl = baseUrl;
        this.layer.metadata.put(168, "imagefile");
        layerRaster.resolveMetadata();
        this.loadRaster();
        this.layer.prepareLayer();
        return "";
    }

    public void loadRaster() throws AlovMapException {
        LayerRaster layerRaster = (LayerRaster)this.layer;
        String baseUrl = layerRaster.imageUrl;
        if (!this.layer.isDataOnServer && layerRaster.isEmpty()) {
            if (Strings.checkSuffix(baseUrl, ".j2k")) {
                try {
                    Class<?> cls = Class.forName("org.alov.data.Jpeg2000");
                    layerRaster.setRaster(Jpeg2000.Execute(baseUrl, MapUtils.codeBase, layerRaster.resolutionLevel));
                }
                catch (ClassNotFoundException e) {
                    throw new AlovMapException(111, "Jpeg2000 loader is not found.");
                }
                catch (Exception e) {
                    throw new AlovMapException(306, "Can't load raster image " + baseUrl + "  " + e.getMessage());
                }
            } else if (Strings.checkSuffix(baseUrl, ".jpg") || Strings.checkSuffix(baseUrl, ".gif") || Strings.checkSuffix(baseUrl, ".png")) {
                try {
                    layerRaster.setImage(MapUtils.loadImageToByteArray(this.layer, baseUrl));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new AlovMapException(306, "Can't load raster image " + baseUrl + "  " + e.getMessage());
                }
            } else {
                throw new AlovMapException(110, baseUrl);
            }
        }
    }
}

